/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.image4j.io;

import com.fr.stable.image4j.io.EndianUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianOutputStream
extends DataOutputStream {
    public LittleEndianOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeShortLE(short s2) throws IOException {
        s2 = EndianUtils.swapShort(s2);
        super.writeShort(s2);
    }

    public void writeIntLE(int n2) throws IOException {
        n2 = EndianUtils.swapInteger(n2);
        super.writeInt(n2);
    }

    public void writeFloatLE(float f2) throws IOException {
        f2 = EndianUtils.swapFloat(f2);
        super.writeFloat(f2);
    }

    public void writeLongLE(long l2) throws IOException {
        l2 = EndianUtils.swapLong(l2);
        super.writeLong(l2);
    }

    public void writeDoubleLE(double d2) throws IOException {
        d2 = EndianUtils.swapDouble(d2);
        super.writeDouble(d2);
    }

    public void writeUnsignedInt(long l2) throws IOException {
        int n2 = (int)(l2 >> 24);
        int n3 = (int)(l2 >> 16 & 0xFFL);
        int n4 = (int)(l2 >> 8 & 0xFFL);
        int n5 = (int)(l2 & 0xFFL);
        this.write(n2);
        this.write(n3);
        this.write(n4);
        this.write(n5);
    }

    public void writeUnsignedIntLE(long l2) throws IOException {
        int n2 = (int)(l2 >> 24);
        int n3 = (int)(l2 >> 16 & 0xFFL);
        int n4 = (int)(l2 >> 8 & 0xFFL);
        int n5 = (int)(l2 & 0xFFL);
        this.write(n5);
        this.write(n4);
        this.write(n3);
        this.write(n2);
    }
}

