/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.Array;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMap<K, V>
implements Iterable<Entry<K, V>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    public int size;
    K[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public ObjectMap() {
        this(51, 0.8f);
    }

    public ObjectMap(int n2) {
        this(n2, 0.8f);
    }

    public ObjectMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if ((n2 = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / f2))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = n2;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public ObjectMap(ObjectMap<? extends K, ? extends V> objectMap) {
        this((int)Math.floor((float)objectMap.capacity * objectMap.loadFactor), objectMap.loadFactor);
        this.stashSize = objectMap.stashSize;
        System.arraycopy(objectMap.keyTable, 0, this.keyTable, 0, objectMap.keyTable.length);
        System.arraycopy(objectMap.valueTable, 0, this.valueTable, 0, objectMap.valueTable.length);
        this.size = objectMap.size;
    }

    public V put(K k2, V v2) {
        if (k2 == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        return this.put_internal(k2, v2);
    }

    private V put_internal(K k2, V v2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = k2.hashCode();
        int n4 = n3 & this.mask;
        K k3 = KArray[n4];
        if (k2.equals(k3)) {
            V v3 = this.valueTable[n4];
            this.valueTable[n4] = v2;
            return v3;
        }
        int n5 = this.hash2(n3);
        K k4 = KArray[n5];
        if (k2.equals(k4)) {
            V v4 = this.valueTable[n5];
            this.valueTable[n5] = v2;
            return v4;
        }
        int n6 = this.hash3(n3);
        K k5 = KArray[n6];
        if (k2.equals(k5)) {
            V v5 = this.valueTable[n6];
            this.valueTable[n6] = v2;
            return v5;
        }
        int n7 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n7; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            V v6 = this.valueTable[n2];
            this.valueTable[n2] = v2;
            return v6;
        }
        if (k3 == null) {
            KArray[n4] = k2;
            this.valueTable[n4] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (k4 == null) {
            KArray[n5] = k2;
            this.valueTable[n5] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (k5 == null) {
            KArray[n6] = k2;
            this.valueTable[n6] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(k2, v2, n4, k3, n5, k4, n6, k5);
        return null;
    }

    public void putAll(ObjectMap<K, V> objectMap) {
        this.ensureCapacity(objectMap.size);
        for (Entry entry : objectMap) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(K k2, V v2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        K k3 = this.keyTable[n3];
        if (k3 == null) {
            this.keyTable[n3] = k2;
            this.valueTable[n3] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash2(n2);
        K k4 = this.keyTable[n4];
        if (k4 == null) {
            this.keyTable[n4] = k2;
            this.valueTable[n4] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash3(n2);
        K k5 = this.keyTable[n5];
        if (k5 == null) {
            this.keyTable[n5] = k2;
            this.valueTable[n5] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k2, v2, n3, k3, n4, k4, n5, k5);
    }

    private void push(K k2, V v2, int n2, K k3, int n3, K k4, int n4, K k5) {
        V v3;
        K k6;
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n5 = this.mask;
        int n6 = 0;
        int n7 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    k6 = k3;
                    v3 = VArray[n2];
                    KArray[n2] = k2;
                    VArray[n2] = v2;
                    break;
                }
                case 1: {
                    k6 = k4;
                    v3 = VArray[n3];
                    KArray[n3] = k2;
                    VArray[n3] = v2;
                    break;
                }
                default: {
                    k6 = k5;
                    v3 = VArray[n4];
                    KArray[n4] = k2;
                    VArray[n4] = v2;
                }
            }
            int n8 = k6.hashCode();
            n2 = n8 & n5;
            k3 = KArray[n2];
            if (k3 == null) {
                KArray[n2] = k6;
                VArray[n2] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash2(n8);
            k4 = KArray[n3];
            if (k4 == null) {
                KArray[n3] = k6;
                VArray[n3] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash3(n8);
            k5 = KArray[n4];
            if (k5 == null) {
                KArray[n4] = k6;
                VArray[n4] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n6 == n7) break;
            k2 = k6;
            v2 = v3;
        }
        this.putStash(k6, v3);
    }

    private void putStash(K k2, V v2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put_internal(k2, v2);
            return;
        }
        int n2 = this.capacity + this.stashSize;
        this.keyTable[n2] = k2;
        this.valueTable[n2] = v2;
        ++this.stashSize;
        ++this.size;
    }

    public V get(K k2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        if (!(k2.equals(this.keyTable[n3]) || k2.equals(this.keyTable[n3 = this.hash2(n2)]) || k2.equals(this.keyTable[n3 = this.hash3(n2)]))) {
            return this.getStash(k2);
        }
        return this.valueTable[n3];
    }

    private V getStash(K k2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            return this.valueTable[n2];
        }
        return null;
    }

    public V get(K k2, V v2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        if (!(k2.equals(this.keyTable[n3]) || k2.equals(this.keyTable[n3 = this.hash2(n2)]) || k2.equals(this.keyTable[n3 = this.hash3(n2)]))) {
            return this.getStash(k2, v2);
        }
        return this.valueTable[n3];
    }

    private V getStash(K k2, V v2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            return this.valueTable[n2];
        }
        return v2;
    }

    public V remove(K k2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        if (k2.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            V v2 = this.valueTable[n3];
            this.valueTable[n3] = null;
            --this.size;
            return v2;
        }
        n3 = this.hash2(n2);
        if (k2.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            V v3 = this.valueTable[n3];
            this.valueTable[n3] = null;
            --this.size;
            return v3;
        }
        n3 = this.hash3(n2);
        if (k2.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            V v4 = this.valueTable[n3];
            this.valueTable[n3] = null;
            --this.size;
            return v4;
        }
        return this.removeStash(k2);
    }

    V removeStash(K k2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            V v2 = this.valueTable[n2];
            this.removeStashIndex(n2);
            --this.size;
            return v2;
        }
        return null;
    }

    void removeStashIndex(int n2) {
        --this.stashSize;
        int n3 = this.capacity + this.stashSize;
        if (n2 < n3) {
            this.keyTable[n2] = this.keyTable[n3];
            this.valueTable[n2] = this.valueTable[n3];
            this.valueTable[n3] = null;
        } else {
            this.valueTable[n2] = null;
        }
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.size > n2) {
            n2 = this.size;
        }
        if (this.capacity <= n2) {
            return;
        }
        n2 = MathUtils.nextPowerOfTwo(n2);
        this.resize(n2);
    }

    public void clear(int n2) {
        if (this.capacity <= n2) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            KArray[n2] = null;
            VArray[n2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean containsValue(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            K[] KArray = this.keyTable;
            int n2 = this.capacity + this.stashSize;
            while (n2-- > 0) {
                if (KArray[n2] == null || VArray[n2] != null) continue;
                return true;
            }
        } else if (bl) {
            int n3 = this.capacity + this.stashSize;
            while (n3-- > 0) {
                if (VArray[n3] != object) continue;
                return true;
            }
        } else {
            int n4 = this.capacity + this.stashSize;
            while (n4-- > 0) {
                if (!object.equals(VArray[n4])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(K k2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        if (!(k2.equals(this.keyTable[n3]) || k2.equals(this.keyTable[n3 = this.hash2(n2)]) || k2.equals(this.keyTable[n3 = this.hash3(n2)]))) {
            return this.containsKeyStash(k2);
        }
        return true;
    }

    private boolean containsKeyStash(K k2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            return true;
        }
        return false;
    }

    public K findKey(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            K[] KArray = this.keyTable;
            int n2 = this.capacity + this.stashSize;
            while (n2-- > 0) {
                if (KArray[n2] == null || VArray[n2] != null) continue;
                return KArray[n2];
            }
        } else if (bl) {
            int n3 = this.capacity + this.stashSize;
            while (n3-- > 0) {
                if (VArray[n3] != object) continue;
                return this.keyTable[n3];
            }
        } else {
            int n4 = this.capacity + this.stashSize;
            while (n4-- > 0) {
                if (!object.equals(VArray[n4])) continue;
                return this.keyTable[n4];
            }
        }
        return null;
    }

    public void ensureCapacity(int n2) {
        int n3 = this.size + n2;
        if (n3 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n3 / this.loadFactor)));
        }
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new Object[n2 + this.stashCapacity];
        this.valueTable = new Object[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                K k2 = KArray[i2];
                if (k2 == null) continue;
                this.putResize(k2, VArray[i2]);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n2 = 0;
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n3 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n3; ++i2) {
            K k2 = KArray[i2];
            if (k2 == null) continue;
            n2 += k2.hashCode() * 31;
            V v2 = VArray[i2];
            if (v2 == null) continue;
            n2 += v2.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectMap)) {
            return false;
        }
        ObjectMap objectMap = (ObjectMap)object;
        if (objectMap.size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2;
            K k2 = KArray[i2];
            if (k2 == null || !((v2 = VArray[i2]) == null ? !objectMap.containsKey(k2) || objectMap.get(k2) != null : !v2.equals(objectMap.get(k2)))) continue;
            return false;
        }
        return true;
    }

    public String toString(String string) {
        return this.toString(string, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    private String toString(String string, boolean bl) {
        K k2;
        if (this.size == 0) {
            return bl ? "{}" : "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl) {
            stringBuilder.append('{');
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = KArray.length;
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
            break;
        }
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
        }
        if (bl) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public Entries<K, V> iterator() {
        return this.entries();
    }

    public Entries<K, V> entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values<V> values() {
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys<K> keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Keys<K>
    extends MapIterator<K, Object, K> {
        public Keys(ObjectMap<K, ?> objectMap) {
            super(objectMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object k2 = this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return k2;
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        public Array<K> toArray() {
            return this.toArray(new Array(true, this.map.size));
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Values<V>
    extends MapIterator<Object, V, V> {
        public Values(ObjectMap<?, V> objectMap) {
            super(objectMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object v2 = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return v2;
        }

        @Override
        public Values<V> iterator() {
            return this;
        }

        public Array<V> toArray() {
            return this.toArray(new Array(true, this.map.size));
        }

        public Array<V> toArray(Array<V> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries<K, V>
    extends MapIterator<K, V, Entry<K, V>> {
        Entry<K, V> entry = new Entry();

        public Entries(ObjectMap<K, V> objectMap) {
            super(objectMap);
        }

        @Override
        public Entry<K, V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            K[] KArray = this.map.keyTable;
            this.entry.key = KArray[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public Entries<K, V> iterator() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MapIterator<K, V, I>
    implements Iterable<I>,
    Iterator<I> {
        public boolean hasNext;
        final ObjectMap<K, V> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(ObjectMap<K, V> objectMap) {
            this.map = objectMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            this.hasNext = false;
            K[] KArray = this.map.keyTable;
            int n2 = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n2) {
                if (KArray[this.nextIndex] == null) continue;
                this.hasNext = true;
                break;
            }
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.currentIndex >= this.map.capacity) {
                this.map.removeStashIndex(this.currentIndex);
                this.nextIndex = this.currentIndex - 1;
                this.findNextIndex();
            } else {
                this.map.keyTable[this.currentIndex] = null;
                this.map.valueTable[this.currentIndex] = null;
            }
            this.currentIndex = -1;
            --this.map.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K, V> {
        public K key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

