/*
 * Decompiled with CFR 0.152.
 */
package com.fr.record;

import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.AbstractModuleTables;
import com.fr.data.core.db.tableObject.AbstractTableObject;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.core.db.tableObject.TableObject;
import com.fr.general.FRLogger;
import com.fr.record.DBRecordManager;
import com.fr.stable.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RecordTables
extends AbstractModuleTables {
    private List<String> indexList = new ArrayList<String>();

    protected void initTableObjectList() {
        this.tableObjectList.add(new FR_EXECUTERECORD());
        this.tableObjectList.add(new FR_EXPORTRECORD());
        this.tableObjectList.add(new FR_PRINTRECORD());
        this.tableObjectList.add(new FR_ERRORRECORD());
        this.tableObjectList.add(new FR_SCHEDULERECORD());
        this.tableObjectList.add(new FR_FSRECORD());
        this.addNewColumnToTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewColumnToTable() {
        Connection connection = null;
        try {
            connection = DBRecordManager.getDB().createConnection();
            connection.setAutoCommit(false);
            Dialect dialect = DialectFactory.generateDialect(connection);
            int n2 = this.tableObjectList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Table table = ((TableObject)this.tableObjectList.get(i2)).getTable();
                if (table == null) continue;
                TableObject tableObject = (TableObject)this.tableObjectList.get(i2);
                tableObject.addNewColumnCompatibleOld(connection, dialect);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        finally {
            DBUtils.closeConnection(connection);
        }
    }

    protected void initIndexList(Connection connection) {
        Dialect dialect = DialectFactory.generateDialect(connection);
        this.indexList.add(this.createNTRecordIndexSQL("fr_exerecord", dialect));
        this.indexList.add(this.createNTRecordIndexSQL("fr_exprecord", dialect));
        this.indexList.add(this.createNTRecordIndexSQL("fr_ptrecord", dialect));
        this.indexList.add(this.createErrIndexSQL(dialect));
        this.indexList.add(this.createScheduleIndexSQL(dialect));
        this.indexList.add(this.createFSIndexSQL(dialect));
    }

    public void generateIndexs(Connection connection) {
        this.initIndexList(connection);
        PreparedStatement preparedStatement = null;
        int n2 = this.indexList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                String string = this.indexList.get(i2);
                if (StringUtils.isBlank(string)) continue;
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.execute();
                connection.commit();
                FRLogger.getLogger().info("Index has been created successfully!");
                preparedStatement.close();
                continue;
            }
            catch (Throwable throwable) {
                if (throwable.getMessage().contains("already exists") || throwable.getMessage().contains("Duplicate key name")) continue;
                FRLogger.getLogger().info("Index created failed!");
                try {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private String createNTRecordIndexSQL(String string, Dialect dialect) {
        StringBuffer stringBuffer = new StringBuffer("create index ");
        stringBuffer.append(string).append("_index on ");
        stringBuffer.append(dialect.table2SQL(new Table(string))).append("(");
        stringBuffer.append(dialect.column2SQL("logtime")).append(" asc, ");
        stringBuffer.append(dialect.column2SQL("type")).append(" asc)");
        return stringBuffer.toString();
    }

    private String createErrIndexSQL(Dialect dialect) {
        StringBuffer stringBuffer = new StringBuffer("create index ");
        stringBuffer.append("fr_errrecord").append("_index on ");
        stringBuffer.append(dialect.table2SQL(new Table("fr_errrecord"))).append("(");
        stringBuffer.append(dialect.column2SQL("logtime")).append(" asc, ");
        stringBuffer.append(dialect.column2SQL("type")).append(" asc)");
        return stringBuffer.toString();
    }

    private String createScheduleIndexSQL(Dialect dialect) {
        StringBuffer stringBuffer = new StringBuffer("create index ");
        stringBuffer.append("fr_schedulerecord").append("_index on ");
        stringBuffer.append(dialect.table2SQL(new Table("fr_schedulerecord"))).append("(");
        stringBuffer.append(dialect.column2SQL("logtime")).append(" asc, ");
        stringBuffer.append(dialect.column2SQL("type")).append(" asc)");
        return stringBuffer.toString();
    }

    private String createFSIndexSQL(Dialect dialect) {
        StringBuffer stringBuffer = new StringBuffer("create index ");
        stringBuffer.append("fr_fsrecord").append("_index on ");
        stringBuffer.append(dialect.table2SQL(new Table("fr_fsrecord"))).append("(");
        stringBuffer.append(dialect.column2SQL("logtime")).append(" asc, ");
        stringBuffer.append(dialect.column2SQL("username")).append(" asc)");
        return stringBuffer.toString();
    }

    private class FR_FSRECORD
    extends AbstractTableObject {
        private FR_FSRECORD() {
        }

        public Table getTable() {
            return new Table("fr_fsrecord");
        }

        public void initColumns() {
            this.addColumn("ID", 4, new ColumnSize(20), false, true, true);
            this.addColumn("username", 12, new ColumnSize(1024));
            this.addColumn("userrole", 12, new ColumnSize(1024));
            this.addColumn("ip", 12, new ColumnSize(255));
            this.addColumn("logtime", 93, new ColumnSize());
        }
    }

    private class FR_SCHEDULERECORD
    extends AbstractTableObject {
        private FR_SCHEDULERECORD() {
        }

        public Table getTable() {
            return new Table("fr_schedulerecord");
        }

        public void initColumns() {
            this.addColumn("ID", 4, new ColumnSize(20), false, true, true);
            this.addColumn("tname", 12, new ColumnSize(255));
            this.addColumn("sinfo", 12, new ColumnSize(2047));
            this.addColumn("type", -6, new ColumnSize(4));
            this.addColumn("msg", 12, new ColumnSize(1023));
            this.addColumn("trace", -1, new ColumnSize());
            this.addColumn("logtime", 93, new ColumnSize());
            this.addColumn("detailmsg", 12, new ColumnSize(1023));
        }
    }

    private class FR_ERRORRECORD
    extends AbstractTableObject {
        private FR_ERRORRECORD() {
        }

        public Table getTable() {
            return new Table("fr_errrecord");
        }

        public void initColumns() {
            this.addColumn("ID", 4, new ColumnSize(20), false, true, true);
            this.addColumn("tname", 12, new ColumnSize(255));
            this.addColumn("sinfo", 12, new ColumnSize(2047));
            this.addColumn("type", -6, new ColumnSize(4));
            this.addColumn("msg", 12, new ColumnSize(1023));
            this.addColumn("trace", -1, new ColumnSize());
            this.addColumn("logtime", 93, new ColumnSize());
        }
    }

    private class FR_PRINTRECORD
    extends NTRECORD {
        private FR_PRINTRECORD() {
        }

        public Table getTable() {
            return new Table("fr_ptrecord");
        }
    }

    private class FR_EXPORTRECORD
    extends NTTRECORD {
        private FR_EXPORTRECORD() {
        }

        public Table getTable() {
            return new Table("fr_exprecord");
        }
    }

    private class FR_EXECUTERECORD
    extends NTTRECORD {
        private FR_EXECUTERECORD() {
        }

        public Table getTable() {
            return new Table("fr_exerecord");
        }
    }

    private abstract class NTTRECORD
    extends AbstractTableObject {
        private NTTRECORD() {
        }

        public void initColumns() {
            this.addColumn("ID", 4, new ColumnSize(20), false, true, true);
            this.addColumn("tname", 12, new ColumnSize(255));
            this.addColumn("type", -6, new ColumnSize(4));
            this.addColumn("param", 12, new ColumnSize(2047));
            this.addColumn("ip", 12, new ColumnSize(255));
            this.addColumn("username", 12, new ColumnSize(255));
            this.addColumn("userrole", 12, new ColumnSize(255));
            this.addColumn("time", 4, new ColumnSize(20));
            this.addColumn("logtime", 93, new ColumnSize());
            this.addColumn("sql", -1, new ColumnSize(10240));
            this.addColumn("browser", 12, new ColumnSize(255));
            this.addColumn("memory", 2, new ColumnSize(10));
        }

        public void addNewColumnCompatibleOld(Connection connection, Dialect dialect) {
            Column column;
            Table table = this.getTable();
            if (table != null && !this.findColumnInTable("sql", connection, table)) {
                column = new Column("sql", -1, new ColumnSize(10240));
                this.addColumnsToTable(column, connection, table, dialect);
            }
            if (table != null && !this.findColumnInTable("browser", connection, table)) {
                column = new Column("browser", 12, new ColumnSize(255));
                this.addColumnsToTable(column, connection, table, dialect);
            }
            if (table != null && !this.findColumnInTable("memory", connection, table)) {
                column = new Column("memory", 2, new ColumnSize(10));
                this.addColumnsToTable(column, connection, table, dialect);
            }
        }
    }

    private abstract class NTRECORD
    extends AbstractTableObject {
        private NTRECORD() {
        }

        public void initColumns() {
            this.addColumn("ID", 4, new ColumnSize(20), false, true, true);
            this.addColumn("tname", 12, new ColumnSize(255));
            this.addColumn("type", -6, new ColumnSize(4));
            this.addColumn("param", 12, new ColumnSize(2047));
            this.addColumn("ip", 12, new ColumnSize(255));
            this.addColumn("username", 12, new ColumnSize(255));
            this.addColumn("userrole", 12, new ColumnSize(255));
            this.addColumn("logtime", 93, new ColumnSize());
        }
    }
}

