/*
 * Decompiled with CFR 0.152.
 */
package com.fr.json;

import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONString;
import com.fr.json.JSONTokener;
import com.fr.json.JSONUtils;
import com.fr.json.Visitor;
import com.fr.stable.ArrayProvider;
import com.fr.stable.CodeUtils;
import com.fr.stable.FormulaProvider;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObject
implements Serializable {
    protected HashMap<String, Object> myHashMap;
    public static final Object NULL = new Null();
    public static final JSONObject EMPTY = new JSONObject();
    private static String[] INTEGERTOSTRINGCACHE = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};

    @Deprecated
    public JSONObject() {
        this.myHashMap = new HashMap();
    }

    public JSONObject(JSONObject jSONObject, String[] stringArray) throws JSONException {
        this();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.putOpt(stringArray[i2], jSONObject.opt(stringArray[i2]));
        }
    }

    public JSONObject(JSONTokener jSONTokener) throws JSONException {
        this();
        if (jSONTokener.nextClean() != '{') {
            throw jSONTokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c2 = jSONTokener.nextClean();
            switch (c2) {
                case '\u0000': {
                    throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jSONTokener.back();
            String string = jSONTokener.nextValue().toString();
            c2 = jSONTokener.nextClean();
            if (c2 == '=') {
                if (jSONTokener.next() != '>') {
                    jSONTokener.back();
                }
            } else if (c2 != ':') {
                throw jSONTokener.syntaxError("Expected a ':' after a key");
            }
            this.put(string, JSONUtils.objectDecode(jSONTokener.nextValue()));
            switch (jSONTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == '}') {
                        return;
                    }
                    jSONTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map map) {
        this(map, true);
    }

    private JSONObject(Map map, boolean bl) {
        HashMap<Object, Object> hashMap = this.myHashMap = map == null ? new HashMap() : new HashMap(map);
        if (bl) {
            this.setMapType();
        }
    }

    private void setMapType() {
        HashMap<String, Object> hashMap = this.myHashMap;
        for (Object k2 : hashMap.keySet()) {
            HashMap<String, String> hashMap2;
            Object v2 = hashMap.get(k2);
            if (v2 instanceof Date) {
                hashMap2 = new HashMap<String, String>();
                hashMap2.put("type", "date");
                hashMap2.put("value", (String)v2);
                hashMap.put((String)k2, hashMap2);
                continue;
            }
            if (!(v2 instanceof FormulaProvider)) continue;
            hashMap2 = new HashMap();
            hashMap2.put("type", "formula");
            hashMap2.put("value", (String)v2);
            hashMap.put((String)k2, hashMap2);
        }
    }

    public JSONObject(Object object) {
        this();
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            try {
                Method method = methodArray[i2];
                String string = method.getName();
                String string2 = "";
                if (string.startsWith("get")) {
                    string2 = string.substring(3);
                } else if (string.startsWith("is")) {
                    string2 = string.substring(2);
                }
                if (string2.length() <= 0 || !Character.isUpperCase(string2.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (string2.length() == 1) {
                    string2 = string2.toLowerCase();
                } else if (!Character.isUpperCase(string2.charAt(1))) {
                    string2 = string2.substring(0, 1).toLowerCase() + string2.substring(1);
                }
                this.put(string2, method.invoke(object, null));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(Object object, String[] stringArray) {
        this();
        Class<?> clazz = object.getClass();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            try {
                Field field = clazz.getField(string);
                Object object2 = field.get(object);
                this.put(string, object2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONObject accumulate(String string, Object object) throws JSONException {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, object instanceof JSONArray ? new JSONArray().put(object) : object);
        } else if (object2 instanceof JSONArray) {
            ((JSONArray)object2).put(object);
        } else {
            this.put(string, new JSONArray().put(object2).put(object));
        }
        return this;
    }

    public JSONObject append(String string, Object object) throws JSONException {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, new JSONArray().put(object));
        } else if (object2 instanceof JSONArray) {
            this.put(string, ((JSONArray)object2).put(object));
        } else {
            throw new JSONException("JSONObject[" + string + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return "null";
        }
        return JSONObject.dealWithEndZeros(Double.toString(d2));
    }

    public Object get(String string) throws JSONException {
        Object object = this.opt(string);
        if (object == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(String string) throws JSONException {
        Object object = this.get(string);
        if (this.isFalse(object)) {
            return false;
        }
        if (this.isTrue(object)) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a Boolean.");
    }

    private boolean isFalse(Object object) {
        return object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false");
    }

    private boolean isTrue(Object object) {
        return object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true");
    }

    public double getDouble(String string) throws JSONException {
        Object object = this.get(string);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.valueOf((String)object).doubleValue();
        }
        catch (Exception exception) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a number.");
        }
    }

    public float getFloat(String string) throws JSONException {
        Object object = this.get(string);
        try {
            return object instanceof Number ? ((Number)object).floatValue() : Float.valueOf((String)object).floatValue();
        }
        catch (Exception exception) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a number.");
        }
    }

    public int getInt(String string) throws JSONException {
        Object object = this.get(string);
        return object instanceof Number ? ((Number)object).intValue() : (int)this.getDouble(string);
    }

    public JSONArray getJSONArray(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONObject.");
    }

    public long getLong(String string) throws JSONException {
        Object object = this.get(string);
        return object instanceof Number ? ((Number)object).longValue() : (long)this.getDouble(string);
    }

    public static String[] getNames(JSONObject jSONObject) {
        int n2 = jSONObject.length();
        if (n2 == 0) {
            return new String[0];
        }
        Iterator iterator = jSONObject.keys();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (iterator.hasNext()) {
            stringArray[n3] = (String)iterator.next();
            ++n3;
        }
        return stringArray;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return new String[0];
        }
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        int n2 = fieldArray.length;
        if (n2 == 0) {
            return new String[0];
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = fieldArray[i2].getName();
        }
        return stringArray;
    }

    public String getString(String string) throws JSONException {
        return this.get(string).toString();
    }

    public boolean has(String string) {
        return this.myHashMap.containsKey(string);
    }

    public boolean isNull(String string) {
        return NULL.equals(this.opt(string));
    }

    public Iterator keys() {
        return this.myHashMap.keySet().iterator();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public JSONArray names() {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = this.keys();
        while (iterator.hasNext()) {
            jSONArray.put(iterator.next());
        }
        return jSONArray.length() == 0 ? null : jSONArray;
    }

    public static String date2String(Date date) throws JSONException {
        if (date == null) {
            throw new JSONException("Null pointer");
        }
        return "{\"__time__\":" + date.getTime() + "}";
    }

    public static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        if (number instanceof Integer) {
            int n2 = number.intValue();
            if (n2 > -1 && n2 < INTEGERTOSTRINGCACHE.length) {
                return INTEGERTOSTRINGCACHE[n2];
            }
            return Integer.toString(n2);
        }
        return JSONObject.dealWithEndZeros(number.toString());
    }

    private static String dealWithEndZeros(String string) {
        if (JSONObject.isDecimal(string)) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private static boolean isDecimal(String string) {
        return string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0;
    }

    public Object opt(String string) {
        return string == null ? null : this.myHashMap.get(string);
    }

    public boolean optBoolean(String string) {
        return this.optBoolean(string, false);
    }

    public boolean optBoolean(String string, boolean bl) {
        try {
            return this.getBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public JSONObject put(String string, Collection collection) throws JSONException {
        this.put(string, new JSONArray(collection));
        return this;
    }

    public double optDouble(String string) {
        return this.optDouble(string, Double.NaN);
    }

    public double optDouble(String string, double d2) {
        try {
            Object object = this.opt(string);
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            return d2;
        }
    }

    public int optInt(String string) {
        return this.optInt(string, 0);
    }

    public int optInt(String string, int n2) {
        try {
            return this.getInt(string);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public JSONArray optJSONArray(String string) {
        Object object = this.opt(string);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject optJSONObject(String string) {
        Object object = this.opt(string);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public long optLong(String string) {
        return this.optLong(string, 0L);
    }

    public long optLong(String string, long l2) {
        try {
            return this.getLong(string);
        }
        catch (Exception exception) {
            return l2;
        }
    }

    public String optString(String string) {
        return this.optString(string, "");
    }

    public String optString(String string, String string2) {
        Object object = this.opt(string);
        return object != null ? object.toString() : string2;
    }

    public JSONObject put(String string, boolean bl) throws JSONException {
        this.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String string, double d2) throws JSONException {
        this.put(string, new Double(d2));
        return this;
    }

    public JSONObject put(String string, int n2) throws JSONException {
        this.put(string, new Integer(n2));
        return this;
    }

    public JSONObject put(String string, long l2) throws JSONException {
        this.put(string, new Long(l2));
        return this;
    }

    public JSONObject put(String string, Map map) throws JSONException {
        this.put(string, new JSONObject(map));
        return this;
    }

    public JSONObject put(String string, Object object) throws JSONException {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        if (object != null) {
            JSONObject.testValidity(object);
            this.myHashMap.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    public JSONObject join(JSONObject jSONObject) throws JSONException {
        this.myHashMap.putAll(jSONObject.toMap());
        return this;
    }

    public JSONObject putOpt(String string, Object object) throws JSONException {
        if (string != null && object != null) {
            this.put(string, object);
        }
        return this;
    }

    public static String quote(String string) {
        return "\"" + CodeUtils.javascriptEncode(string) + "\"";
    }

    public Object remove(String string) {
        return this.myHashMap.remove(string);
    }

    static void testValidity(Object object) throws JSONException {
        if (object != null && (object instanceof Double ? ((Double)object).isInfinite() || ((Double)object).isNaN() : object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray jSONArray) throws JSONException {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        JSONArray jSONArray2 = new JSONArray();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            jSONArray2.put(this.opt(jSONArray.getString(i2)));
        }
        return jSONArray2;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(this.myHashMap);
        return hashMap;
    }

    public String toString() {
        try {
            Iterator iterator = this.keys();
            StringBuilder stringBuilder = new StringBuilder("{");
            while (iterator.hasNext()) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(',');
                }
                Object e2 = iterator.next();
                stringBuilder.append(JSONObject.quote(e2.toString()));
                stringBuilder.append(':');
                stringBuilder.append(JSONObject.valueToString(this.myHashMap.get(e2)));
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n2) throws JSONException {
        return this.toString(n2, 0);
    }

    String toString(int n2, int n3) throws JSONException {
        int n4 = this.length();
        if (n4 == 0) {
            return "{}";
        }
        Iterator iterator = this.keys();
        StringBuffer stringBuffer = new StringBuffer("{");
        int n5 = n3 + n2;
        if (n4 == 1) {
            Object e2 = iterator.next();
            stringBuffer.append(JSONObject.quote(e2.toString()));
            stringBuffer.append(": ");
            stringBuffer.append(JSONObject.valueToString(this.myHashMap.get(e2), n2, n3));
        } else {
            int n6;
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(",\n");
                } else {
                    stringBuffer.append('\n');
                }
                for (n6 = 0; n6 < n5; ++n6) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(JSONObject.quote(e3.toString()));
                stringBuffer.append(": ");
                stringBuffer.append(JSONObject.valueToString(this.myHashMap.get(e3), n2, n5));
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append('\n');
                for (n6 = 0; n6 < n3; ++n6) {
                    stringBuffer.append(' ');
                }
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static JSONObject create() {
        return new JSONObject();
    }

    public static String valueToString(Object object) throws JSONException {
        if (object == null) {
            return "null";
        }
        if (object instanceof JSONString) {
            String string;
            try {
                string = ((JSONString)object).toJSONString();
            }
            catch (Exception exception) {
                throw new JSONException(exception);
            }
            if (string != null) {
                return string;
            }
            throw new JSONException("Bad value from toJSONString: " + string);
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean || object instanceof JSONObject || object instanceof JSONArray) {
            return object.toString();
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object, false).toString();
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString();
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString();
        }
        if (object instanceof ArrayProvider) {
            return JSONObject.arrayData2String((ArrayProvider)object);
        }
        return JSONObject.quote(object.toString());
    }

    private static String arrayData2String(ArrayProvider arrayProvider) throws JSONException {
        if (arrayProvider == null) {
            throw new JSONException("Null pointer");
        }
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < arrayProvider.length(); ++i2) {
            jSONArray.put(arrayProvider.elementAt(i2));
        }
        return jSONArray.toString();
    }

    static String valueToString(Object object, int n2, int n3) throws JSONException {
        if (object == null) {
            return "null";
        }
        try {
            String string;
            if (object instanceof JSONString && (string = ((JSONString)object).toJSONString()) instanceof String) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).toString(n2, n3);
        }
        if (object instanceof JSONArray) {
            return ((JSONArray)object).toString(n2, n3);
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object, false).toString(n2, n3);
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString(n2, n3);
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString(n2, n3);
        }
        return JSONObject.quote(object.toString());
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            boolean bl = false;
            Iterator iterator = this.keys();
            writer.write(123);
            while (iterator.hasNext()) {
                if (bl) {
                    writer.write(44);
                }
                Object e2 = iterator.next();
                writer.write(JSONObject.quote(e2.toString()));
                writer.write(58);
                Object object = this.myHashMap.get(e2);
                if (object instanceof JSONObject) {
                    ((JSONObject)object).write(writer);
                } else if (object instanceof JSONArray) {
                    ((JSONArray)object).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(object));
                }
                bl = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }

    public <T> JSONObject visit(String string, Visitor<T> visitor) {
        Object object = this.opt(string);
        if (visitor != null) {
            if (object != null) {
                visitor.onVisit(object);
            } else {
                visitor.onLose();
            }
        }
        return this;
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

