/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TableData;
import com.fr.data.Dictionary;
import com.fr.data.impl.CustomDictionary;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.io.exporter.Exporter;
import com.fr.main.TemplateWorkBook;
import com.fr.main.impl.WorkBook;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.core.CellUtils;
import com.fr.report.core.ReportParameterHelper;
import com.fr.report.elementcase.TemplateElementCase;
import com.fr.report.report.TemplateReport;
import com.fr.script.Calculator;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EmbeddedTableDataExporter
implements Exporter {
    public void export(OutputStream outputStream, WorkBook workBook) throws Exception {
        this.export(outputStream, workBook, null);
    }

    public void export(OutputStream outputStream, WorkBook workBook, Map map) throws Exception {
        workBook = (WorkBook)workBook.clone();
        this.convertWorkBook(workBook, map);
        workBook.export(outputStream);
    }

    private void convertWorkBook(TemplateWorkBook templateWorkBook, Map map) throws Exception {
        HashMap<String, TableData> hashMap = new HashMap<String, TableData>();
        Iterator iterator = templateWorkBook.getTableDataNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TableData tableData = templateWorkBook.getTableData(string);
            hashMap.put(string, tableData);
        }
        int n2 = templateWorkBook.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.convertCellElement(templateWorkBook.getTemplateReport(i2), hashMap);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Calculator calculator = null;
            if (map != null) {
                calculator = Calculator.createCalculator();
                calculator.pushNameSpace(ParameterMapNameSpace.create(map));
            }
            templateWorkBook.putTableData(entry.getKey().toString(), EmbeddedTableData.embedify((TableData)entry.getValue(), calculator));
        }
    }

    private void convertCellElement(TemplateReport templateReport, Map map) {
        Iterator iterator = templateReport.iteratorOfElementCase();
        while (iterator.hasNext()) {
            TemplateElementCase templateElementCase = (TemplateElementCase)iterator.next();
            Iterator iterator2 = templateElementCase.cellIterator();
            while (iterator2.hasNext()) {
                TemplateCellElement templateCellElement = (TemplateCellElement)iterator2.next();
                ReportParameterHelper.collectValueTableData(templateCellElement.getValue(), map);
                Dictionary dictionary = CellUtils.getDictionary(templateCellElement);
                if (dictionary == null || dictionary instanceof CustomDictionary) continue;
                CellUtils.setDictionary(templateCellElement, this.customify(dictionary));
            }
        }
    }

    public CustomDictionary customify(Dictionary dictionary) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (dictionary != null) {
            Iterator iterator = dictionary.entrys(Calculator.createCalculator());
            while (iterator.hasNext()) {
                Dictionary.MV mV = (Dictionary.MV)iterator.next();
                arrayList.add(mV.getModel());
                arrayList2.add(mV.getView());
            }
        }
        return new CustomDictionary(arrayList.toArray(), arrayList2.toArray());
    }
}

