/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.general.GeneralUtils;
import com.fr.general.script.FunctionHelper;
import com.fr.script.AbstractFunction;
import com.fr.stable.Primitive;
import com.fr.stable.script.Function;

public class ASIN
extends AbstractFunction {
    public Object run(Object[] objectArray) {
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        return FunctionHelper.asNumber(Math.asin(GeneralUtils.objectToNumber(objectArray[0], false).doubleValue()));
    }

    public Function.Type getType() {
        return Function.MATH;
    }

    public String getCN() {
        return "ASIN(number): \u8fd4\u56de\u6307\u5b9a\u6570\u503c\u7684\u53cd\u6b63\u5f26\u503c\u3002\u53cd\u6b63\u5f26\u503c\u4e3a\u4e00\u4e2a\u89d2\u5ea6\uff0c\u8fd4\u56de\u89d2\u5ea6\u4ee5\u5f27\u5ea6\u5f62\u5f0f\u8868\u793a\u3002\nNumber:\u9700\u8981\u8fd4\u56de\u89d2\u5ea6\u7684\u6b63\u5f26\u503c\u3002\n\u5907\u6ce8:\n    \u6307\u5b9a\u6570\u503c\u5fc5\u987b\u5728-1\u52301\u4e4b\u95f4\uff08\u542b1\u4e0e-1\uff09\u3002\n    \u8fd4\u56de\u89d2\u5ea6\u5728-pi/2\u5230pi/2\u4e4b\u95f4\uff08\u542b-pi/2\u4e0epi/2\uff09\u3002\n    \u7528\u89d2\u5ea6\u5f62\u5f0f\u8fd4\u56de\u6570\u503c\u65f6\uff0c\u8fd4\u56de\u6570\u503c\u4e58\u4ee5180/PI()\u3002\n\u793a\u4f8b:\nASIN(0.5)\u7b49\u4e8e0.523598776\uff08pi/6\u5f27\u5ea6\uff09\u3002\nASIN(1)\u7b49\u4e8e1.570796327\uff08pi/2\u5f27\u5ea6\uff09\u3002\nASIN(0.5)*180/PI()\u7b49\u4e8e30\uff08\u5ea6\uff09\u3002";
    }

    public String getEN() {
        return "ASIN(number): Returns the arcsine, or inverse sine, of a number. The arcsine is the angle whose sine is number. The returned angle is given in radians.\nNumber is the sine of the angle.\n\nRemarks:\n    Number is in the range -1 to 1.\n    The returned angle is in the range -pi/2 to pi/2.\n    To express the arcsine in degrees, multiply the result by 180/PI( ) or use the DEGREES function.\n\nExample:\n   ASIN(0.5)=0.523598776 (pi/6 in radians)\n   ASIN(1)=1.570796327 (pi/2 in radians)\n   ASIN(0.5)*180/PI()=30 (in degrees)";
    }
}

