/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.main;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.base.ParameterHolder;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TableData;
import com.fr.base.Utils;
import com.fr.base.io.IOFile;
import com.fr.base.io.XMLReadHelper;
import com.fr.base.mobile.utils.MobileUtils;
import com.fr.data.TableDataSource;
import com.fr.form.FormElementCaseProvider;
import com.fr.form.FormFunctionProcessor;
import com.fr.form.FormProvider;
import com.fr.form.data.DataBinding;
import com.fr.form.main.FormConfig;
import com.fr.form.main.WidgetGather;
import com.fr.form.main.WidgetGatherAdapter;
import com.fr.form.main.mobile.FormMobileAttr;
import com.fr.form.ui.ChartEditorProvider;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.DateEditor;
import com.fr.form.ui.ElementCaseEditor;
import com.fr.form.ui.ElementCaseEditorProvider;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetValue;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.form.ui.container.WAbsoluteLayout;
import com.fr.form.ui.container.WBorderLayout;
import com.fr.form.ui.container.WCardLayout;
import com.fr.form.ui.container.WLayout;
import com.fr.form.ui.container.WParameterLayout;
import com.fr.form.ui.container.WScaleLayout;
import com.fr.form.ui.container.WTitleLayout;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.privilege.PrivilegeEditedRoleProvider;
import com.fr.privilege.finegrain.WidgetPrivilegeControl;
import com.fr.report.fun.ReportFitProcessor;
import com.fr.script.Calculator;
import com.fr.stable.EmbParaFilter;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.fun.FitProvider;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.fun.ReportFitAttrProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.StableXMLUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WidgetSessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form
extends IOFile
implements PrivilegeEditedRoleProvider,
FormProvider,
ParameterHolder,
FitProvider {
    public static final String FIT = "__FIT__";
    public static final String PAPER_WHDTH = "_PAPERWIDTH";
    public static final String PAPER_HEIGHT = "_PAPERHEIGHT";
    public static final String _SHOWPARA = "_SHOWPARA";
    private static final String XML_TAG = "Form";
    private static final int SCROLL_BAR_HEIGHT = 10;
    public static final int DEFAULT_FIT = 1;
    public static final int NONE_FIT = -1;
    private WLayout container;
    protected ReportFitAttrProvider fitAttr = null;
    protected Set<Parameter> parameters = new HashSet<Parameter>();
    protected FormMobileAttr mobileAttr;

    public Form() {
        this(new WAbsoluteLayout());
    }

    public Form(WAbsoluteLayout wAbsoluteLayout) {
        this.setContainer(wAbsoluteLayout);
    }

    public Form(WLayout wLayout) {
        this.setContainer(wLayout);
    }

    public WLayout getContainer() {
        return this.container;
    }

    public void setContainer(WLayout wLayout) {
        this.container = wLayout;
    }

    @Override
    public Widget getWidgetByName(String string) {
        if (this.container == null) {
            return null;
        }
        return this.findWidgetByName(this.container, string);
    }

    public Widget getWidgetWithBound(String string) {
        if (this.container == null) {
            return null;
        }
        return this.findWidgetWithBound(this.container, string);
    }

    public FormMobileAttr getFormMobileAttr() {
        if (this.mobileAttr == null) {
            this.mobileAttr = new FormMobileAttr();
        }
        return this.mobileAttr;
    }

    public void setFormMobileAttr(FormMobileAttr formMobileAttr) {
        this.mobileAttr = formMobileAttr;
    }

    @Override
    public FormElementCaseProvider getElementCaseByName(String string) {
        Widget widget = this.getWidgetByName(string);
        if (widget == null || !widget.acceptType(ElementCaseEditor.class)) {
            return StableFactory.getMarkedInstanceObjectFromClass("FormElementCase", FormElementCaseProvider.class);
        }
        return ((ElementCaseEditor)widget).getElementCase();
    }

    public Parameter[] getTemplateParameters() {
        return this.parameters.toArray(new Parameter[this.parameters.size()]);
    }

    @Override
    public Parameter[] getParameters() {
        HashSet<ParameterProvider> hashSet = new HashSet<ParameterProvider>();
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(TableDataSource.KEY, (Object)this);
        ParameterHelper.addGlobal_ParameterToSet(hashSet);
        hashSet.addAll(this.parameters);
        try {
            int n2 = this.tableDataList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TableData tableData = (TableData)this.tableDataList.get(i2);
                ParameterProvider[] parameterProviderArray = FRContext.getCurrentEnv().getTableDataParameters(tableData);
                if (tableData == null || parameterProviderArray == null) continue;
                for (ParameterProvider parameterProvider : parameterProviderArray) {
                    if (EmbParaFilter.isFRLayerTypePara(parameterProvider)) continue;
                    hashSet.add(parameterProvider);
                }
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return hashSet.toArray(new Parameter[hashSet.size()]);
    }

    private Widget findWidgetWithBound(Widget widget, String string) {
        if (ComparatorUtils.equalsIgnoreCase(widget.getWidgetName(), string)) {
            return widget;
        }
        if (widget instanceof WLayout) {
            int n2 = ((WLayout)widget).getWidgetCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Widget widget2;
                Widget widget3 = ((WLayout)widget).getWidget(i2);
                if (widget3 instanceof WAbsoluteLayout.BoundsWidget) {
                    widget3 = ((WAbsoluteLayout.BoundsWidget)widget3).getWidget();
                }
                if ((widget2 = this.findWidgetWithBound(widget3, string)) == null) continue;
                return widget2;
            }
        }
        return null;
    }

    private Widget findWidgetByName(Widget widget, String string) {
        if (ComparatorUtils.equalsIgnoreCase(widget.getWidgetName(), string)) {
            if (widget.acceptType(WTitleLayout.class) || widget.acceptType(WScaleLayout.class)) {
                int n2 = ((WLayout)widget).getWidgetCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Widget widget2;
                    Widget widget3 = ((WLayout)widget).getWidget(i2);
                    if (widget3 instanceof WAbsoluteLayout.BoundsWidget) {
                        widget3 = ((WAbsoluteLayout.BoundsWidget)widget3).getWidget();
                    }
                    if ((widget2 = this.findWidgetByName(widget3, string)) == null) continue;
                    return widget2;
                }
            }
            return widget;
        }
        if (widget instanceof WLayout) {
            int n3 = ((WLayout)widget).getWidgetCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                Widget widget4;
                Widget widget5 = ((WLayout)widget).getWidget(i3);
                if (widget5 instanceof WAbsoluteLayout.BoundsWidget) {
                    widget5 = ((WAbsoluteLayout.BoundsWidget)widget5).getWidget();
                }
                if ((widget4 = this.findWidgetByName(widget5, string)) == null) continue;
                return widget4;
            }
        }
        return null;
    }

    public boolean isNameExist(String string) {
        return this.getWidgetByName(string) != null;
    }

    @Override
    public boolean renameTableData(String string, String string2) {
        if (super.renameTableData(string, string2)) {
            if (this.getTableData(string) == null) {
                this._renameTableData(string, string2);
            }
            return true;
        }
        return false;
    }

    protected void _renameTableData(final String string, final String string2) {
        Form.traversalWidget(this.container, new WidgetGather(){

            public void dealWith(Widget widget) {
                DataControl dataControl = (DataControl)((Object)widget);
                if (dataControl.getWidgetValue() != null) {
                    dataControl.getWidgetValue().renameTableData(string, string2);
                }
            }

            public boolean dealWithAllCards() {
                return true;
            }
        }, DataControl.class);
        Form.traversalWidget(this.container, new WidgetGather(){

            public void dealWith(Widget widget) {
                ElementCaseEditor elementCaseEditor = (ElementCaseEditor)widget;
                elementCaseEditor.renameTableData(string, string2);
            }

            public boolean dealWithAllCards() {
                return true;
            }
        }, ElementCaseEditor.class);
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        if (!this.initWidgetData(repository, calculator)) {
            return JSONObject.EMPTY;
        }
        JSONObject jSONObject = this.container.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put(FIT, this.isFitInBrowser());
        jSONObject.put("refresh", this.getFormMobileAttr().isRefresh());
        return jSONObject;
    }

    public boolean isFitInBrowser() {
        ReportFitProcessor reportFitProcessor = (ReportFitProcessor)ExtraClassManager.getInstance().getSingle("ReportFitProcessor");
        if (reportFitProcessor == null) {
            return false;
        }
        return reportFitProcessor.isFrmFitInBrowser(this.getFitAttr());
    }

    public JSONObject createContentJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        return this.createContentJSONConfig(repository, calculator, true);
    }

    public JSONObject createContentJSONConfig(Repository repository, Calculator calculator, boolean bl) throws JSONException {
        WLayout wLayout = this.getParaContainer();
        NodeVisitor nodeVisitor = new NodeVisitor();
        if (wLayout == null) {
            if (!bl) {
                return this.createEmptyContainerConfig(repository, calculator, nodeVisitor);
            }
            return this.createJSONConfig(repository, calculator, nodeVisitor);
        }
        WLayout wLayout2 = null;
        try {
            wLayout2 = (WLayout)this.container.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage());
        }
        wLayout2.removeWidget(wLayout2.getWidget(wLayout.getWidgetName()));
        if (!bl) {
            wLayout2.removeAll();
        }
        if (!this.initWidgetData(wLayout2, repository, calculator)) {
            return JSONObject.EMPTY;
        }
        JSONObject jSONObject = wLayout2.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put(FIT, this.isFitInBrowser());
        jSONObject.put("refresh", this.getFormMobileAttr().isRefresh());
        return jSONObject;
    }

    public JSONObject createParaJSONConfig(Repository repository, Calculator calculator) throws JSONException {
        WLayout wLayout = this.getParaContainer();
        if (this.initWidgetData(wLayout, repository, calculator)) {
            JSONObject jSONObject = wLayout.createJSONConfig(repository, calculator, null);
            jSONObject.put("height", this.getParameterUIHeight());
            return jSONObject;
        }
        return JSONObject.EMPTY;
    }

    private int getParameterUIHeight() {
        return ((WBorderLayout)this.container).getNorthSize();
    }

    public JSONObject createPara4Mobile(Repository repository, SessionIDInfor sessionIDInfor) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        FormMobileAttr formMobileAttr = this.getFormMobileAttr();
        jSONObject.put("isUseHTML", formMobileAttr.isUseHTML());
        jSONObject.put("sessionid", sessionIDInfor.getSessionID());
        jSONObject.put("hash5", MobileUtils.hasH5());
        WLayout wLayout = this.getParaContainer();
        if (wLayout != null) {
            wLayout.createPara4Mobile(repository, jSONObject, this);
        }
        return jSONObject;
    }

    private WLayout getParaContainer() {
        int n2 = this.container.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Widget widget = this.container.getWidget(i2);
            if (!widget.acceptType(WParameterLayout.class)) continue;
            return (WLayout)widget;
        }
        return null;
    }

    public boolean initWidgetData(Repository repository, Calculator calculator) {
        return this.initWidgetData(this.container, repository, calculator);
    }

    public boolean initWidgetData(Widget widget, Repository repository, Calculator calculator) {
        if (widget == null) {
            return false;
        }
        try {
            Map map = WebUtils.parameters4SessionIDInfor((HttpServletRequest)repository.getHttpServletRequest());
            calculator.pushNameSpace(ParameterMapNameSpace.create(map));
            calculator.pushNameSpace(ParameterMapNameSpace.create(this.getWidgetDefaultValueMap(map, repository)));
            FormConfig.getInstance().dealWithWidgetData(repository.getHttpServletRequest(), widget, calculator);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getWidgetDefaultValueMap() {
        return this.getWidgetDefaultValueMap(new HashMap<String, Object>(), null);
    }

    public Map<String, Object> getWidgetDefaultValueMap(final Map<String, Object> map, Repository repository) {
        Object object;
        if (repository != null && (object = SessionDealWith.getSessionIDInfor((String)repository.getSessionID())) != null) {
            map.putAll(object.getParameterMap4Execute());
        }
        object = new HashMap();
        final Calculator calculator = Calculator.createCalculator();
        calculator.pushNameSpace(ParameterMapNameSpace.create(map));
        this.addFormParameterDefaultValue(map, (Map<String, Object>)object);
        Form.traversalWidget(this.getContainer(), new WidgetGatherAdapter((Map)object){
            final /* synthetic */ Map val$defaultPara;
            {
                this.val$defaultPara = map2;
            }

            public void dealWith(Widget widget) {
                DataControl dataControl = (DataControl)((Object)widget);
                WidgetValue widgetValue = dataControl.getWidgetValue();
                if (widgetValue == null) {
                    return;
                }
                String string = widget.getWidgetName();
                if (Form.this.validValue(widgetValue, string, map)) {
                    Object object = widgetValue.getValue();
                    if (object instanceof Formula) {
                        object = Form.this.processFormula((Formula)object, calculator);
                    }
                    if (object instanceof Date) {
                        object = Form.this.processDate(object, map, widget);
                    }
                    if (object instanceof DataBinding) {
                        object = Form.this.processDataBinding(widgetValue, string, calculator);
                    }
                    this.val$defaultPara.put(string, object);
                }
            }
        }, DataControl.class);
        return object;
    }

    private void addFormParameterDefaultValue(Map<String, Object> map, Map<String, Object> map2) {
        Parameter[] parameterArray;
        for (Parameter parameter : parameterArray = this.getParameters()) {
            String string = parameter.getName();
            Object object = parameter.getValue();
            Object object2 = map.get(string.toUpperCase());
            if (this.notNull(object2) || !this.notNull(object) || !StringUtils.isNotEmpty(Utils.objectToString(object))) continue;
            map2.put(string, object);
        }
    }

    private Object processDataBinding(WidgetValue widgetValue, String string, Calculator calculator) {
        WidgetValue.WidgetValueInfo widgetValueInfo = new WidgetValue.WidgetValueInfo(string);
        calculator.setAttribute(TableDataSource.KEY, (Object)this);
        Object object = widgetValue.createAttrResult(widgetValueInfo, calculator, new JSONObject());
        return object;
    }

    private boolean notNull(Object object) {
        return object != null && object != Primitive.NULL;
    }

    private Object processFormula(Formula formula, Calculator calculator) {
        Object object = null;
        try {
            Parameter[] parameterArray;
            for (Parameter parameter : parameterArray = ParameterHelper.analyze4ParametersFromFormula(formula.getContent())) {
                Object object2 = calculator.eval(parameter.getName());
                if (this.notNull(object2)) continue;
                return formula;
            }
            object = calculator.eval(formula);
        }
        catch (UtilEvalError utilEvalError) {
            // empty catch block
        }
        return this.notNull(object) ? object : formula;
    }

    private Object processDate(Object object, Map<String, Object> map, Widget widget) {
        Object object2 = map.get(object);
        if (this.notNull(object2)) {
            return object2;
        }
        if (widget.acceptType(DateEditor.class)) {
            String string = ((DateEditor)widget).getFormatText();
            return new SimpleDateFormat(string).format(object);
        }
        return Utils.objectToString(object);
    }

    private boolean validValue(WidgetValue widgetValue, String string, Map<String, Object> map) {
        Object object = map.get(string.toUpperCase());
        if (this.notNull(object)) {
            return ComparatorUtils.equals(object, widgetValue.getValue());
        }
        return widgetValue != null && widgetValue.getValue() != null;
    }

    @Override
    protected String openTag() {
        return XML_TAG;
    }

    @Override
    protected void mainContent(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter);
    }

    @Override
    public void readStream(InputStream inputStream) throws Exception {
        XMLableReader xMLableReader = XMLReadHelper.createXMLableReader(inputStream, "UTF-8");
        String string = xMLableReader.getTagName();
        if (!XML_TAG.equals(string) && !"FormBook".equals(string)) {
            FRContext.getLogger().info("nodeName[" + string + "] does not match as " + XML_TAG + ", might not read success");
        }
        xMLableReader.readXMLObject(this);
        xMLableReader.close();
        inputStream.close();
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        this.readDesign(xMLableReader);
        this.readExtra(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("Layout") || xMLableReader.getTagName().equals("Container")) {
                this.compatibleOldParameter(xMLableReader);
            } else if ("ReportFitAttr".equals(xMLableReader.getTagName())) {
                this.readReportFitAttr(xMLableReader);
            } else if ("Parameters".equals(xMLableReader.getTagName())) {
                this.parameters.addAll(Arrays.asList(BaseXMLUtils.readParameters(xMLableReader)));
            } else if ("FormMobileAttr".equals(xMLableReader.getTagName())) {
                FormMobileAttr formMobileAttr = new FormMobileAttr();
                xMLableReader.readXMLObject(formMobileAttr);
                this.mobileAttr = formMobileAttr;
            }
        }
    }

    private void readReportFitAttr(XMLableReader xMLableReader) {
        ReportFitProcessor reportFitProcessor = (ReportFitProcessor)ExtraClassManager.getInstance().getSingle("ReportFitProcessor");
        if (reportFitProcessor == null) {
            return;
        }
        ReportFitAttrProvider reportFitAttrProvider = reportFitProcessor.newInstanceFitAttr();
        xMLableReader.readXMLObject(reportFitAttrProvider);
        this.setFitAttr(reportFitAttrProvider);
    }

    protected void compatibleOldParameter(XMLableReader xMLableReader) {
        this.container = (WLayout)WidgetXmlUtils.readWidget(xMLableReader);
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        ParameterProvider[] parameterProviderArray;
        super.writeXML(xMLPrintWriter);
        ReportFitAttrProvider reportFitAttrProvider = this.getFitAttr();
        if (reportFitAttrProvider != null) {
            reportFitAttrProvider.writeXML(xMLPrintWriter);
        }
        if (this.mobileAttr != null) {
            xMLPrintWriter.startTAG("FormMobileAttr");
            this.mobileAttr.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if ((parameterProviderArray = this.getTemplateParameters()) != null) {
            StableXMLUtils.writeParameters(xMLPrintWriter, parameterProviderArray);
        }
        GeneralXMLTools.writeXMLable(xMLPrintWriter, this.container, "Layout");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Form form = (Form)super.clone();
        if (this.container != null) {
            form.container = (WLayout)this.container.clone();
        }
        return form;
    }

    public void resizeFormElems(Map<String, Object> map) {
        try {
            int n2;
            boolean bl = Boolean.valueOf(Utils.objectToString(map.get(FIT)));
            if (!bl) {
                return;
            }
            int n3 = Integer.parseInt(Utils.objectToString(map.get(PAPER_WHDTH)));
            int n4 = Integer.parseInt(Utils.objectToString(map.get(PAPER_HEIGHT)));
            boolean bl2 = Boolean.valueOf(Utils.objectToString(map.get(_SHOWPARA)));
            if (this.getParaContainer() != null) {
                n2 = bl2 ? this.getParameterUIHeight() : 0;
                n4 -= n2 + 10;
            }
            if (n3 <= 0 && n4 <= 0) {
                return;
            }
            n2 = 0;
            ReportFitProcessor reportFitProcessor = (ReportFitProcessor)ExtraClassManager.getInstance().getSingle("ReportFitProcessor");
            if (reportFitProcessor != null) {
                n2 = reportFitProcessor.parseFontFit(this.getFitAttr()) ? 1 : 0;
            }
            int n5 = n2 != 0 ? 1 : -1;
            int n6 = this.container.getWidgetCount();
            for (int i2 = 0; i2 < n6; ++i2) {
                Widget widget = this.container.getWidget(i2);
                widget.resize(n3, n4, n5);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void resizeFormWithBrowser(int n2, int n3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(FIT, true);
        hashMap.put(PAPER_WHDTH, n2);
        hashMap.put(PAPER_HEIGHT, n3);
        hashMap.put(_SHOWPARA, "false");
        this.resizeFormElems(hashMap);
    }

    public void executeElementCases(WidgetSessionIDInfor widgetSessionIDInfor, Map<String, Object> map) {
        this.resizeFormElems(map);
        ElementCaseEditorProvider[] elementCaseEditorProviderArray = this.getElementCases();
        int n2 = elementCaseEditorProviderArray.length;
        if (n2 == 0) {
            return;
        }
        FormElementCaseProvider formElementCaseProvider = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            FunctionProcessor functionProcessor;
            if (elementCaseEditorProviderArray[i2].isShared() && (functionProcessor = ExtraClassManager.getInstance().getFunctionProcessor()) != null) {
                functionProcessor.recordFunction(FormFunctionProcessor.ELEMENTCASE_SHARE);
            }
            formElementCaseProvider = elementCaseEditorProviderArray[i2].getElementCase();
            formElementCaseProvider.setName(elementCaseEditorProviderArray[i2].getWidgetName());
            formElementCaseProvider.setTabledataSource(this);
        }
        formElementCaseProvider.executeAll(widgetSessionIDInfor, map);
        widgetSessionIDInfor.clearDataModelCaches();
    }

    @Override
    public ElementCaseEditorProvider[] getElementCases() {
        final ArrayList arrayList = new ArrayList();
        Form.traversalWidget(this.container, new WidgetGatherAdapter(){

            public boolean dealWithAllCards() {
                return true;
            }

            public void dealWith(Widget widget) {
                arrayList.add((ElementCaseEditor)widget);
            }
        }, ElementCaseEditorProvider.class);
        return arrayList.toArray(new ElementCaseEditorProvider[arrayList.size()]);
    }

    public ChartEditorProvider[] getAllCharts() {
        final ArrayList arrayList = new ArrayList();
        Form.traversalWidget(this.container, new WidgetGatherAdapter(){

            public boolean dealWithAllCards() {
                return true;
            }

            public void dealWith(Widget widget) {
                arrayList.add((ChartEditorProvider)((Object)widget));
            }
        }, ChartEditorProvider.class);
        return arrayList.toArray(new ChartEditorProvider[arrayList.size()]);
    }

    public static void traversalFormWidget(Widget widget, WidgetGather widgetGather) {
        Form.traversalWidget(widget, widgetGather, null);
    }

    public static void traversalWidget(Widget widget, WidgetGather widgetGather, Class clazz) {
        if (widget instanceof WAbsoluteLayout.BoundsWidget) {
            widget = ((WAbsoluteLayout.BoundsWidget)widget).getWidget();
        }
        if (clazz == null || clazz.isInstance(widget)) {
            widgetGather.dealWith(widget);
        }
        if (widget instanceof WLayout) {
            if (widget instanceof WCardLayout && !widgetGather.dealWithAllCards()) {
                int n2 = ((WCardLayout)widget).getShowIndex();
                if (((WCardLayout)widget).getWidgetCount() > n2) {
                    Form.traversalWidget(((WCardLayout)widget).getWidget(n2), widgetGather, clazz);
                }
            } else {
                int n3 = ((WLayout)widget).getWidgetCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    Form.traversalWidget(((WLayout)widget).getWidget(i2), widgetGather, clazz);
                }
            }
        }
    }

    @Override
    public String[] getAllEditedRoleSet() {
        final HashSet hashSet = new HashSet();
        Form.traversalFormWidget(this.getContainer(), new WidgetGatherAdapter(){

            public void dealWith(Widget widget) {
                if (!(widget instanceof WLayout) && !(widget instanceof WAbsoluteLayout.BoundsWidget)) {
                    WidgetPrivilegeControl widgetPrivilegeControl = widget.getWidgetPrivilegeControl();
                    hashSet.addAll(Arrays.asList(widgetPrivilegeControl.getAllEditedRoles()));
                }
            }
        });
        return new ArrayList(hashSet).toArray(new String[hashSet.size()]);
    }

    @Override
    public ReportFitAttrProvider getFitAttr() {
        return this.fitAttr;
    }

    @Override
    public void setFitAttr(ReportFitAttrProvider reportFitAttrProvider) {
        this.fitAttr = reportFitAttrProvider;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void removeParameter(Parameter parameter) {
        this.parameters.remove(parameter);
    }

    private JSONObject createEmptyContainerConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        WLayout wLayout = null;
        try {
            wLayout = (WLayout)this.container.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage());
        }
        wLayout.removeAll();
        return wLayout.createJSONConfig(repository, calculator, nodeVisitor);
    }

    public void dealInVisible() throws Exception {
        int n2 = this.container.getWidgetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Widget widget = this.container.getWidget(i2);
            widget.dealInvisible();
        }
    }
}

