/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.AbstractTableData;
import com.fr.base.Parameter;
import com.fr.base.TableData;
import com.fr.data.AbstractTableDataSource;
import com.fr.data.TableDataSource;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.impl.TableDataSourceDependent;
import com.fr.data.impl.XMLOPTableDataSource;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;

public abstract class MultiTDTableData
extends AbstractTableData
implements TableDataSourceDependent {
    private TableDataSource source;
    protected List tableDataNameList = null;

    public boolean addTableData(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        if (this.tableDataNameList == null) {
            this.tableDataNameList = new ArrayList();
        }
        if (this.tableDataNameList.contains(string)) {
            return false;
        }
        this.tableDataNameList.add(string);
        return true;
    }

    public String[] getColumnNames(TableDataSource tableDataSource) {
        this.setTableDataSource(tableDataSource);
        return super.getColumnNames(tableDataSource);
    }

    public String getTableDataName(int n2) {
        if (n2 < 0 || this.tableDataNameList == null || n2 >= this.tableDataNameList.size()) {
            return null;
        }
        return (String)this.tableDataNameList.get(n2);
    }

    public int getTableDataCount() {
        return this.tableDataNameList == null ? 0 : this.tableDataNameList.size();
    }

    public boolean removeTableData(String string) {
        if (string == null || this.tableDataNameList == null) {
            return false;
        }
        return this.tableDataNameList.remove(string);
    }

    public void removeAllTableData() {
        this.tableDataNameList = null;
    }

    public ParameterProvider[] getParameters(Calculator calculator) {
        List list = this.createTableDataList();
        ArrayList<ParameterProvider> arrayList = new ArrayList<ParameterProvider>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            TableData tableData = (TableData)list.get(i2);
            if (tableData == null) continue;
            ParameterProvider[] parameterProviderArray = tableData.getParameters(calculator);
            for (int i3 = 0; i3 < parameterProviderArray.length; ++i3) {
                arrayList.add(parameterProviderArray[i3]);
            }
        }
        return arrayList.toArray(new Parameter[arrayList.size()]);
    }

    public void setTableDataSource(TableDataSource tableDataSource) {
        this.source = tableDataSource;
    }

    public TableDataSource getTableDataSource() {
        return this.source;
    }

    protected TableData createTableData(String string) {
        TableData tableData;
        if (StringUtils.isBlank(string)) {
            return null;
        }
        TableData tableData2 = tableData = this.source == null ? null : this.source.getTableData(string);
        if (tableData == null) {
            try {
                tableData = DataCoreUtils.getClonedTableData(DatasourceManager.getProviderInstance(), string);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        } else {
            try {
                tableData = (TableData)tableData.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                tableData = null;
            }
        }
        return tableData;
    }

    protected List createTableDataList() {
        ArrayList<TableData> arrayList = new ArrayList<TableData>();
        if (this.tableDataNameList != null) {
            for (int i2 = 0; i2 < this.tableDataNameList.size(); ++i2) {
                String string = (String)this.tableDataNameList.get(i2);
                TableData tableData = this.createTableData(string);
                arrayList.add(tableData);
            }
        }
        return arrayList;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("TDName".equals(string)) {
                this.readNode(xMLableReader);
            } else if ("TableDataMap".equals(string)) {
                this.source = new SimpleTableDataSource();
                this.source.readXML(xMLableReader);
            }
        }
    }

    protected void readNode(XMLableReader xMLableReader) {
        String string = xMLableReader.getElementValue();
        if (string != null) {
            this.addTableData(string);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.tableDataNameList != null && this.tableDataNameList.size() > 0) {
            for (int i2 = 0; i2 < this.tableDataNameList.size(); ++i2) {
                String string = (String)this.tableDataNameList.get(i2);
                if (StringUtils.isBlank(string)) continue;
                this.writeNode(xMLPrintWriter, string, i2);
            }
        }
    }

    public void writeXMLWithSource(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter);
        if (this.source != null) {
            new XMLOPTableDataSource(this.source).writeXML(xMLPrintWriter);
        }
    }

    protected void writeNode(XMLPrintWriter xMLPrintWriter, String string, int n2) {
        xMLPrintWriter.startTAG("TDName").textNode(string).end();
    }

    public boolean equals(Object object) {
        return object instanceof MultiTDTableData && ComparatorUtils.equals((Object)this.tableDataNameList, (Object)((MultiTDTableData)object).tableDataNameList);
    }

    public Object clone() throws CloneNotSupportedException {
        MultiTDTableData multiTDTableData = (MultiTDTableData)super.clone();
        if (this.tableDataNameList != null) {
            multiTDTableData.tableDataNameList = new ArrayList();
            for (int i2 = 0; i2 < this.tableDataNameList.size(); ++i2) {
                multiTDTableData.tableDataNameList.add(this.tableDataNameList.get(i2));
            }
        }
        return multiTDTableData;
    }

    public DataModel createDataModel(Calculator calculator, String string) {
        return this.createDataModel(calculator);
    }

    public DataModel createDataModel(Calculator calculator, int n2) {
        return this.createDataModel(calculator);
    }

    private static class SimpleTableDataSource
    extends AbstractTableDataSource {
        private SimpleTableDataSource() {
        }
    }
}

