/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dml;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.InsertOrUpdate;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class Update
extends InsertOrUpdate {
    private Where where;

    public Update(Table table) {
        this(table, DialectFactory.getDefaultDialect());
    }

    public Update(Table table, Dialect dialect) {
        this(table, null, dialect);
    }

    public Update(Table table, Where where, Dialect dialect) {
        super(table, dialect);
        this.where = where;
    }

    public boolean isUpdate() {
        return true;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public static boolean validate(Update update) {
        return update != null && update.getColumnCount() > 0;
    }

    protected boolean validate(Connection connection) {
        return super.validate(connection) && Update.validate(this);
    }

    public PreparedStatement createPreparedStatementByValidatedParameters(Connection connection) throws SQLException {
        int n2 = this.getColumnCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.dialect.column2SQL(this.getColumnName(i2)) + "=?";
        }
        String string = this.getTable().toStatementSQLString(this.dialect);
        String string2 = "";
        String string3 = this.where == null ? "" : this.where.toStatementSQLString(this.dialect);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(' ');
        int n3 = stringArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            stringBuffer.append(stringArray[i3]);
            if (i3 >= n3 - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(' ');
        string2 = stringBuffer.toString();
        String string4 = "UPDATE " + string + " SET" + string2 + string3;
        PreparedStatement preparedStatement = connection.prepareStatement(string4.toString());
        for (int i4 = 0; i4 < n2; ++i4) {
            DBUtils.applyColumnTypeValue(this.dialect, connection, this.getTable(), this.getColumnName(i4), this.getColumnValue(i4), preparedStatement, i4 + 1, this.getColumnType(i4), this.getColumnValue(i4));
        }
        if (this.where != null) {
            this.where.applyColumnTypeValue(this.dialect, connection, this.getTable(), preparedStatement, n2 + 1);
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = this.createPreparedStatement(connection);
        try {
            if (preparedStatement != null) {
                int n2 = preparedStatement.executeUpdate();
                return n2;
            }
        }
        finally {
            DBUtils.closeStatement(preparedStatement);
        }
        return 0;
    }
}

