/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc;

import com.fr.cluster.rpc.RPCUtil;
import com.fr.cluster.rpc.exception.ParamSerializableException;
import java.io.Serializable;
import java.lang.reflect.Type;

class Parameter
implements Serializable {
    private static final long serialVersionUID = 102L;
    protected Type type;
    protected Object value;
    private Boolean initialed = false;
    private Boolean isRecovered = false;

    Parameter() {
    }

    public Boolean isRecovered() {
        return this.isRecovered;
    }

    public void setRecover() {
        this.isRecovered = true;
    }

    public Boolean isInitialed() {
        return this.initialed;
    }

    public void initialed() {
        this.initialed = true;
    }

    public void resetInitialed() {
        this.initialed = false;
    }

    public Parameter initial(Type type, Object object) {
        if (object instanceof Serializable) {
            this.type = type;
            this.value = object;
            this.initialed();
        } else if (object == null) {
            this.type = type;
            this.value = "object_null";
            this.initialed();
        }
        return this;
    }

    public Parameter check(Object object) throws ParamSerializableException {
        if (this.value == null) {
            throw new ParamSerializableException("Parameter:" + object.getClass() + " need to be serializable");
        }
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public void recover() throws Exception {
        this.value = this.checkParamNull();
    }

    private Object checkParamNull() {
        if (RPCUtil.equalsTool(this.value, "object_null")) {
            this.value = null;
        }
        return this.value;
    }
}

