/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.AxisHelper;
import com.fr.chart.chartglyph.ChartAlertValueGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.math.BigDecimal;

public abstract class NumberAxisGlyph
extends AxisGlyph {
    private static final long serialVersionUID = -9047629027524068377L;
    public static final double UNIT_HEIGHT = 18.0;
    private static final double DIV_4_SECOND = 5.0;
    private static final double MAX_MORE_THAN_MIN = 10.0;
    private static final double LOG_MIN_VALUE = 1.0E-10;
    private String showUnit = null;
    private String unitPadding = null;
    private boolean isLog = false;
    private double baseLog = 10.0;
    private boolean isPercentage = false;
    private ChartAlertValueGlyph[] alertValues = new ChartAlertValueGlyph[0];
    protected transient double maxLeftAlert;
    protected transient double maxRightAlert;

    public double getMaxLeftAlert() {
        return this.maxLeftAlert;
    }

    public double getMaxRightAlert() {
        return this.maxRightAlert;
    }

    public boolean isLog() {
        return this.isLog;
    }

    public void setLog(boolean bl) {
        this.isLog = bl;
    }

    public void setBaseLog(double d2) {
        this.baseLog = d2;
    }

    public double getBaseLog() {
        return this.baseLog;
    }

    public void setUnitPadding(String string) {
        this.unitPadding = string;
    }

    public void setAlertValues(ChartAlertValueGlyph[] chartAlertValueGlyphArray) {
        this.alertValues = chartAlertValueGlyphArray;
    }

    public ChartAlertValueGlyph[] getAlertValues() {
        return this.alertValues == null ? new ChartAlertValueGlyph[]{} : this.alertValues;
    }

    public void setPercentage(boolean bl) {
        this.isPercentage = bl;
    }

    public boolean isPercentage() {
        return this.isPercentage;
    }

    public void setShowUnit(String string) {
        this.showUnit = string;
    }

    public String getShowUnit() {
        return this.showUnit;
    }

    public void initMinMaxValue(double d2, double d3) {
        double d4 = this.createResMinValue(d2);
        double d5 = this.createResMaxValue(d3);
        if (this.isLog()) {
            this.calculateUnitWithLog();
        } else if (d5 - d4 > 0.0) {
            this.calculateUnitWidthoutLog(d4, d5);
        }
        if (this.isLog()) {
            this.recalculateMinMaxValueWithLog();
            if (this.minValue == 0.0) {
                this.minValue = 1.0;
            }
        } else {
            this.recalculateMinValue();
            this.recalculateMaxValue();
        }
        this.dealWhenMaxIsLessThanMin();
    }

    private double createResMinValue(double d2) {
        if (!this.isCustomMinValue()) {
            this.setMinValue(d2);
        }
        return this.getMinValue();
    }

    private double createResMaxValue(double d2) {
        if (!this.isCustomMaxValue()) {
            this.setMaxValue(d2);
        }
        return this.getMaxValue();
    }

    private void calculateUnitWithLog() {
        this.setMainUnit(new BigDecimal(Double.toString(this.getBaseLog())));
        this.setSecUnit(this.getMainUnit() / 5.0);
    }

    private void calculateUnitWidthoutLog(double d2, double d3) {
        if (this.isCustomMainUnit()) {
            if (this.isPercentage()) {
                this.setMainUnit(this.getBigDecimalMainUnit());
            }
        } else {
            this.setMainUnit(AxisHelper.calculateIncrement(d2, d3));
        }
        if (!this.isCustomSecUnit()) {
            this.setSecUnit(this.getMainUnit() / 5.0);
        }
    }

    private void recalculateMinValue() {
        int n2 = (int)(Math.abs(this.getMinValue()) / this.getMainUnit());
        if (!this.isCustomMinValue()) {
            if (this.minValue < 0.0) {
                this.minValue = (double)(-(n2 + 1)) * this.getMainUnit();
            } else if (this.minValue > 0.0) {
                this.minValue = (double)n2 * this.getMainUnit();
            }
        }
    }

    private void recalculateMaxValue() {
        int n2 = (int)((this.maxValue - this.minValue) / this.getMainUnit());
        double d2 = (this.maxValue - this.minValue) / this.getMainUnit();
        if (d2 == (double)n2) {
            if (!this.isPercentage) {
                ++n2;
            }
        } else {
            ++n2;
        }
        if (!this.isCustomMaxValue) {
            this.maxValue = this.minValue + (double)n2 * this.getMainUnit();
        }
    }

    private void dealWhenMaxIsLessThanMin() {
        if (this.minValue >= this.maxValue) {
            if (this.mainUnit.intValue() > 0) {
                this.maxValue = this.minValue + (double)(this.mainUnit.intValue() * 3);
            } else {
                int n2 = 1;
                double d2 = this.minValue;
                while (true) {
                    double d3;
                    d2 /= 10.0;
                    if (!(d3 > 1.0)) break;
                    ++n2;
                }
                double d4 = Math.pow(10.0, n2);
                this.maxValue = this.minValue + d4;
                this.setMainUnit(new BigDecimal(Double.toString(d4 / 5.0)));
                BigDecimal bigDecimal = this.getBigDecimalMainUnit().divide(new BigDecimal(5.0), 1);
                this.setSecUnit(bigDecimal.doubleValue());
            }
        }
    }

    private void recalculateMinMaxValueWithLog() {
        if (!this.isCustomMinValue) {
            if (this.minValue <= 1.0E-10) {
                this.minValue = 1.0;
            } else if (this.minValue < 1.0) {
                this.minValue = Math.pow(this.getMainUnit(), Math.round(Math.log(this.minValue) / Math.log(this.getMainUnit()) - 1.0));
            } else if (this.minValue >= 1.0) {
                this.minValue = 1.0;
            }
        }
        if (!this.isCustomMaxValue && this.maxValue <= 0.0) {
            this.maxValue = 10.0;
        }
    }

    public boolean equals(Object object) {
        return object instanceof NumberAxisGlyph && super.equals(object) && ComparatorUtils.equals(((NumberAxisGlyph)object).showUnit, this.showUnit) && ComparatorUtils.equals(((NumberAxisGlyph)object).unitPadding, this.unitPadding) && ComparatorUtils.equals(((NumberAxisGlyph)object).alertValues, this.alertValues) && ((NumberAxisGlyph)object).isLog == this.isLog && ((NumberAxisGlyph)object).baseLog == this.baseLog && ((NumberAxisGlyph)object).isPercentage == this.isPercentage;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("isLog", this.isLog);
        jSONObject.put("isPercentage", this.isPercentage);
        jSONObject.put("showUnit", this.showUnit);
        jSONObject.put("unitPadding", this.unitPadding);
        jSONObject.put("baseLog", this.baseLog);
        if (this.alertValues != null) {
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < this.alertValues.length; ++i2) {
                jSONArray.put(this.alertValues[i2].toJSONObject(repository));
            }
            jSONObject.put("alertList", jSONArray);
        }
        return jSONObject;
    }
}

