/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.base.chart.BaseChartGlyph;
import com.fr.base.chart.BaseChartPainter;
import com.fr.base.chart.ChangeConfigProvider;
import com.fr.base.chart.ChartRegisterForBI;
import com.fr.base.chart.Glyph;
import com.fr.base.chart.chartdata.CallbackEvent;
import com.fr.base.chart.chartdata.ChartDataParam;
import com.fr.base.chart.chartdata.TopDefinitionProvider;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.ChartGlyphLayout;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.GeneralGlyph;
import com.fr.chart.chartglyph.HeatMapControlBar;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.MapPlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartGlyph<T extends PlotGlyph, U extends LegendGlyph, V extends DataSheetGlyph>
extends RectangleGlyph
implements BaseChartGlyph {
    private static final long serialVersionUID = -4023596592305921803L;
    private JSONObject options = new JSONObject();
    private String wrapperName;
    private String[] requiredJS;
    private String chartImagePath = "";
    private T plotGlyph;
    private U legendGlyph;
    private TitleGlyph titleGlyph;
    private V dataSheetGlyph;
    private HeatMapControlBar mapControlBar;
    private boolean isJSDraw = false;
    private boolean isUseChangeChart = false;
    private boolean isUseDragRefresh = false;
    private TopDefinitionProvider dataDefinition;
    private boolean isExport = false;
    private double fontScale = 1.0;

    public boolean isExport() {
        return this.isExport;
    }

    @Override
    public void setFontScale(double d2) {
        this.fontScale = d2;
    }

    public double getFontScale() {
        return this.fontScale;
    }

    public void setExport(boolean bl) {
        this.isExport = bl;
    }

    public void setPlotGlyph(T t2) {
        this.plotGlyph = t2;
    }

    public T getPlotGlyph() {
        return this.plotGlyph;
    }

    public void setLegendGlyph(U u2) {
        this.legendGlyph = u2;
    }

    public U getLegendGlyph() {
        return this.legendGlyph;
    }

    public void setMapControlBar(HeatMapControlBar heatMapControlBar) {
        this.mapControlBar = heatMapControlBar;
    }

    public HeatMapControlBar getMapControlBar() {
        return this.mapControlBar;
    }

    public void setTitleGlyph(TitleGlyph titleGlyph) {
        this.titleGlyph = titleGlyph;
    }

    public TitleGlyph getTitleGlyph() {
        return this.titleGlyph;
    }

    public void setJSDraw(boolean bl) {
        this.isJSDraw = bl;
    }

    public boolean isJSDraw() {
        return this.isJSDraw;
    }

    public String beforeInitFunc() {
        return "";
    }

    @Override
    public void setUseChangeChart(boolean bl) {
        this.isUseChangeChart = bl;
    }

    public boolean isUseChangeChart() {
        return this.isUseChangeChart;
    }

    @Override
    public void setUseDragRefresh(boolean bl) {
        this.isUseDragRefresh = bl;
    }

    public boolean isUseDragRefresh() {
        return this.isUseDragRefresh;
    }

    public void setDataSheetGlyph(V v2) {
        this.dataSheetGlyph = v2;
    }

    public V getDataSheetGlyph() {
        return this.dataSheetGlyph;
    }

    public void setDataDefinition(TopDefinitionProvider topDefinitionProvider) {
        this.dataDefinition = topDefinitionProvider;
    }

    public void setOptions(JSONObject jSONObject) {
        this.options = jSONObject;
    }

    public void setWrapperName(String string) {
        this.wrapperName = string;
    }

    public void setRequiredJS(String[] stringArray) {
        this.requiredJS = stringArray;
    }

    public void setChartImagePath(String string) {
        this.chartImagePath = string;
    }

    @Override
    public Iterator selectableChildren() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.plotGlyph != null) {
            arrayList.add(this.plotGlyph);
        }
        if (this.legendGlyph != null) {
            arrayList.add(this.legendGlyph);
        }
        if (this.titleGlyph != null) {
            arrayList.add(this.titleGlyph);
        }
        if (this.dataSheetGlyph != null) {
            arrayList.add(this.dataSheetGlyph);
        }
        return arrayList.iterator();
    }

    @Override
    public Image toImage(int n2, int n3, int n4) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        double d2 = this.do4IEBorderSize(GraphHelper.getLineStyleSize(this.getBorderStyle()));
        double d3 = this.do4IEGap(GraphHelper.getLineStyleSize(this.getBorderStyle()));
        this.makeSureBounds(d2, n2, n3);
        graphics2D.translate(d3 / 2.0, d3 / 2.0);
        this.draw(graphics2D, n4);
        bufferedImage.flush();
        graphics2D.translate(-d3 / 2.0, -d3 / 2.0);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Deprecated
    public Image toImage(int n2, int n3, int n4, CallbackEvent callbackEvent) {
        return this.toImage(n2, n3, n4);
    }

    @Override
    public Image toImage(int n2, int n3, int n4, CallbackEvent callbackEvent, ChartDataParam chartDataParam) {
        return this.toImage(n2, n3, n4);
    }

    @Override
    public Map toJSONMap(String[] stringArray, double d2, double d3, Repository repository, int n2, String string) {
        JSONObject jSONObject = null;
        String string2 = "";
        try {
            jSONObject = this.toJSONObject(repository, d2, d3);
            string2 = JSONObject.valueToString(stringArray);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error("ChartGlyph error in toJS");
            jSONObject = new JSONObject();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("chartAttr", jSONObject);
        hashMap.put("width", String.valueOf(d2));
        hashMap.put("height", String.valueOf(d3));
        hashMap.put("dependence", string2);
        this.addRefresh2JSON(hashMap);
        if (this.getPlotGlyph() instanceof MapPlotGlyph && repository.getBrowser().isIE()) {
            hashMap.put("actionModel", "1");
        } else if (this.isJSDraw()) {
            hashMap.put("actionModel", "0");
        } else {
            hashMap.put("actionModel", "1");
        }
        hashMap.put("sheetIndex", n2);
        hashMap.put("ecName", string);
        hashMap.put("wrapperName", this.wrapperName);
        hashMap.put("jsOptions", this.options);
        hashMap.put("requiredJS", this.getRequiredJSArray());
        String string3 = this.getCanvasInfo();
        hashMap.put("canvasInfo", string3);
        hashMap.put("canvasCount", this.getCanvasCount(string3));
        return hashMap;
    }

    @Override
    public Map toJSONMap4Change(ChangeConfigProvider changeConfigProvider, BaseChartGlyph[] baseChartGlyphArray, String[] stringArray, double d2, double d3, Repository repository, int n2, String string) {
        Serializable serializable;
        JSONObject jSONObject = null;
        String string2 = "";
        try {
            jSONObject = JSONObject.create();
            jSONObject.put("switchStyle", changeConfigProvider.toJSONObject(repository));
            serializable = JSONArray.create();
            int n3 = baseChartGlyphArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!(baseChartGlyphArray[i2] instanceof ChartGlyph)) continue;
                ((JSONArray)serializable).put(((ChartGlyph)baseChartGlyphArray[i2]).toJSONObject(repository, d2, d3));
            }
            jSONObject.put("options", serializable);
            string2 = JSONObject.valueToString(stringArray);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("ChartGlyph error in toJS");
            jSONObject = new JSONObject();
        }
        serializable = new HashMap();
        serializable.put("chartAttr", jSONObject);
        serializable.put("width", String.valueOf(d2));
        serializable.put("height", String.valueOf(d3));
        serializable.put("dependence", string2);
        this.addRefreshArray2JSON((Map<String, Object>)((Object)serializable), baseChartGlyphArray);
        if (this.getPlotGlyph() instanceof MapPlotGlyph && repository.getBrowser().isIE()) {
            serializable.put("actionModel", "1");
        } else if (this.isJSDraw()) {
            serializable.put("actionModel", "0");
        } else {
            serializable.put("actionModel", "1");
        }
        serializable.put("sheetIndex", n2);
        serializable.put("ecName", string);
        serializable.put("wrapperName", this.wrapperName);
        serializable.put("jsOptions", this.options);
        serializable.put("requiredJS", this.getRequiredJSArray());
        String string3 = this.getCanvasInfo();
        serializable.put("canvasInfo", string3);
        serializable.put("canvasCount", this.getCanvasCount(string3));
        return serializable;
    }

    protected void addRefresh2JSON(Map<String, Object> map) {
        if (this.plotGlyph != null) {
            map.put("autoRefreshTime", ((PlotGlyph)this.plotGlyph).getAutoRefreshPerSecond());
        }
    }

    protected void addRefreshArray2JSON(Map<String, Object> map, BaseChartGlyph[] baseChartGlyphArray) {
        JSONArray jSONArray = JSONArray.create();
        for (int i2 = 0; i2 < baseChartGlyphArray.length; ++i2) {
            ChartGlyph chartGlyph = (ChartGlyph)baseChartGlyphArray[i2];
            T t2 = chartGlyph.getPlotGlyph();
            jSONArray.put(t2 == null ? 0 : ((PlotGlyph)t2).getAutoRefreshPerSecond());
        }
        if (baseChartGlyphArray.length > 0) {
            map.put("autoRefreshTime", jSONArray);
        }
    }

    private JSONArray getRequiredJSArray() {
        JSONArray jSONArray = new JSONArray();
        if (this.requiredJS != null) {
            for (int i2 = 0; i2 < this.requiredJS.length; ++i2) {
                jSONArray.put(this.requiredJS[i2]);
            }
        }
        return jSONArray;
    }

    private double do4IEBorderSize(double d2) {
        return d2 == 1.0 ? 2.0 : d2;
    }

    private double do4IEGap(double d2) {
        return d2 == 2.0 ? 0.0 : d2;
    }

    protected void makeSureBounds(double d2, int n2, int n3) {
        if (this.isRoundBorder()) {
            this.setBounds(new RoundRectangle2D.Double(0.0, 0.0, (double)n2 - d2, (double)n3 - d2, 10.0, 10.0));
        } else {
            this.setBounds(new Rectangle2D.Double(0.0, 0.0, (double)n2 - d2, (double)n3 - d2));
        }
    }

    @Override
    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        super.draw(graphics2D, n2);
        if (this.plotGlyph != null) {
            ((PlotGlyph)this.plotGlyph).setWholeChartBackground(this.getBackground());
            if (!((PlotGlyph)this.plotGlyph).isSupportLegend()) {
                this.legendGlyph = null;
            }
        }
        this.chartDoLayout(n2);
        this.drawGlyph((Glyph)this.plotGlyph, graphics2D, n2);
        this.drawGlyph(this.titleGlyph, graphics2D, n2);
        this.drawGlyph((Glyph)this.legendGlyph, graphics2D, n2);
        this.drawGlyph((Glyph)this.dataSheetGlyph, graphics2D, n2);
        if (this.mapControlBar != null) {
            this.mapControlBar.draw(graphics2D, n2);
        }
        if (StringUtils.isNotBlank(this.chartImagePath) && this.getBounds() != null) {
            BufferedImage bufferedImage = BaseUtils.readImage(this.chartImagePath);
            Rectangle2D rectangle2D = this.getBounds();
            double d2 = rectangle2D.getWidth();
            double d3 = rectangle2D.getHeight();
            GraphHelper.paintImage(graphics2D, (int)d2, (int)d3, bufferedImage, 4, -1, -1, -1, -1);
        }
        this.renewGraphics(graphics2D, paint, object);
    }

    @Override
    public Map toJSONMap4ChangeModel(BaseChartPainter baseChartPainter, double d2, double d3, Repository repository) {
        return null;
    }

    protected void chartDoLayout(int n2) {
        ChartGlyphLayout.doLayout(this, n2);
    }

    private void drawGlyph(Glyph glyph, Graphics2D graphics2D, int n2) {
        if (glyph != null) {
            glyph.draw(graphics2D.create(), n2);
        }
    }

    private void renewGraphics(Graphics2D graphics2D, Paint paint, Object object) {
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        if (object == null) {
            object = RenderingHints.VALUE_ANTIALIAS_OFF;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setPaint(paint);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ChartGlyph && super.equals(object) && ComparatorUtils.equals(((ChartGlyph)object).getPlotGlyph(), this.getPlotGlyph()) && ComparatorUtils.equals(((ChartGlyph)object).getTitleGlyph(), this.getTitleGlyph()) && ComparatorUtils.equals(((ChartGlyph)object).getLegendGlyph(), this.getLegendGlyph()) && ComparatorUtils.equals(((ChartGlyph)object).getDataSheetGlyph(), this.getDataSheetGlyph()) && ((ChartGlyph)object).isJSDraw() == this.isJSDraw;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ChartGlyph chartGlyph = (ChartGlyph)super.clone();
        if (this.legendGlyph != null) {
            chartGlyph.legendGlyph = (LegendGlyph)((RectangleGlyph)this.legendGlyph).clone();
        }
        if (this.titleGlyph != null) {
            chartGlyph.titleGlyph = (TitleGlyph)this.titleGlyph.clone();
        }
        if (this.plotGlyph != null) {
            chartGlyph.plotGlyph = (PlotGlyph)((PlotGlyph)this.plotGlyph).clone();
        }
        if (this.dataSheetGlyph != null) {
            chartGlyph.dataSheetGlyph = (DataSheetGlyph)((DataSheetGlyph)this.dataSheetGlyph).clone();
            ((DataSheetGlyph)chartGlyph.dataSheetGlyph).setDataWithoutLegendItems((PlotGlyph)chartGlyph.plotGlyph);
        }
        return chartGlyph;
    }

    public JSONObject toJSONObject(Repository repository, double d2, double d3) throws JSONException {
        return this.toJSONObject(repository);
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        if (this.plotGlyph != null && ((PlotGlyph)this.plotGlyph).isNeedDealHotHyperlink()) {
            ((PlotGlyph)this.plotGlyph).dealPlotHotAttr(repository);
        }
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.plotGlyph != null) {
            jSONObject.put("plotType", ((PlotGlyph)this.plotGlyph).getPlotGlyphType());
            jSONObject.put("plotGlyph", ((PlotGlyph)this.plotGlyph).toJSONObject(repository));
        }
        if (this.legendGlyph != null) {
            jSONObject.put("legendGlyph", ((LegendGlyph)this.legendGlyph).toJSONObject(repository));
        }
        if (this.titleGlyph != null) {
            jSONObject.put("titleGlyph", this.titleGlyph.toJSONObject(repository));
        }
        if (this.dataSheetGlyph != null) {
            jSONObject.put("dataSheetGlyph", ((DataSheetGlyph)this.dataSheetGlyph).toJSONObject(repository));
        }
        jSONObject.put("isUseChangeChart", this.isUseChangeChart);
        jSONObject.put("isUseDragRefresh", this.isUseDragRefresh);
        AttrFillStyle attrFillStyle = ChartUtils.getColorFillStyleInPre();
        if (attrFillStyle != null) {
            jSONObject.put("currentStyle", attrFillStyle.toJSONObject(repository));
        }
        String string = this.getCanvasInfo();
        jSONObject.put("canvasInfo", string);
        jSONObject.put("canvasCount", this.getCanvasCount(string));
        jSONObject.put("isFromReport", true);
        return jSONObject;
    }

    private String getCanvasInfo() {
        String string;
        String string2;
        String string3 = "";
        String string4 = string2 = this.getBackground() == null ? "" : this.getBackground().getBackgroundType();
        if (ComparatorUtils.equals(string2, "ImageBackground") || ComparatorUtils.equals(string2, "PatterBackground")) {
            string3 = string3 + "chart";
        }
        String string5 = string = this.plotGlyph == null || ((GeneralGlyph)this.plotGlyph).getBackground() == null ? "" : ((GeneralGlyph)this.plotGlyph).getBackground().getBackgroundType();
        if (ComparatorUtils.equals(string, "ImageBackground") || ComparatorUtils.equals(string, "PatterBackground") || this.plotGlyph instanceof MapPlotGlyph) {
            string3 = string3 + "plot";
        }
        return string3;
    }

    private int getCanvasCount(String string) {
        int n2 = 3;
        if (string.indexOf("chart") != -1) {
            ++n2;
        }
        if (string.indexOf("plot") != -1) {
            ++n2;
        }
        if (this.plotGlyph != null) {
            n2 += ((PlotGlyph)this.plotGlyph).getAdditionalCanvasCount();
        }
        return n2;
    }

    public boolean isChartSupportCanvas() {
        return ChartRegisterForBI.isSupportDynamicChart();
    }
}

