/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.BarDataWithAxisGlyph;
import com.fr.chart.chartglyph.BarPlotGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.Cubic;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Plot3DGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Bar3DPlotGlyph
extends BarPlotGlyph
implements Plot3DGlyph {
    private static final long serialVersionUID = -8494817723580336519L;
    private static final double ZP = 100.0;
    private static final double LABEL_BAR_GAP = 8.0;
    private int deep = -1;
    private int deepBase = -1;
    private boolean horizontalDrawBar = false;
    private Projection projection = new Projection();

    public void setDeep(int n2) {
        this.deep = n2;
    }

    public int getDeep() {
        return this.deep;
    }

    public void set3DDeepBase(int n2) {
        this.deepBase = n2;
    }

    public int getDeepBase() {
        return this.deepBase;
    }

    public void setHorizontalDrawBar(boolean bl) {
        this.horizontalDrawBar = bl;
    }

    public boolean isHorizontalDrawBar() {
        return this.horizontalDrawBar;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    protected void resetClip(Graphics2D graphics2D) {
    }

    protected byte[] get3DBaseCover() {
        byte[] byArray;
        if (this.isHorizontal) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 2;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 1;
        }
        return byArray;
    }

    protected boolean is3DBaseHorizontal() {
        return this.isHorizontal;
    }

    public void layoutAxisGlyph(int n2) {
        this.layoutDoubleAxisGlyph(this.getxAxisGlyph(), this.getyAxisGlyph(), this.getSecondAxisGlyph(), true, n2);
    }

    public void layoutDataSeriesGlyph(int n2) {
        int n3 = this.getSeriesSize();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.dealShape4Bar(this.getSeries(i2), this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), this.getSeriesAxisGlyph(i2), this.getSeriesSize(), i2), n2);
        }
        this.dealLabelBoundsInOrder();
    }

    public void dealShape4Bar(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, BarDataWithAxisGlyph barDataWithAxisGlyph, int n2) {
        int n3 = dataSeries.getDataPointCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            DataPoint dataPoint = dataSeries.getDataPoint(i2);
            if (dataPoint.isValueIsNull()) continue;
            Cubic cubic = new Cubic();
            cubic.setIsHorizontal(this.is3DBaseHorizontal());
            cubic.setProjection(this.getProjection());
            if (this.getSeriesSize() == 1) {
                cubic.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
                cubic.dealConditionWithSeriesColor(this.getConditionCollection(), dataPoint, this.createColors4Cate());
            } else {
                cubic.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
            }
            dataPoint.setDrawImpl(cubic);
            Rectangle2D rectangle2D = this.getBarShape(dataSeries, categoryPlotGlyph, i2, barDataWithAxisGlyph);
            double d2 = this.get3DDeep((Plot3DGlyph)((Object)categoryPlotGlyph));
            double d3 = 0.0;
            if (!this.isStacked()) {
                d3 = -(d2 /= (double)barDataWithAxisGlyph.barNumber) * (double)barDataWithAxisGlyph.barIndex;
            }
            if (categoryPlotGlyph.isNeedDefaultDeep()) {
                d3 = 0.0;
                d2 = 100.0;
            }
            cubic.setCubic(rectangle2D.getX(), rectangle2D.getY(), d3, rectangle2D.getWidth(), rectangle2D.getHeight(), d2);
            this.dealDataPointLabel(dataPoint, n2);
        }
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.draw3DInfo(graphics, n2);
        this.drawAxisGlyph4ThreeD(this.getyAxisGlyph(), graphics, n2);
        this.drawAxisGlyph4ThreeD(this.getSecondAxisGlyph(), graphics, n2);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisGlyph4ThreeD(this.getxAxisGlyph(), graphics, n2);
        if (!this.isStacked()) {
            this.drawWhenUnStacked(graphics2D, n2);
        } else {
            this.drawWhenStacked(graphics2D, n2);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawWhenUnStacked(Graphics2D graphics2D, int n2) {
        int n3;
        if (this.horizontalDrawBar) {
            n3 = this.getCategoryCount();
            int n4 = this.getSeriesSize();
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (this.getSeries(i3) == null || this.getSeries(i3).getDataPoint(i2) == null) continue;
                    this.getSeries(i3).getDataPoint(i2).draw(graphics2D, n2);
                }
            }
        } else {
            for (n3 = this.getSeriesSize() - 1; n3 >= 0; --n3) {
                if (this.getSeries(n3) == null) continue;
                this.getSeries(n3).draw(graphics2D, n2);
            }
        }
        for (n3 = this.getSeriesSize() - 1; n3 >= 0; --n3) {
            if (this.getSeries(n3) == null) continue;
            this.getSeries(n3).drawLabel(graphics2D, n2);
        }
    }

    private void drawWhenStacked(Graphics2D graphics2D, int n2) {
        int n3;
        int n4 = this.getCategoryCount();
        int n5 = this.getSeriesSize();
        for (n3 = 0; n3 < n4; ++n3) {
            int n6;
            DataPoint[] dataPointArray = new DataPoint[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                if (this.getSeries(n6) == null) continue;
                dataPointArray[n6] = this.getSeries(n6).getDataPoint(n3);
            }
            for (n6 = 0; n6 < n5; ++n6) {
                for (int i2 = n5 - 1; i2 > n6; --i2) {
                    if (dataPointArray[i2] == null || dataPointArray[i2].isValueIsNull() || !(dataPointArray[i2].getValue() < 0.0)) continue;
                    DataPoint dataPoint = dataPointArray[i2];
                    dataPointArray[i2] = dataPointArray[i2 - 1];
                    dataPointArray[i2 - 1] = dataPoint;
                }
            }
            for (n6 = 0; n6 < n5; ++n6) {
                if (dataPointArray[n6] == null) continue;
                dataPointArray[n6].draw(graphics2D, n2);
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.getSeries(n3) == null) continue;
            this.getSeries(n3).drawLabel(graphics2D, n2);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Bar3DPlotGlyph && super.equals(object) && ((Bar3DPlotGlyph)object).deep == this.deep && ComparatorUtils.equals(((Bar3DPlotGlyph)object).projection, this.projection);
    }

    public Object clone() throws CloneNotSupportedException {
        Bar3DPlotGlyph bar3DPlotGlyph = (Bar3DPlotGlyph)super.clone();
        if (this.projection != null) {
            bar3DPlotGlyph.projection = (Projection)this.projection.clone();
        }
        return bar3DPlotGlyph;
    }

    public Shape getOutline4Fill() {
        if (this.isHorizontal) {
            Point2D point2D = this.threeDBase.getBasePoint();
            double d2 = this.threeDBase.getWidth();
            double d3 = this.threeDBase.getHeight() - this.getyAxisGlyph().getBounds().getHeight();
            return new Rectangle2D.Double(point2D.getX(), point2D.getY(), d2, d3);
        }
        return super.getOutline4Fill();
    }

    public boolean is3DPlotGlyph() {
        return true;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("deep", this.deep);
        jSONObject.put("horizontalDrawBar", this.horizontalDrawBar);
        jSONObject.put("isHorizontal", this.isHorizontal);
        if (this.projection != null) {
            jSONObject.put("projection", this.projection.toJSONObject());
        }
        return jSONObject;
    }

    public String getPlotDetailType() {
        String string = "";
        string = this.isHorizontal() ? string + "Bar3DPlotGlyph" : string + "Column3DPlotGlyph";
        if (this.isStacked()) {
            string = string + "-Stack";
        }
        if (this.getyAxisGlyph().isPercentage()) {
            string = string + "-Percentage";
        }
        if (this.isHorizontalDrawBar()) {
            string = string + "-Landscape";
        }
        return string;
    }

    public boolean isNeedDefaultDeep() {
        return this.isHorizontalDrawBar() || this.isStacked();
    }

    public String getPlotGlyphType() {
        return "Bar3DPlotGlyph";
    }

    public String getChartType() {
        return "Bar3D";
    }
}

