/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.GeneralGlyph;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.script.Calculator;
import com.fr.stable.FCloneable;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Title
extends GeneralInfo
implements XMLable {
    private static final long serialVersionUID = 1L;
    public static final String XML_TAG = "Title";
    private Object text;
    private TextAttr textAttr = new TextAttr();
    private boolean titleVisible = true;
    private int position = 0;

    public Title() {
        FRFont fRFont = FRFont.getInstance("Microsoft YaHei", 0, 11.0f);
        this.textAttr.setFRFont(fRFont);
        this.text = Inter.getLocText("FR-Chart-Title_NewTitle");
        this.setBorderColor(new Color(150, 150, 150));
        this.setBorderStyle(0);
    }

    public Title(Object object) {
        this.text = object;
    }

    public TitleGlyph createGlyph() {
        FCloneable fCloneable;
        String string = Utils.objectToString(this.text);
        if (this.text instanceof Formula && ((Formula)(fCloneable = (Formula)this.text)).getResult() != null) {
            string = Utils.objectToString(((Formula)fCloneable).getResult());
        }
        fCloneable = new TitleGlyph(string.trim(), this.textAttr);
        ((GeneralGlyph)fCloneable).setGeneralInfo(this);
        ((TextGlyph)fCloneable).setPosition(this.position);
        ((RectangleGlyph)fCloneable).setVisible(this.isTitleVisible());
        return fCloneable;
    }

    public TextGlyph createGlyph4AxisTitle() {
        FCloneable fCloneable;
        String string = Utils.objectToString(this.text);
        if (this.text instanceof Formula && ((Formula)(fCloneable = (Formula)this.text)).getResult() != null) {
            string = Utils.objectToString(((Formula)fCloneable).getResult());
        }
        fCloneable = new TextGlyph(string.trim(), this.textAttr);
        ((GeneralGlyph)fCloneable).setGeneralInfo(this);
        ((TextGlyph)fCloneable).setPosition(this.position);
        ((RectangleGlyph)fCloneable).setVisible(this.isTitleVisible());
        return fCloneable;
    }

    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        if (this.text instanceof Formula) {
            list.addAll(Arrays.asList(((Formula)this.text).dependence(calculatorProvider)));
        }
    }

    public Object getTextObject() {
        return this.text;
    }

    public void setTextObject(Object object) {
        this.text = object;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.text = textAttr;
    }

    public void setPosition(int n2) {
        this.position = n2;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    public void setTitleVisible(boolean bl) {
        this.titleVisible = bl;
    }

    @Deprecated
    public void setTitleVisble(boolean bl) {
        this.titleVisible = bl;
    }

    @Deprecated
    public boolean isTitleVisble() {
        return this.isTitleVisible();
    }

    public void dealFormula(Calculator calculator) {
        Utils.dealFormulaValue(this.text, calculator);
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        GeneralUtils.dealBuidExecuteSequence(this.text, list, calculator);
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        mOD_COLUMN_ROW.mod_object(this.text);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Title title = (Title)super.clone();
        if (this.textAttr != null) {
            title.textAttr = (TextAttr)this.textAttr.clone();
        }
        if (this.text instanceof Formula) {
            title.text = ((Formula)this.text).clone();
        }
        return title;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("O".equals(string)) {
                this.text = GeneralXMLTools.readObject(xMLableReader);
            } else if ("TextAttr".equals(string)) {
                this.textAttr = new TextAttr();
                xMLableReader.readXMLObject(this.textAttr);
                if (this.textAttr != null && !xMLableReader.getXMLVersion().isAfterPRIVILGE_FOR7_0_5_XML_VERSION()) {
                    this.textAttr.setRotation(0);
                }
            } else if ("TitleVisible".equals(string)) {
                this.titleVisible = xMLableReader.getAttrAsBoolean("value", true);
                this.position = xMLableReader.getAttrAsInt("position", 0);
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.text != null) {
            GeneralXMLTools.writeObject(xMLPrintWriter, this.text);
        }
        if (this.textAttr != null) {
            this.textAttr.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.startTAG("TitleVisible").attr("value", this.titleVisible).attr("position", this.position).end();
        xMLPrintWriter.end();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Title && super.equals(object) && ComparatorUtils.equals(((Title)object).getTextObject(), this.text) && ComparatorUtils.equals(((Title)object).getTextAttr(), this.textAttr) && ((Title)object).isTitleVisible() == this.titleVisible && ((Title)object).getPosition() == this.position;
    }
}

