/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.FRContext;
import com.fr.base.chart.BaseChartGlyph;
import com.fr.base.chart.ChangeConfigProvider;
import com.fr.base.chart.ChartWebSource;
import com.fr.chart.base.AttrContents;
import com.fr.chart.chartattr.ChartPainter;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.core.UUID;
import com.fr.stable.html.Tag;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.SessionIDInfor;
import java.awt.Image;
import java.util.Map;

public class EChartPaintUtils {
    static JSONObject createJSon4ChartPainter(NodeVisitor nodeVisitor, ChartPainter chartPainter, Repository repository, int n2, int n3) {
        return EChartPaintUtils.paintTag(nodeVisitor, chartPainter, repository, n2, n3, new JSONObject());
    }

    private static JSONObject paintTag(NodeVisitor nodeVisitor, ChartPainter chartPainter, Repository repository, int n2, int n3, JSONObject jSONObject) {
        String string = UUID.randomUUID().toString();
        chartPainter.setID(chartPainter.getID() + "__" + string);
        try {
            JSONArray jSONArray = EChartPaintUtils.chartPainter2JSArray(chartPainter, repository, n2, n3);
            jSONObject.put("items", jSONArray);
            jSONObject.put("type", "simplechart");
            jSONObject.put("isNeedRefreshButton", EChartPaintUtils.isNeedRefreshButton(chartPainter));
            jSONObject.put("chartWidth", n2);
            jSONObject.put("chartHeight", n3);
            int n4 = chartPainter.getSelectedIndex();
            if (n4 < 0 || n4 >= chartPainter.getGlyphCount()) {
                n4 = 0;
            }
            jSONObject.put("selectedIndex", n4);
            String string2 = repository.getDevice().isMobile() ? chartPainter.getID() : "ChartPainter__" + chartPainter.getID();
            jSONObject.put("chartpainter_id_web_change_selected", string2);
            ChartWebSource.putChartSource(repository.getSessionID(), string2, chartPainter);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        if (nodeVisitor != null) {
            nodeVisitor.visit("simplechart", jSONObject);
        }
        return jSONObject;
    }

    private static boolean isNeedRefreshButton(ChartPainter chartPainter) {
        boolean bl = false;
        int n2 = chartPainter.getGlyphCount();
        for (int i2 = 0; i2 < n2 && !bl; ++i2) {
            ChartGlyph chartGlyph;
            Object t2;
            Object object = chartPainter.getGlyph(i2);
            if (!(object instanceof ChartGlyph) || (t2 = (chartGlyph = (ChartGlyph)object).getPlotGlyph()) == null) continue;
            bl = bl || ((PlotGlyph)t2).isSeriesDragEnable();
        }
        return bl;
    }

    private static void putChartType(JSONObject jSONObject, ChartGlyph chartGlyph) throws JSONException {
        if (chartGlyph != null && chartGlyph.getPlotGlyph() != null) {
            jSONObject.put("chartImageType", ((PlotGlyph)chartGlyph.getPlotGlyph()).getPlotDetailType());
            jSONObject.put("simpleIconType", ((PlotGlyph)chartGlyph.getPlotGlyph()).getSmallIconType());
        }
    }

    private static JSONArray chartPainter2JSArray(ChartPainter chartPainter, Repository repository, int n2, int n3) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        ChangeConfigProvider changeConfigProvider = chartPainter.getChangConfig();
        repository.setFontScale(chartPainter.getFontScale());
        if (changeConfigProvider != null && changeConfigProvider.useChangeModel()) {
            EChartPaintUtils.createJson4Change(chartPainter, repository, jSONArray, n2, n3);
        } else {
            EChartPaintUtils.createJson4NoChange(chartPainter, repository, jSONArray, n2, n3);
        }
        return jSONArray;
    }

    private static void createJson4Change(ChartPainter chartPainter, Repository repository, JSONArray jSONArray, int n2, int n3) throws JSONException {
        if (chartPainter.getGlyphCount() == 0) {
            return;
        }
        chartPainter.setSelectedIndex(0);
        JSONObject jSONObject = new JSONObject();
        int n4 = chartPainter.getSelectedIndex();
        jSONObject.put("name", chartPainter.getGlyphName(n4));
        if (chartPainter.getGlyph(n4) instanceof ChartGlyph) {
            ChartGlyph chartGlyph = (ChartGlyph)chartPainter.getGlyph(n4);
            EChartPaintUtils.putChartType(jSONObject, chartGlyph);
            jSONObject.put("chartJSDraw", chartGlyph.isJSDraw());
            jSONObject.put("beforeInit", chartGlyph.beforeInitFunc());
            String string = chartPainter.getID() + "__index__" + n4;
            BaseChartGlyph[] baseChartGlyphArray = new ChartGlyph[chartPainter.getGlyphCount()];
            int n5 = chartPainter.getGlyphCount();
            for (int i2 = 0; i2 < n5; ++i2) {
                baseChartGlyphArray[i2] = (ChartGlyph)chartPainter.getGlyph(i2);
                baseChartGlyphArray[i2].setFontScale(chartPainter.getFontScale());
            }
            Map map = chartGlyph.toJSONMap4Change(chartPainter.getChangConfig(), baseChartGlyphArray, chartPainter.getWidgetDependenced(), n2, n3, repository, chartPainter.getSheetIndex(), chartPainter.getECName());
            ChartWebSource.putChartSource(repository.getSessionID(), string, map);
            jSONObject.put("url", EChartPaintUtils.getChartGlyphURL(string, repository));
            jSONObject.put("isJS", true);
            jSONObject.put("simpleChartInShowID", string);
            jSONArray.put(jSONObject);
        } else if (chartPainter.getGlyph(n4) instanceof Image) {
            jSONObject.put("url", repository.checkoutObject(chartPainter.getGlyph(n4), "image"));
            jSONArray.put(jSONObject);
        }
    }

    private static void createJson4NoChange(ChartPainter chartPainter, Repository repository, JSONArray jSONArray, int n2, int n3) throws JSONException {
        int n4 = chartPainter.getGlyphCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("name", chartPainter.getGlyphName(i2));
            if (chartPainter.getGlyph(i2) instanceof ChartGlyph) {
                ChartGlyph chartGlyph = (ChartGlyph)chartPainter.getGlyph(i2);
                EChartPaintUtils.putChartType(jSONObject, chartGlyph);
                jSONObject.put("chartJSDraw", chartGlyph.isJSDraw());
                jSONObject.put("beforeInit", chartGlyph.beforeInitFunc());
                if (EChartPaintUtils.isChartSupportCanvas(repository, chartGlyph)) {
                    String string = chartPainter.getID() + "__index__" + i2;
                    chartGlyph.setFontScale(chartPainter.getFontScale());
                    Map map = chartGlyph.toJSONMap(chartPainter.getWidgetDependenced(), n2, n3, repository, chartPainter.getSheetIndex(), chartPainter.getECName());
                    ChartWebSource.putChartSource(repository.getSessionID(), string, map);
                    jSONObject.put("url", EChartPaintUtils.getChartGlyphURL(string, repository));
                    jSONObject.put("isJS", true);
                    jSONObject.put("simpleChartInShowID", string);
                } else {
                    EChartPaintUtils.notSupportCanvas(chartGlyph, repository, jSONObject, n2, n3);
                }
                jSONArray.put(jSONObject);
                continue;
            }
            if (!(chartPainter.getGlyph(i2) instanceof Image)) continue;
            jSONObject.put("url", repository.checkoutObject(chartPainter.getGlyph(i2), "image"));
            jSONArray.put(jSONObject);
        }
    }

    private static void notSupportCanvas(ChartGlyph chartGlyph, Repository repository, JSONObject jSONObject, int n2, int n3) throws JSONException {
        if (chartGlyph.getPlotGlyph() != null && ((PlotGlyph)chartGlyph.getPlotGlyph()).is3DPlotGlyph() && repository.getBrowser().shouldConsiderVML()) {
            chartGlyph.is3DIE6(true);
        }
        Image image = chartGlyph.toImage(n2, n3, repository.getResolution());
        jSONObject.put("url", repository.checkoutObject(image, "image"));
        image = null;
        Object t2 = chartGlyph.getPlotGlyph();
        if (t2 != null && ((PlotGlyph)t2).isNeedDealHotHyperlink()) {
            String string = "chart_hotmap_" + chartGlyph.getPlotGlyph().hashCode();
            jSONObject.put("usemap", "#" + string);
            jSONObject.put("mapHtml", EChartPaintUtils.dealChartHot(chartGlyph, string, repository).toHtml());
        }
    }

    private static boolean isChartSupportCanvas(Repository repository, ChartGlyph chartGlyph) {
        return repository.getBrowser().supportCanvas() && chartGlyph.isChartSupportCanvas();
    }

    private static String getChartGlyphURL(String string, Repository repository) {
        String string2 = CodeUtils.cjkEncode(string);
        SessionIDInfor sessionIDInfor = RepositoryHelper.getSessionIDInfor(repository);
        return "?op=chart&cmd=writer_out_html&sessionID=" + sessionIDInfor.getSessionID() + "&chartID=" + string2;
    }

    private static Tag dealChartHot(ChartGlyph chartGlyph, String string, Repository repository) {
        Object t2 = chartGlyph.getPlotGlyph();
        Tag tag = new Tag("map");
        tag.attr("name", string);
        tag.attr("id", string);
        int n2 = 0;
        int n3 = ((PlotGlyph)t2).getCategoryCount();
        int n4 = ((PlotGlyph)t2).getSeriesSize();
        int[] nArray = ((PlotGlyph)t2).getDrawSequence();
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            int n5;
            DataPoint[] dataPointArray = new DataPoint[n4];
            for (n5 = n4 - 1; n5 >= 0; --n5) {
                if (((PlotGlyph)t2).getSeries(nArray[n5]) == null) continue;
                dataPointArray[n5] = ((PlotGlyph)t2).getSeries(nArray[n5]).getDataPoint(i2);
            }
            for (n5 = 0; n5 < n4; ++n5) {
                for (int i3 = n4 - 1; i3 > n5; --i3) {
                    if (dataPointArray[i3] == null || dataPointArray[i3].isValueIsNull() || !(dataPointArray[i3].getValue() < 0.0)) continue;
                    DataPoint dataPoint = dataPointArray[i3];
                    dataPointArray[i3] = dataPointArray[i3 - 1];
                    dataPointArray[i3 - 1] = dataPoint;
                }
            }
            for (n5 = n4 - 1; n5 >= 0; --n5) {
                if (dataPointArray[n5] == null) continue;
                EChartPaintUtils.dealDataPointHot(dataPointArray[n5], chartGlyph, n2, tag, repository);
                ++n2;
            }
        }
        return tag;
    }

    private static void dealDataPointHot(DataPoint dataPoint, ChartGlyph chartGlyph, int n2, Tag tag, Repository repository) {
        Object t2 = chartGlyph.getPlotGlyph();
        Tag tag2 = dataPoint.getImageMapAreaTag(chartGlyph);
        if (tag2 != null) {
            tag.sub(tag2);
            tag2.attr("id", n2 + "");
            if (((PlotGlyph)t2).getHotHyperLink() != null) {
                EChartPaintUtils.dealChartHotHyperLink(((PlotGlyph)t2).getHotHyperLink(), dataPoint, tag2, repository);
            }
            if (((PlotGlyph)t2).getHotTooltipStyle() != null) {
                EChartPaintUtils.dealChartHotTooltip(((PlotGlyph)t2).getHotTooltipStyle(), dataPoint, tag2);
            }
        }
    }

    private static void dealChartHotHyperLink(NameJavaScriptGroup nameJavaScriptGroup, DataPoint dataPoint, Tag tag, Repository repository) {
        String string = dataPoint.createDataPointHotHyperLink(nameJavaScriptGroup, repository);
        if (string != null) {
            tag.attr("cursor", "pointer");
            tag.attr("onclick", "FR.doHyperlink(event||window.event, " + string + ", true)");
            if (repository.getBrowser().isNoBlurInImage()) {
                tag.attr("onfocus", "this.blur()");
            }
            tag.attr("href", "javascript:void(0)");
        }
    }

    private static void dealChartHotTooltip(AttrContents attrContents, DataPoint dataPoint, Tag tag) {
        tag.attr("title", dataPoint.createHotTooltip(attrContents));
    }
}

