/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.FRContext;
import com.fr.base.ScreenResolution;
import com.fr.chart.chartglyph.Cubic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CubicDemo
extends JFrame {
    private static final long serialVersionUID = 6195542986931264012L;
    CubicComponent comp;
    JSpinner rotation_spinner;
    JSpinner elevation_spinner;
    JSpinner focus_spinner;

    public static void main(String[] stringArray) {
        new CubicDemo();
    }

    public CubicDemo() {
        this.init();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
        this.setTitle("Cubic Demo");
        this.setVisible(true);
        this.comp.play();
    }

    private void init() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        this.comp = new CubicComponent(new Cubic(0.0, 0.0, 200.0, 200.0));
        jPanel.add((Component)this.comp, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "South");
        this.rotation_spinner = new JSpinner();
        this.rotation_spinner.setValue(new Integer(this.comp.getCubic().getProjection().getRotation()));
        this.elevation_spinner = new JSpinner();
        this.elevation_spinner.setValue(new Integer(this.comp.getCubic().getProjection().getElevation()));
        this.focus_spinner = new JSpinner();
        this.focus_spinner.setValue(new Integer(this.comp.getCubic().getProjection().getFocus()));
        jPanel2.setLayout(new GridLayout(3, 2));
        jPanel2.add(new JLabel("\u6c34\u5e73\u8f6c\u89d2:"));
        jPanel2.add(this.rotation_spinner);
        jPanel2.add(new JLabel("\u4e0a\u4e0b\u4ef0\u89d2:"));
        jPanel2.add(this.elevation_spinner);
        jPanel2.add(new JLabel("\u900f\u89c6\u7cfb\u6570:"));
        jPanel2.add(this.focus_spinner);
        this.rotation_spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n2 = (int)((Number)CubicDemo.this.rotation_spinner.getValue()).doubleValue();
                CubicDemo.this.comp.setRotaion(n2);
            }
        });
        this.elevation_spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n2 = (int)((Number)CubicDemo.this.elevation_spinner.getValue()).doubleValue();
                CubicDemo.this.comp.setElevation(n2);
            }
        });
        this.focus_spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n2 = (int)((Number)CubicDemo.this.focus_spinner.getValue()).doubleValue();
                CubicDemo.this.comp.setFocus(n2);
            }
        });
    }

    private class CubicComponent
    extends JComponent {
        private static final long serialVersionUID = 937932901270377519L;
        Cubic cubic = null;

        public CubicComponent(Cubic cubic) {
            this.cubic = cubic;
            this.cubic.getProjection().setMode((byte)1);
        }

        public void paintComponent(Graphics graphics) {
            graphics.translate(300, 100);
            this.cubic.draw(graphics, ScreenResolution.getScreenResolution());
        }

        public void play() {
            int n2 = 0;
            block2: while (true) {
                n2 += 10;
                int n3 = 0;
                while (true) {
                    if (n3 >= 360) continue block2;
                    this.cubic.getProjection().setRotation(n3 + n2);
                    CubicDemo.this.rotation_spinner.setValue(new Integer(n3 + n2));
                    this.cubic.getProjection().setElevation(n3);
                    CubicDemo.this.elevation_spinner.setValue(new Integer(n3));
                    this.repaint();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().error("CubicComponent is error", exception);
                    }
                    n3 += 10;
                }
                break;
            }
        }

        public void setRotaion(int n2) {
            this.cubic.getProjection().setRotation(n2);
            this.repaint();
        }

        public void setElevation(int n2) {
            this.cubic.getProjection().setElevation(n2);
            this.repaint();
        }

        public void setFocus(int n2) {
            this.cubic.getProjection().setFocus(n2);
            this.repaint();
        }

        public Cubic getCubic() {
            return this.cubic;
        }
    }
}

