/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.chart.base.AttrCurveLine;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.AttrNullValueBreak;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

public class AttrLineSeries
extends DataSeriesCondition {
    public static final String XML_TAG = "AttrLineSeries";
    private ChartAxisPosition axisPosition = ChartAxisPosition.AXIS_RIGHT;
    private boolean isCurve = false;
    private boolean isNullValueBreak = true;
    private int lineStyle = 5;
    private String markerType = "NullMarker";

    public AttrLineSeries(ChartAxisPosition chartAxisPosition) {
        this.axisPosition = chartAxisPosition;
    }

    public AttrLineSeries() {
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            this.setCurve(xMLableReader.getAttrAsBoolean("isCurve", false));
            this.setNullValueBreak(xMLableReader.getAttrAsBoolean("isNullValueBreak", true));
            this.setLineStyle(xMLableReader.getAttrAsInt("lineStyle", 5));
            this.setMarkerType(xMLableReader.getAttrAsString("markerType", "NullMarker"));
            this.setAxisPosition(ChartAxisPosition.parse(xMLableReader.getAttrAsString("axisPosition", ChartAxisPosition.AXIS_LEFT.getAxisPosition())));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("isCurve", this.isCurve).attr("isNullValueBreak", this.isNullValueBreak).attr("lineStyle", this.lineStyle).attr("markerType", this.markerType).attr("axisPosition", this.axisPosition.getAxisPosition()).end();
        xMLPrintWriter.end();
    }

    public boolean isCurve() {
        return this.isCurve;
    }

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public boolean isNullValueBreak() {
        return this.isNullValueBreak;
    }

    public void setNullValueBreak(boolean bl) {
        this.isNullValueBreak = bl;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int n2) {
        this.lineStyle = n2;
    }

    public String getMarkerType() {
        return this.markerType;
    }

    public void setMarkerType(String string) {
        this.markerType = string;
    }

    public ChartAxisPosition getAxisPosition() {
        return this.axisPosition;
    }

    public void setAxisPosition(ChartAxisPosition chartAxisPosition) {
        this.axisPosition = chartAxisPosition;
    }

    public void addNormalAttrConditions(List list) {
        list.add(new AttrLineStyle(this.lineStyle));
        list.add(new AttrMarkerType(this.markerType));
        list.add(new AttrNullValueBreak(this.isNullValueBreak));
        list.add(new AttrCurveLine(this.isCurve));
    }

    public boolean equals(Object object) {
        return object instanceof AttrLineSeries && ((AttrLineSeries)object).isCurve == this.isCurve && ((AttrLineSeries)object).isNullValueBreak == this.isNullValueBreak && ((AttrLineSeries)object).lineStyle == this.lineStyle && ComparatorUtils.equals(((AttrLineSeries)object).markerType, this.markerType) && ComparatorUtils.equals((Object)((AttrLineSeries)object).axisPosition, (Object)this.axisPosition);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("isCurve", this.isCurve);
        jSONObject.put("isNullValueBreak", this.isNullValueBreak);
        jSONObject.put("lineStyle", this.lineStyle);
        jSONObject.put("markerType", this.markerType);
        jSONObject.put("axisPosition", this.axisPosition.getAxisPosition());
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

