/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.ChartPreStyleManagerProvider;
import com.fr.base.ChartPreStyleServerManager;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class AttrFillStyle
extends DataSeriesCondition {
    private static final long serialVersionUID = 3618157424711826953L;
    public static final String XML_TAG = "AttrFillStyle";
    private int colorStyle = 0;
    private ArrayList colorList = new ArrayList();
    private String fillStyleName = "";
    private boolean isCustomFillStyle = false;

    public boolean isCustomFillStyle() {
        return this.isCustomFillStyle;
    }

    public void setCustomFillStyle(boolean bl) {
        this.isCustomFillStyle = bl;
    }

    public void setFillStyleName(String string) {
        this.fillStyleName = string;
    }

    public String getFillStyleName() {
        return this.fillStyleName;
    }

    public void setColorStyle(int n2) {
        this.colorStyle = n2;
    }

    public int getColorStyle() {
        return this.colorStyle;
    }

    public Color getColorIndex(int n2) {
        if (n2 >= 0) {
            return (Color)this.colorList.get(n2 % this.colorList.size());
        }
        return Color.white;
    }

    public void clearColors() {
        this.colorList.clear();
    }

    public int getColorSize() {
        return this.colorList.size();
    }

    public boolean colorListIsEmpty() {
        return this.colorList.isEmpty();
    }

    public void addFillColor(Color color) {
        this.colorList.add(color);
    }

    public List getColorList() {
        return this.colorList;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("colorStyle", this.colorStyle);
        if (!this.colorList.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            int n2 = this.colorList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Color color = (Color)this.colorList.get(i2);
                if (color == null) continue;
                jSONArray.put(StableUtils.javaColorToCSSColor(color));
            }
            jSONObject.put("colorList", jSONArray);
        }
        return jSONObject;
    }

    public JSONObject changedAttrToJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("colorStyle", ChartUtils.getColorStyleString(this.colorStyle));
        ChartPreStyleManagerProvider chartPreStyleManagerProvider = ChartPreStyleServerManager.getProviderInstance();
        if (chartPreStyleManagerProvider.containsName(this.fillStyleName)) {
            jSONObject.put("definedColors", ChartUtils.getDefinedColorsByName(this.fillStyleName));
        } else if (!this.colorList.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            int n2 = this.colorList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Color color = (Color)this.colorList.get(i2);
                if (color == null) continue;
                jSONArray.put(StableUtils.javaColorToCSSColor(color));
            }
            jSONObject.put("colorList", jSONArray);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                Color color = xMLableReader.getAttrAsColor("startColor", null);
                Color color2 = xMLableReader.getAttrAsColor("endColor", null);
                this.colorList.clear();
                this.setColorStyle(0);
                if (color != null && color2 != null) {
                    this.colorList.add(color);
                    this.colorList.add(color2);
                    this.setColorStyle(2);
                }
            } else if (ComparatorUtils.equals("AFStyle", string)) {
                this.setColorStyle(xMLableReader.getAttrAsInt("colorStyle", 0));
            } else if (ComparatorUtils.equals("FillStyleName", string)) {
                this.setFillStyleName(xMLableReader.getAttrAsString("fillStyleName", ""));
            } else if (ComparatorUtils.equals("isCustomFillStyle", string)) {
                this.setCustomFillStyle(xMLableReader.getAttrAsBoolean("isCustomFillStyle", false));
            } else if (ComparatorUtils.equals("ColorList", string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals(xMLableReader.getTagName(), "OColor")) {
                            Color color = xMLableReader.getAttrAsColor("colvalue", Color.white);
                            AttrFillStyle.this.addFillColor(color);
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("AFStyle").attr("colorStyle", this.colorStyle).end();
        xMLPrintWriter.startTAG("FillStyleName").attr("fillStyleName", this.fillStyleName).end();
        xMLPrintWriter.startTAG("isCustomFillStyle").attr("isCustomFillStyle", this.isCustomFillStyle).end();
        if (!this.colorList.isEmpty()) {
            xMLPrintWriter.startTAG("ColorList");
            int n2 = this.colorList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                xMLPrintWriter.startTAG("OColor");
                Color color = (Color)this.colorList.get(i2);
                if (color != null) {
                    xMLPrintWriter.attr("colvalue", color.getRGB());
                }
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof AttrFillStyle && ComparatorUtils.equals((Object)this.colorList, (Object)((AttrFillStyle)object).colorList) && ComparatorUtils.equals(this.fillStyleName, ((AttrFillStyle)object).fillStyleName) && this.colorStyle == ((AttrFillStyle)object).colorStyle && this.isCustomFillStyle() == ((AttrFillStyle)object).isCustomFillStyle();
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

