/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process;

import com.vaadin.data.Item;
import com.vaadin.data.util.PropertysetItem;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.process.ProcessDefinitionFilter;

public class ProcessDefinitionListQuery
extends AbstractLazyLoadingQuery {
    protected transient RepositoryService repositoryService;
    protected ProcessDefinitionFilter filter;

    public ProcessDefinitionListQuery(RepositoryService repositoryService, ProcessDefinitionFilter filter) {
        this.repositoryService = repositoryService;
        this.filter = filter;
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        List processDefinitions = this.filter.getQuery(this.repositoryService).listPage(start, count);
        ArrayList<Item> items = new ArrayList<Item>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            items.add((Item)this.filter.createItem(processDefinition));
        }
        return items;
    }

    @Override
    public Item loadSingleResult(String id) {
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
        if (definition != null) {
            return this.filter.createItem(definition);
        }
        return null;
    }

    @Override
    public int size() {
        return (int)this.filter.getCountQuery(this.repositoryService).count();
    }

    @Override
    public void setSorting(Object[] propertyId, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    public static class ProcessDefinitionListItem
    extends PropertysetItem
    implements Comparable<ProcessDefinitionListItem> {
        private static final long serialVersionUID = 1L;

        @Override
        public int compareTo(ProcessDefinitionListItem other) {
            String otherName;
            String name = (String)this.getItemProperty("name").getValue();
            int comparison = name.compareTo(otherName = (String)other.getItemProperty("name").getValue());
            if (comparison != 0) {
                return comparison;
            }
            String key = (String)this.getItemProperty("key").getValue();
            String otherKey = (String)other.getItemProperty("key").getValue();
            return key.compareTo(otherKey);
        }
    }
}

