/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.location.LocationImpl;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.struts2.StrutsException;
import org.apache.struts2.config.Settings;

class PropertiesSettings
implements Settings {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesSettings.class);
    private LocatableProperties settings;

    public PropertiesSettings(String name) {
        URL settingsUrl = ClassLoaderUtil.getResource((String)(name + ".properties"), this.getClass());
        if (settingsUrl == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(name + ".properties missing", new String[0]);
            }
            this.settings = new LocatableProperties();
            return;
        }
        this.settings = new LocatableProperties((Location)new LocationImpl(null, settingsUrl.toString()));
        InputStream in = null;
        try {
            in = settingsUrl.openStream();
            this.settings.load(in);
        }
        catch (IOException e) {
            throw new StrutsException("Could not load " + name + ".properties:" + e, e);
        }
        finally {
            block13: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException io) {
                        if (!LOG.isWarnEnabled()) break block13;
                        LOG.warn("Unable to close input stream", (Throwable)io, new String[0]);
                    }
                }
            }
        }
    }

    @Override
    public String get(String aName) throws IllegalArgumentException {
        return this.settings.getProperty(aName);
    }

    @Override
    public Location getLocation(String aName) throws IllegalArgumentException {
        return this.settings.getPropertyLocation(aName);
    }

    @Override
    public Iterator list() {
        return this.settings.keySet().iterator();
    }
}

