/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfFont {
    int height;
    int width;
    int escapement;
    int orientation;
    int weight;
    boolean italic;
    boolean underline;
    boolean strikeOut;
    WmfCharset charSet;
    WmfOutPrecision outPrecision;
    WmfClipPrecision clipPrecision;
    WmfFontQuality quality;
    int pitchAndFamily;
    WmfFontFamilyClass family;
    WmfFontPitch pitch;
    String facename;

    public int init(LittleEndianInputStream leis) throws IOException {
        byte b;
        this.height = leis.readShort();
        this.width = leis.readShort();
        this.escapement = leis.readShort();
        this.orientation = leis.readShort();
        this.weight = leis.readShort();
        this.italic = leis.readByte() != 0;
        this.underline = leis.readByte() != 0;
        this.strikeOut = leis.readByte() != 0;
        this.charSet = WmfCharset.valueOf(leis.readUByte());
        this.outPrecision = WmfOutPrecision.valueOf(leis.readUByte());
        this.clipPrecision = WmfClipPrecision.valueOf(leis.readUByte());
        this.quality = WmfFontQuality.valueOf(leis.readUByte());
        this.pitchAndFamily = leis.readUByte();
        byte[] buf = new byte[32];
        int readBytes = 0;
        do {
            if (readBytes == 32) {
                throw new IOException("Font facename can't be determined.");
            }
            int n = readBytes;
            readBytes = (byte)(readBytes + 1);
            buf[n] = b = leis.readByte();
        } while (b != 0 && b != -1 && readBytes <= 32);
        this.facename = new String(buf, 0, readBytes - 1, Charset.forName("ISO-8859-1"));
        return 18 + readBytes;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getEscapement() {
        return this.escapement;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public boolean isStrikeOut() {
        return this.strikeOut;
    }

    public WmfCharset getCharSet() {
        return this.charSet;
    }

    public WmfOutPrecision getOutPrecision() {
        return this.outPrecision;
    }

    public WmfClipPrecision getClipPrecision() {
        return this.clipPrecision;
    }

    public WmfFontQuality getQuality() {
        return this.quality;
    }

    public int getPitchAndFamily() {
        return this.pitchAndFamily;
    }

    public WmfFontFamilyClass getFamily() {
        return WmfFontFamilyClass.valueOf(this.pitchAndFamily & 0xF);
    }

    public WmfFontPitch getPitch() {
        return WmfFontPitch.valueOf(this.pitchAndFamily >>> 6 & 3);
    }

    public String getFacename() {
        return this.facename;
    }

    public static enum WmfFontPitch {
        DEFAULT_PITCH(0),
        FIXED_PITCH(1),
        VARIABLE_PITCH(2);

        int flag;

        private WmfFontPitch(int flag) {
            this.flag = flag;
        }

        static WmfFontPitch valueOf(int flag) {
            for (WmfFontPitch fp : WmfFontPitch.values()) {
                if (fp.flag != flag) continue;
                return fp;
            }
            return null;
        }
    }

    public static enum WmfFontFamilyClass {
        FF_DONTCARE(0),
        FF_ROMAN(1),
        FF_SWISS(2),
        FF_MODERN(3),
        FF_SCRIPT(4),
        FF_DECORATIVE(5);

        int flag;

        private WmfFontFamilyClass(int flag) {
            this.flag = flag;
        }

        static WmfFontFamilyClass valueOf(int flag) {
            for (WmfFontFamilyClass ff : WmfFontFamilyClass.values()) {
                if (ff.flag != flag) continue;
                return ff;
            }
            return null;
        }
    }

    public static enum WmfFontQuality {
        DEFAULT_QUALITY(0),
        DRAFT_QUALITY(1),
        PROOF_QUALITY(2),
        NONANTIALIASED_QUALITY(3),
        ANTIALIASED_QUALITY(4),
        CLEARTYPE_QUALITY(5);

        int flag;

        private WmfFontQuality(int flag) {
            this.flag = flag;
        }

        static WmfFontQuality valueOf(int flag) {
            for (WmfFontQuality fq : WmfFontQuality.values()) {
                if (fq.flag != flag) continue;
                return fq;
            }
            return null;
        }
    }

    public static enum WmfClipPrecision {
        CLIP_DEFAULT_PRECIS(0),
        CLIP_CHARACTER_PRECIS(1),
        CLIP_STROKE_PRECIS(2),
        CLIP_LH_ANGLES(16),
        CLIP_TT_ALWAYS(32),
        CLIP_DFA_DISABLE(64),
        CLIP_EMBEDDED(128);

        int flag;

        private WmfClipPrecision(int flag) {
            this.flag = flag;
        }

        static WmfClipPrecision valueOf(int flag) {
            for (WmfClipPrecision cp : WmfClipPrecision.values()) {
                if (cp.flag != flag) continue;
                return cp;
            }
            return null;
        }
    }

    public static enum WmfOutPrecision {
        OUT_DEFAULT_PRECIS(0),
        OUT_STRING_PRECIS(1),
        OUT_STROKE_PRECIS(3),
        OUT_TT_PRECIS(4),
        OUT_DEVICE_PRECIS(5),
        OUT_RASTER_PRECIS(6),
        OUT_TT_ONLY_PRECIS(7),
        OUT_OUTLINE_PRECIS(8),
        OUT_SCREEN_OUTLINE_PRECIS(9),
        OUT_PS_ONLY_PRECIS(10);

        int flag;

        private WmfOutPrecision(int flag) {
            this.flag = flag;
        }

        static WmfOutPrecision valueOf(int flag) {
            for (WmfOutPrecision op : WmfOutPrecision.values()) {
                if (op.flag != flag) continue;
                return op;
            }
            return null;
        }
    }

    public static enum WmfCharset {
        ANSI_CHARSET(0),
        DEFAULT_CHARSET(1),
        SYMBOL_CHARSET(2),
        MAC_CHARSET(77),
        SHIFTJIS_CHARSET(128),
        HANGUL_CHARSET(129),
        JOHAB_CHARSET(130),
        GB2312_CHARSET(134),
        CHINESEBIG5_CHARSET(136),
        GREEK_CHARSET(161),
        TURKISH_CHARSET(162),
        VIETNAMESE_CHARSET(163),
        HEBREW_CHARSET(177),
        ARABIC_CHARSET(178),
        BALTIC_CHARSET(186),
        RUSSIAN_CHARSET(204),
        THAI_CHARSET(222),
        EASTEUROPE_CHARSET(238),
        OEM_CHARSET(255);

        int flag;

        private WmfCharset(int flag) {
            this.flag = flag;
        }

        static WmfCharset valueOf(int flag) {
            for (WmfCharset cs : WmfCharset.values()) {
                if (cs.flag != flag) continue;
                return cs;
            }
            return null;
        }
    }
}

