/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.output;

import com.fr.base.DynamicNumberList;
import com.fr.general.Background;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.JSONUtils;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.DefaultTemplateCellElement;
import com.fr.stable.ColumnRow;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.web.core.reportcase.WebReportCase;
import com.fr.web.output.AbstractOutlet;
import com.fr.web.output.exception.OutputException;
import com.fr.web.output.json.cell.CellBuildAction;
import com.fr.web.output.json.cell.CellColRowBuildAction;
import com.fr.web.output.json.cell.CellNameHyperlinkGroupBuildAction;
import com.fr.web.output.json.cell.CellStyleBuildAction;
import com.fr.web.output.json.cell.JSONCellOutlet;
import com.fr.write.web.output.json.cell.CellWidgetBuildAction;
import com.fr.write.web.output.json.cell.WriteCellValueBuildAction;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWriteOutlet
extends AbstractOutlet<JSONObject> {
    private JSONCellOutlet cellOutlet = this.createWriteJSONCellOutlet();
    private WebReportCase reportCase;
    private Repository repository;
    private ColumnRow frozenColumnRow;
    private ReportSettingsProvider reportSettings;

    public JSONWriteOutlet(WebReportCase webReportCase, Repository repository, ColumnRow columnRow, ReportSettingsProvider reportSettingsProvider) {
        this.reportCase = webReportCase;
        this.repository = repository;
        this.frozenColumnRow = columnRow;
        this.reportSettings = reportSettingsProvider;
        this.cellOutlet.setRepository(repository);
    }

    public JSONObject out() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("sessionID", (Object)this.repository.getSessionID());
        NodeVisitor nodeVisitor = new NodeVisitor();
        jSONObject.put("content", (Object)this.writeContent(this.reportCase, nodeVisitor));
        if (nodeVisitor != null) {
            jSONObject.put("charts", (Object)nodeVisitor.findsToJSONArray("simplechart"));
            jSONObject.put("needcaches", (Object)nodeVisitor.findsToJSONArray("needcache"));
        }
        if (this.reportSettings != null && this.reportSettings.getBackground() != null) {
            jSONObject.put("background", (Object)this.createBackground());
        }
        return jSONObject;
    }

    private JSONObject writeContent(WebReportCase webReportCase, NodeVisitor nodeVisitor) throws OutputException, JSONException {
        JSONObject jSONObject = new JSONObject();
        this.fillRowHeightAndColWidth(webReportCase, jSONObject);
        this.fillRowAndColCount(webReportCase, jSONObject);
        this.fillFrozenInfo(jSONObject);
        jSONObject.put("cellData", (Object)this.detail(webReportCase, nodeVisitor));
        return jSONObject;
    }

    private void fillFrozenInfo(JSONObject jSONObject) throws JSONException {
        if (this.frozenColumnRow != null) {
            jSONObject.put("frozenColumn", this.frozenColumnRow.getColumn());
            jSONObject.put("frozenRow", this.frozenColumnRow.getRow());
        }
    }

    public JSONObject detail(WebReportCase webReportCase, NodeVisitor nodeVisitor) throws OutputException, JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        int n2 = webReportCase.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject2 = this.rowOutput(webReportCase, i2, nodeVisitor);
            jSONArray.put((Object)jSONObject2);
        }
        jSONObject.put("rows", (Object)jSONArray);
        return jSONObject;
    }

    private void fillRowHeightAndColWidth(WebReportCase webReportCase, JSONObject jSONObject) throws JSONException {
        jSONObject.put("rowHeight", (Object)this.getPixJsonArray(webReportCase.getRowHeightDynamicPixList()));
        jSONObject.put("colWidth", (Object)this.getPixJsonArray(webReportCase.getColumnWidthDynamicPixList()));
    }

    private void fillRowAndColCount(WebReportCase webReportCase, JSONObject jSONObject) throws JSONException {
        jSONObject.put("rowCount", webReportCase.getRowCount());
        jSONObject.put("colCount", webReportCase.getColumnCount());
    }

    private JSONArray getPixJsonArray(DynamicNumberList dynamicNumberList) {
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < dynamicNumberList.size(); ++i2) {
            jSONArray.put(dynamicNumberList.get(i2));
        }
        return jSONArray;
    }

    private JSONObject rowOutput(WebReportCase webReportCase, int n2, NodeVisitor nodeVisitor) throws OutputException, JSONException {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = webReportCase.getRow(n2);
        HashMap<Integer, DefaultTemplateCellElement> hashMap = new HashMap<Integer, DefaultTemplateCellElement>();
        for (int i2 = 0; i2 < webReportCase.getColumnCount(); ++i2) {
            hashMap.put(i2, new DefaultTemplateCellElement(i2, n2, 1, 1, null));
        }
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            for (int i3 = cellElement.getColumn(); i3 < cellElement.getColumn() + cellElement.getColumnSpan(); ++i3) {
                if (!hashMap.containsKey(i3)) continue;
                hashMap.remove(i3);
            }
            jSONArray.put((Object)this.createCellJson(cellElement, webReportCase, n2, nodeVisitor));
        }
        Iterator iterator2 = hashMap.values().iterator();
        while (iterator2.hasNext()) {
            jSONArray.put((Object)this.createCellJson((CellElement)iterator2.next(), webReportCase, n2, nodeVisitor));
        }
        hashMap.clear();
        JSONObject jSONObject = new JSONObject();
        List list = JSONUtils.JSONArrayToList((JSONArray)jSONArray);
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    return ((JSONObject)object).getInt("col") - ((JSONObject)object2).getInt("col");
                }
                catch (JSONException jSONException) {
                    return -1;
                }
            }
        });
        jSONObject.put("row", n2);
        jSONObject.put("cells", (Object)new JSONArray((Collection)list));
        return jSONObject;
    }

    private JSONObject createCellJson(CellElement cellElement, WebReportCase webReportCase, int n2, NodeVisitor nodeVisitor) throws JSONException, OutputException {
        int n3 = webReportCase.getColumnWidth(cellElement.getColumn(), cellElement.getColumnSpan());
        int n4 = webReportCase.getRowPixHeight(cellElement.getRow(), cellElement.getRowSpan());
        Dimension dimension = new Dimension(n3, n4);
        this.cellOutlet.setCellDimension(dimension);
        this.cellOutlet.resetCell(cellElement);
        JSONObject jSONObject = this.cellOutlet.out(nodeVisitor);
        jSONObject.put("row", n2);
        return jSONObject;
    }

    private JSONObject createBackground() throws JSONException {
        int n2 = Math.max(this.reportCase.getColWidth(), 1);
        int n3 = Math.max(this.reportCase.getRowHeight(), 1);
        Background background = this.reportSettings.getBackground();
        return background == null ? JSONObject.EMPTY : background.toJSONObject(this.repository, new Dimension(n2, n3));
    }

    private JSONCellOutlet createWriteJSONCellOutlet() {
        CellBuildAction[] cellBuildActionArray;
        JSONCellOutlet jSONCellOutlet = new JSONCellOutlet();
        for (CellBuildAction cellBuildAction : cellBuildActionArray = new CellBuildAction[]{new CellColRowBuildAction(), new WriteCellValueBuildAction(), new CellStyleBuildAction(), new CellNameHyperlinkGroupBuildAction(), new CellWidgetBuildAction()}) {
            jSONCellOutlet.addCellPutAction(cellBuildAction);
        }
        return jSONCellOutlet;
    }
}

