/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.chart.ChartWebSource;
import com.fr.base.io.IOFile;
import com.fr.data.TableDataSource;
import com.fr.form.FormElementCaseProvider;
import com.fr.form.FormElementCaseResultProvider;
import com.fr.form.main.Form;
import com.fr.form.main.FormIO;
import com.fr.form.ui.ElementCaseEditor;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.general.privilege.PrivilegeConstants;
import com.fr.parser.BlockIntervalLiteral;
import com.fr.privilege.Authentication;
import com.fr.script.Calculator;
import com.fr.script.CalculatorMap;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.IOFileAttrMark;
import com.fr.stable.script.Atom;
import com.fr.stable.script.CalculatorProvider;
import com.fr.web.core.WidgetSessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormSessionIDInfor
extends WidgetSessionIDInfor {
    private static final long serialVersionUID = -4118782575551871808L;
    private Form form2Show;
    private Authentication currentAuthentication;
    private ConcurrentHashMap<String, FormElementCaseResultProvider> resultMap;

    public FormSessionIDInfor(String string, Form form, String string2, Map<String, Object> map, Authentication authentication) {
        this(string, form, string2, map, authentication, null);
    }

    public FormSessionIDInfor(String string, Form form, String string2, Map<String, Object> map, Authentication authentication, String string3) {
        this.remoteAddress = string;
        this.form2Show = form;
        this.bookPath = string2;
        this.browser = string3;
        this.parameterMap4Execute = CalculatorMap.create(map);
        this.currentAuthentication = authentication;
        this.updateTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Form getForm2Show() {
        FormSessionIDInfor formSessionIDInfor = this;
        synchronized (formSessionIDInfor) {
            if (this.form2Show == null) {
                try {
                    this.form2Show = FormIO.readForm(FRContext.getCurrentEnv(), this.bookPath);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage());
                }
            }
            return this.form2Show;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForm2Show(Form form) {
        FormSessionIDInfor formSessionIDInfor = this;
        synchronized (formSessionIDInfor) {
            this.form2Show = form;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Form reloadForm2Show() {
        FormSessionIDInfor formSessionIDInfor = this;
        synchronized (formSessionIDInfor) {
            this.form2Show = null;
            try {
                this.form2Show = FormIO.readForm(FRContext.getCurrentEnv(), this.bookPath);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
            return this.form2Show;
        }
    }

    public TableDataSource getTableDataSource() {
        return this.getForm2Show();
    }

    public String getWebTitle() {
        Object object = this.parameterMap4Execute.get((Object)"WEBTITLE");
        if (object != null) {
            this.webTitle = object.toString();
        }
        if (this.webTitle == null && StringUtils.isNotBlank((String)this.bookPath)) {
            String string = new File(this.bookPath).getName();
            int n2 = -1;
            n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            this.webTitle = string;
        }
        return this.webTitle;
    }

    public void updateTableDataSource() {
        try {
            this.form2Show = FormIO.readForm(FRContext.getCurrentEnv(), this.bookPath);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    public void release() {
        this.clearPageSet();
        FRLogManager.releaseSession();
        Calculator.putThreadSavedNameSpace(null);
    }

    public Widget inspectWidget(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"widgetname");
        return this.getForm2Show().getWidgetByName(string);
    }

    protected Object resolveVariable(Object object, CalculatorProvider calculatorProvider) {
        if (object == PrivilegeConstants.ROLE.CUR_ROLE) {
            return this.currentAuthentication;
        }
        if (ComparatorUtils.equals((Object)object, (Object)"__reportlet__")) {
            return this.bookPath;
        }
        if (object instanceof BlockIntervalLiteral) {
            return this.resolveBlockInterval(object, calculatorProvider);
        }
        return null;
    }

    private Object resolveBlockInterval(Object object, CalculatorProvider calculatorProvider) {
        BlockIntervalLiteral blockIntervalLiteral = (BlockIntervalLiteral)object;
        Atom atom = blockIntervalLiteral.getBlockAtom();
        String string = blockIntervalLiteral.getBlockName();
        if (string.startsWith("$")) {
            string = string.substring(1);
        }
        Widget widget = this.getForm2Show().getWidgetByName(string);
        FormElementCaseProvider formElementCaseProvider = ((ElementCaseEditor)widget).getElementCase();
        formElementCaseProvider.setName(string);
        if (atom.toString().endsWith("Dir")) {
            String string2 = atom.toString().replaceAll("Dir", "");
            return formElementCaseProvider.resolveExpandAttr((WidgetSessionIDInfor)this, string2);
        }
        return formElementCaseProvider.resolveVariable((WidgetSessionIDInfor)this, atom.toColumnRowRange(), calculatorProvider);
    }

    public String getDurationPrefix() {
        String string = null;
        if (this.bookPath != null) {
            String[] stringArray = this.bookPath.split("/");
            string = stringArray[stringArray.length - 1];
        } else {
            string = this.getWebTitle();
        }
        return string;
    }

    public IOFile getForm() {
        return this.getForm2Show();
    }

    public IOFile getIOFile(boolean bl) {
        return bl ? this.reloadForm2Show() : this.getForm2Show();
    }

    public void applySessionIDInforParameters(HttpServletRequest httpServletRequest) {
        Map map = WebUtils.parameters4SessionIDInfor((HttpServletRequest)httpServletRequest);
        this.applySessionIDInforParameters(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applySessionIDInforParameters(Map<String, Object> map) {
        String string = this.sessionID;
        synchronized (string) {
            if (this.parameterMap4Execute == null) {
                this.parameterMap4Execute = CalculatorMap.createEmptyMap();
            }
            this.parameterMap4Execute.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPageSet() {
        String string = this.sessionID;
        synchronized (string) {
            this.form2Show = null;
            this.clearResultElementCase();
            ChartWebSource.clear((String)this.getSessionID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResultElementCase() {
        String string = this.sessionID;
        synchronized (string) {
            if (this.resultMap != null) {
                this.resultMap.clear();
                this.resultMap = null;
            }
        }
    }

    private ConcurrentHashMap<String, FormElementCaseResultProvider> getMap() {
        if (this.resultMap == null) {
            this.resultMap = new ConcurrentHashMap();
        }
        return this.resultMap;
    }

    public FormElementCaseResultProvider getElementCaseResult(String string) {
        if (string == null) {
            return null;
        }
        return this.getMap().get(string.toUpperCase());
    }

    public void putElementCaseResult(String string, FormElementCaseResultProvider formElementCaseResultProvider) {
        if (string == null) {
            return;
        }
        this.getMap().put(string.toUpperCase(), formElementCaseResultProvider);
    }

    public Map<String, Object> updatePara() {
        return new HashMap<String, Object>((Map<String, Object>)this.parameterMap4Execute);
    }

    public void handleUnregister() {
        throw new RegistEditionException(VT4FR.FORM);
    }

    public Map getParameterMap() {
        return this.dealWithParameters(this.getParameterMap4Execute());
    }

    public IOFileAttrMark getIOFileAttrMark(String string) {
        Form form = this.getForm2Show();
        if (form != null) {
            return this.getForm2Show().getAttrMark(string);
        }
        return null;
    }

    private Map dealWithParameters(Map map) {
        CalculatorMap calculatorMap;
        Parameter[] parameterArray;
        Parameter[] parameterArray2 = parameterArray = this.form2Show == null ? null : this.form2Show.getParameters();
        if (map == null) {
            if (parameterArray == null || parameterArray.length == 0) {
                return Collections.EMPTY_MAP;
            }
            calculatorMap = CalculatorMap.create((ParameterProvider[])parameterArray);
        } else {
            calculatorMap = parameterArray == null || parameterArray.length == 0 ? new CalculatorMap() : CalculatorMap.create((ParameterProvider[])parameterArray);
            calculatorMap.putAll(map);
        }
        return calculatorMap;
    }
}

