/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.cache;

import com.fr.general.DeclareRecordType;
import com.fr.general.ExecuteInfo;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.log.LogUtils;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.performance.PerformanceManager;
import com.fr.stable.ActorFactory;
import com.fr.web.cache.ReportCacheIdGenerator;
import com.fr.web.cache.ReportEntry;
import com.fr.web.core.MatchMapContainer;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;

public class ReportCache
extends MatchMapContainer
implements Serializable {
    private String id;
    private ReportEntry reportEntry;
    private transient WeakReference<ResultWorkBook> reference;
    private long createTime = -1L;

    public ReportCache() {
    }

    public ReportCache(ReportEntry reportEntry, Map map) {
        super(map);
        this.reportEntry = reportEntry;
        this.id = ReportCacheIdGenerator.getId();
    }

    public long createTime() {
        return this.createTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultWorkBook getResultWorkBook(TemplateWorkBook templateWorkBook) {
        ReportCache reportCache = this;
        synchronized (reportCache) {
            ResultWorkBook resultWorkBook;
            if (this.reference == null || (resultWorkBook = (ResultWorkBook)this.reference.get()) == null) {
                resultWorkBook = LogUtils.executeAndLogRecord(templateWorkBook, this.reportEntry.getBookPath(), this.paraMap, ActorFactory.getActor("page"));
                this.reference = new WeakReference<ResultWorkBook>(resultWorkBook);
                this.createTime = System.currentTimeMillis();
                return resultWorkBook;
            }
            String string = FRLogger.createParamString((Map)this.paraMap);
            String string2 = FRLogManager.getDeclareSQLContent();
            ExecuteInfo executeInfo = new ExecuteInfo(string, string2);
            PerformanceManager.getRecorder().recordReportFromCache();
            LogUtils.recordAccessNoExecuteInfo(this.reportEntry.getBookPath(), DeclareRecordType.EXECUTE_TYPE_PAGE, executeInfo);
            return resultWorkBook;
        }
    }

    public String getId() {
        return this.id;
    }
}

