/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.attr;

import com.fr.base.BaseXMLUtils;
import com.fr.base.background.ColorBackground;
import com.fr.general.Background;
import com.fr.report.web.Printer;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.WebPage;
import com.fr.report.web.WebView;
import com.fr.report.web.WebWrite;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.ImportJsCssProvider;
import com.fr.xml.SynchronizedFrozenColumnRow;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReportWebAttr
implements XMLWriter,
XMLReadable,
Cloneable,
Serializable,
ImportJsCssProvider {
    private String title = null;
    private Printer printer;
    private WebPage page = null;
    private WebWrite write = null;
    private WebView view = null;
    private List<String> jsImportList = null;
    private List<String> cssImportList = null;
    private Background background = null;
    private long cacheValidateTime = 0L;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setCacheValidateTime(long l2) {
        this.cacheValidateTime = l2;
    }

    public long getCacheValidateTime() {
        return this.cacheValidateTime;
    }

    public WebPage getWebPage() {
        return this.page;
    }

    public void setWebPage(WebPage webPage) {
        this.page = webPage;
    }

    public WebView getWebView() {
        return this.view;
    }

    public void setWebView(WebView webView) {
        this.view = webView;
    }

    public WebWrite getWebWrite() {
        return this.write;
    }

    public void setWebWrite(WebWrite webWrite) {
        this.write = webWrite;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public int getJSImportCount() {
        return this.jsImportList == null ? 0 : this.jsImportList.size();
    }

    public String getJSImport(int n2) {
        return this.jsImportList == null ? null : this.jsImportList.get(n2);
    }

    public void clearJSImportList() {
        if (this.jsImportList != null) {
            this.jsImportList.clear();
        }
    }

    public void addJSImport(String string) {
        if (this.jsImportList == null) {
            this.jsImportList = new ArrayList<String>();
        }
        this.jsImportList.add(string);
    }

    public int getCSSImportCount() {
        return this.cssImportList == null ? 0 : this.cssImportList.size();
    }

    public String getCSSImport(int n2) {
        return this.cssImportList == null ? null : this.cssImportList.get(n2);
    }

    public void clearCSSImportList() {
        if (this.cssImportList != null) {
            this.cssImportList.clear();
        }
    }

    public void addCSSImport(String string) {
        if (this.cssImportList == null) {
            this.cssImportList = new ArrayList<String>();
        }
        this.cssImportList.add(string);
    }

    public String[] getJSImport() {
        if (this.jsImportList == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return this.jsImportList.toArray(new String[this.jsImportList.size()]);
    }

    public String[] getCSSImport() {
        if (this.cssImportList == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return this.cssImportList.toArray(new String[this.cssImportList.size()]);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = null;
        if (xMLableReader.isChildNode()) {
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Title")) {
                string = xMLableReader.getElementValue();
                if (StringUtils.isNotBlank((String)string)) {
                    this.setTitle(string);
                }
            } else if (string2.equals("ServerPrinter")) {
                this.printer = new Printer();
                xMLableReader.readXMLObject((XMLReadable)this.printer);
            } else if (string2.equals("Background")) {
                this.setBackground(BaseXMLUtils.readBackground((XMLableReader)xMLableReader));
            } else if (string2.equals("CSSImport")) {
                string = xMLableReader.getElementValue();
                if (string != null) {
                    this.addCSSImport(string);
                }
            } else if (string2.equals("WriteCSSImport")) {
                string = xMLableReader.getElementValue();
                if (string != null) {
                    this.addCSSImport(string);
                }
            } else if (string2.equals("WidgetCSSImport")) {
                string = xMLableReader.getElementValue();
                if (string != null) {
                    this.addCSSImport(string);
                }
            } else if (string2.equals("JSImport")) {
                string = xMLableReader.getElementValue();
                if (string != null) {
                    this.addJSImport(string);
                }
            } else if (string2.equals("WebPageContent")) {
                this.page = new WebPage();
                xMLableReader.readXMLObject((XMLReadable)this.page);
            } else if (string2.equals("WebViewContent")) {
                this.view = new WebView();
                xMLableReader.readXMLObject((XMLReadable)this.view);
            } else if (string2.equals("WebWriteContent")) {
                this.write = new WebWrite();
                xMLableReader.readXMLObject((XMLReadable)this.write);
            } else if ("CacheValidateTime".equals(string2)) {
                String string3 = xMLableReader.getElementValue();
                this.setCacheValidateTime(string3 == null ? 0L : Long.parseLong(string3));
            } else if (string2.equals("ToolbarManager")) {
                this.readToolBar(xMLableReader);
            } else if (string2.equals("FrozenColumnRow")) {
                this.readFrozenColumnRow(string, xMLableReader);
            }
        }
    }

    private void readToolBar(XMLableReader xMLableReader) {
        ToolBarManager toolBarManager = new ToolBarManager();
        xMLableReader.readXMLObject((XMLReadable)toolBarManager);
        if (this.page == null) {
            this.page = new WebPage();
        }
        this.page.setToolBarManagers(new ToolBarManager[]{toolBarManager});
    }

    private void readFrozenColumnRow(String string, XMLableReader xMLableReader) {
        string = xMLableReader.getAttrAsString("FrozenColumnRow", null);
        if (string != null || (string = xMLableReader.getAttrAsString("frozenColumnRow", null)) != null) {
            ColumnRow columnRow = ColumnRow.valueOf((String)string);
            if (this.write == null) {
                this.write = new WebWrite();
            }
            SynchronizedFrozenColumnRow.putSynchronizedFrozenColumnRow(columnRow);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2;
        xMLPrintWriter.startTAG("ReportWebAttr");
        if (StringUtils.isNotBlank((String)this.getTitle())) {
            xMLPrintWriter.startTAG("Title").textNode(this.getTitle()).end();
        }
        if (this.printer != null) {
            this.printer.writeXML(xMLPrintWriter);
        }
        if (this.page != null) {
            xMLPrintWriter.startTAG("WebPageContent");
            this.page.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.view != null) {
            xMLPrintWriter.startTAG("WebViewContent");
            this.view.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.write != null) {
            xMLPrintWriter.startTAG("WebWriteContent");
            this.write.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        Background background = this.getBackground();
        if (!ColorBackground.getInstance((Color)Color.white).equals((Object)background) && background != null) {
            BaseXMLUtils.writeBackground((XMLPrintWriter)xMLPrintWriter, (Background)background);
        }
        int n3 = this.getCSSImportCount();
        for (n2 = 0; n2 < n3; ++n2) {
            xMLPrintWriter.startTAG("CSSImport").textNode(this.getCSSImport(n2)).end();
        }
        n3 = this.getJSImportCount();
        for (n2 = 0; n2 < n3; ++n2) {
            xMLPrintWriter.startTAG("JSImport").textNode(this.getJSImport(n2)).end();
        }
        if (this.cacheValidateTime != 0L) {
            xMLPrintWriter.startTAG("CacheValidateTime").textNode(String.valueOf(this.cacheValidateTime)).end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ReportWebAttr reportWebAttr = (ReportWebAttr)super.clone();
        if (this.background != null) {
            reportWebAttr.background = (Background)this.background.clone();
        }
        if (this.printer != null) {
            reportWebAttr.printer = (Printer)this.printer.clone();
        }
        if (this.page != null) {
            reportWebAttr.page = (WebPage)((Object)this.page.clone());
        }
        if (this.view != null) {
            reportWebAttr.view = (WebView)((Object)this.view.clone());
        }
        if (this.write != null) {
            reportWebAttr.write = (WebWrite)((Object)this.write.clone());
        }
        if (this.cssImportList != null) {
            reportWebAttr.cssImportList = new ArrayList<String>();
            reportWebAttr.cssImportList.addAll(this.cssImportList);
        }
        if (this.jsImportList != null) {
            reportWebAttr.jsImportList = new ArrayList<String>();
            reportWebAttr.jsImportList.addAll(this.jsImportList);
        }
        return reportWebAttr;
    }
}

