/*
 * Decompiled with CFR 0.152.
 */
package com.fr.view;

import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.ListCondition;
import com.fr.general.data.Condition;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.cell.cellattr.core.group.ConditionGroup;
import com.fr.report.cell.cellattr.core.group.CustomGrouper;
import com.fr.view.AnalysisGroup;

public class StringAnalysisGroup
extends AnalysisGroup {
    private String name;
    private String[] group;
    private boolean isShowLast;
    private boolean isShowLastAsAGroup;
    private String lastGroupName;

    public StringAnalysisGroup(JSONObject jSONObject) throws Exception {
        this.parseJSON(jSONObject);
    }

    public void parseJSON(JSONObject jSONObject) throws JSONException {
        super.parseJSON(jSONObject);
        if (jSONObject.has("name")) {
            this.setName(jSONObject.getString("name"));
        }
        if (jSONObject.has("showLast")) {
            this.isShowLast = jSONObject.getBoolean("showLast");
        }
        if (jSONObject.has("showLastValue")) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("showLastValue");
            if (jSONObject2.has("asAGroup")) {
                this.setShowLastAsAGroup(jSONObject2.getBoolean("asAGroup"));
            }
            if (jSONObject2.has("name")) {
                this.setLastGroupName(jSONObject2.getString("name"));
            }
        }
        this.initGroup((JSONArray)jSONObject.get("group"));
    }

    private void initGroup(JSONArray jSONArray) throws JSONException {
        this.group = new String[jSONArray.length()];
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            this.group[i2] = jSONArray.getJSONObject(i2).getString("text");
        }
    }

    public JSONObject createJSON() throws JSONException {
        JSONObject jSONObject = super.createJSON();
        jSONObject.put("name", (Object)this.getName());
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < this.group.length; ++i2) {
            jSONArray.put((Object)new JSONObject().put("text", (Object)this.group[i2]));
        }
        jSONObject.put("group", (Object)jSONArray);
        jSONObject.put("showLastValueAsAGroup", this.isShowLastAsAGroup());
        jSONObject.put("showLastValueName", (Object)this.getLastGroupName());
        return jSONObject;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String string) {
        this.name = string;
    }

    public boolean isShowLastAsAGroup() {
        return this.isShowLastAsAGroup;
    }

    private void setShowLastAsAGroup(boolean bl) {
        this.isShowLastAsAGroup = bl;
    }

    public String getLastGroupName() {
        return this.lastGroupName;
    }

    private void setLastGroupName(String string) {
        this.lastGroupName = string;
    }

    public CustomGrouper parseGroup(String string) {
        CustomGrouper customGrouper = new CustomGrouper();
        ConditionGroup conditionGroup = new ConditionGroup();
        ListCondition listCondition = new ListCondition();
        for (int i2 = 0; i2 < this.group.length; ++i2) {
            CommonCondition commonCondition = new CommonCondition(string, 0, (Object)this.group[i2]);
            listCondition.addJoinCondition(1, (Condition)commonCondition);
        }
        conditionGroup.setCondition((Condition)listCondition);
        conditionGroup.setDisplay(this.name);
        customGrouper.setConditionGroups(new ConditionGroup[]{conditionGroup});
        customGrouper.setForce(true);
        if (this.isShowLast) {
            if (this.isShowLastAsAGroup) {
                customGrouper.setOther(0);
                customGrouper.setOdisplay(this.lastGroupName);
            } else {
                customGrouper.setOther(2);
            }
        } else {
            customGrouper.setOther(1);
        }
        return customGrouper;
    }

    protected int getType() {
        return 2;
    }
}

