/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core.block;

import com.fr.base.DynamicUnitList;
import com.fr.report.block.Block;
import com.fr.report.block.ResultBlock;
import com.fr.report.cell.ResultCellElement;
import com.fr.report.core.block.BlockSequenceExecutor;
import com.fr.report.core.block.PolyResultWorkSheet;
import com.fr.report.core.sheet.SheetExecutor;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.poly.AbstractResPolyReport;
import com.fr.report.poly.PolyCoreUtils;
import com.fr.report.poly.PolyWorkSheet;
import com.fr.report.poly.TemplateBlock;
import com.fr.report.report.ResultReport;
import com.fr.report.stable.fun.Actor;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UNITConstants;
import com.fr.stable.unit.UnitRectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolyWorkSheetExecutor {
    public List reslist;
    protected PolyWorkSheet tplReport;
    protected PolyResultWorkSheet allInOneSheet = null;
    protected Map parameterMap;

    public PolyWorkSheetExecutor(PolyWorkSheet polyWorkSheet, Map map) {
        this.tplReport = polyWorkSheet;
        this.parameterMap = map;
        this.init(polyWorkSheet);
    }

    void init(PolyWorkSheet polyWorkSheet) {
        int n2 = polyWorkSheet.getBlockCount();
        this.reslist = new ArrayList(polyWorkSheet.getBlockCount());
        int n3 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.reslist.add(null);
        }
    }

    public SheetExecutor createExecutor(TemplateBlock templateBlock, BlockSequenceExecutor blockSequenceExecutor) {
        return templateBlock.createExecutor(this.tplReport, this.parameterMap, blockSequenceExecutor);
    }

    public void addResult(int n2, ResultBlock resultBlock) {
        UnitRectangle unitRectangle = resultBlock.getBounds();
        if (this.isHideBlock(unitRectangle)) {
            this.reslist.set(n2, resultBlock);
            return;
        }
        unitRectangle.width = PolyCoreUtils.isFreezeWidth(resultBlock) ? unitRectangle.width.subtract(UNITConstants.DELTA) : resultBlock.getEffectiveWidth();
        unitRectangle.height = PolyCoreUtils.isFreezeHeight(resultBlock) ? unitRectangle.height.subtract(UNITConstants.DELTA) : resultBlock.getEffectiveHeight();
        this.reslist.set(n2, resultBlock);
    }

    public abstract ResultReport result();

    public abstract Actor getExeType();

    protected abstract PolyResultWorkSheet initResultWorksheet();

    protected abstract ResultCellElement createDefaultCellElement(int var1, int var2);

    protected void initPageSheetInOne(AbstractResPolyReport abstractResPolyReport) {
        ArrayList<UNIT> arrayList = new ArrayList<UNIT>();
        ArrayList<UNIT> arrayList2 = new ArrayList<UNIT>();
        this.analyElementColumnRow(arrayList, arrayList2, abstractResPolyReport);
        this.allInOneSheet = this.initResultWorksheet();
        this.allInOneSheet.copyReportAttr(abstractResPolyReport);
        this.setNewColRowSize(arrayList, arrayList2);
        this.fillBlankCell(arrayList.size(), arrayList2.size());
        int n2 = abstractResPolyReport.getBlockCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ResultBlock resultBlock = (ResultBlock)abstractResPolyReport.getBlock(i2);
            UnitRectangle unitRectangle = resultBlock.getBounds();
            if (this.isHideBlock(unitRectangle)) continue;
            resultBlock.addElemToSheet(arrayList, arrayList2, this.allInOneSheet);
        }
    }

    private void fillBlankCell(int n2, int n3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                ResultCellElement resultCellElement = this.createDefaultCellElement(i3, i2);
                this.allInOneSheet.addCellElement(resultCellElement);
            }
        }
        this.allInOneSheet.setRowMappingArray(new int[0]);
        this.allInOneSheet.setColumnMappingArray(new int[0]);
    }

    private void setNewColRowSize(ArrayList<UNIT> arrayList, ArrayList<UNIT> arrayList2) {
        FU fU;
        FU fU2;
        int n2;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            fU2 = n2 == 0 ? UNIT.ZERO : arrayList.get(n2 - 1);
            fU = arrayList.get(n2).subtract((UNIT)fU2);
            this.allInOneSheet.setRowHeight(n2, (UNIT)fU);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            fU2 = n2 == 0 ? UNIT.ZERO : arrayList2.get(n2 - 1);
            fU = arrayList2.get(n2).subtract((UNIT)fU2);
            this.allInOneSheet.setColumnWidth(n2, (UNIT)fU);
        }
    }

    private void analyElementColumnRow(ArrayList<UNIT> arrayList, ArrayList<UNIT> arrayList2, AbstractResPolyReport abstractResPolyReport) {
        Iterator iterator = abstractResPolyReport.iteratorOfElementCase();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            UnitRectangle unitRectangle = block.getBounds();
            if (this.isHideBlock(unitRectangle)) continue;
            UNIT uNIT = unitRectangle.getY();
            int n2 = ((ElementCase)((Object)block)).getRowCount();
            DynamicUnitList dynamicUnitList = ((ElementCase)((Object)block)).getRowHeightList_DEC();
            this.analyColumnRow(uNIT, arrayList, dynamicUnitList, n2);
            UNIT uNIT2 = unitRectangle.getX();
            int n3 = ((ElementCase)((Object)block)).getColumnCount();
            DynamicUnitList dynamicUnitList2 = ((ElementCase)((Object)block)).getColumnWidthList_DEC();
            this.analyColumnRow(uNIT2, arrayList2, dynamicUnitList2, n3);
        }
        this.sort(arrayList, arrayList2);
    }

    private void sort(ArrayList<UNIT> arrayList, ArrayList<UNIT> arrayList2) {
        Comparator<UNIT> comparator = new Comparator<UNIT>(){

            @Override
            public int compare(UNIT uNIT, UNIT uNIT2) {
                if (uNIT.subtract(uNIT2).equal_zero()) {
                    return 0;
                }
                return uNIT.subtract(uNIT2).more_than_zero() ? 1 : -1;
            }
        };
        Collections.sort(arrayList, comparator);
        Collections.sort(arrayList2, comparator);
    }

    private void analyColumnRow(UNIT uNIT, ArrayList<UNIT> arrayList, DynamicUnitList dynamicUnitList, int n2) {
        arrayList.add(uNIT);
        for (int i2 = 0; i2 < n2; ++i2) {
            FU fU = dynamicUnitList.getRangeValueFromZero(i2 + 1);
            FU fU2 = fU.add(uNIT);
            arrayList.add((UNIT)fU2);
        }
    }

    private boolean isHideBlock(UnitRectangle unitRectangle) {
        return unitRectangle.width.equal_zero() && unitRectangle.height.equal_zero();
    }
}

