/*
 * Decompiled with CFR 0.152.
 */
package com.fr.page.stable;

import com.fr.base.Margin;
import com.fr.base.PaperSize;
import com.fr.general.ComparatorUtils;
import com.fr.page.PaperSettingProvider;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.INCH;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UnitUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.print.PageFormat;
import java.awt.print.Paper;

public class PaperSetting
implements XMLable,
PaperSettingProvider {
    private PaperSize paperSize;
    private Margin margin;
    private int orientation = 0;
    private static final long DTOP = 987552L;
    private static final long DLEFT = 2743200L;
    private static final long DBOTTOM = 987552L;
    private static final long DRIGHT = 2743200L;

    public PaperSetting() {
        this.paperSize = new PaperSize();
        this.margin = new Margin((UNIT)FU.getInstance((long)987552L), (UNIT)FU.getInstance((long)2743200L), (UNIT)FU.getInstance((long)987552L), (UNIT)FU.getInstance((long)2743200L));
    }

    public PaperSetting(PaperSize paperSize, Margin margin, int n2) {
        this.paperSize = paperSize;
        this.margin = margin;
        this.orientation = n2;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public Margin getMargin() {
        return this.margin;
    }

    public void setMargin(Margin margin) {
        this.margin = margin;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n2) {
        this.orientation = n2;
    }

    public boolean equals(Object object) {
        return object instanceof PaperSetting && ComparatorUtils.equals((Object)this.paperSize, (Object)((PaperSetting)object).paperSize) && ComparatorUtils.equals((Object)this.margin, (Object)((PaperSetting)object).margin) && this.orientation == ((PaperSetting)object).orientation;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Margin margin;
        PaperSize paperSize;
        xMLPrintWriter.startTAG("PaperSetting");
        if (this.getOrientation() != 0) {
            xMLPrintWriter.attr("orientation", this.getOrientation());
        }
        if ((paperSize = this.getPaperSize()) != null && !paperSize.equals((Object)PaperSize.PAPERSIZE_A4)) {
            xMLPrintWriter.startTAG("PaperSize").attr("width", paperSize.getWidth().toFU()).attr("height", paperSize.getHeight().toFU()).end();
        }
        if ((margin = this.getMargin()) != null && (margin.getTop().toFU() != 987552L || margin.getLeft().toFU() != 2743200L || margin.getBottom().toFU() != 987552L || margin.getRight().toFU() != 2743200L)) {
            xMLPrintWriter.startTAG("Margin").attr("top", margin.getTop().toFU()).attr("left", margin.getLeft().toFU()).attr("bottom", margin.getBottom().toFU()).attr("right", margin.getRight().toFU()).end();
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.setOrientation(xMLableReader.getAttrAsInt("orientation", 0));
        } else if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("PaperSize".equals(string)) {
                PaperSize paperSize = new PaperSize();
                this.setPaperSize(paperSize);
                if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION()) {
                    paperSize.setWidth(UnitUtils.unit4CompatibleInchDV((String)xMLableReader.getAttrAsString("width", "0")));
                    paperSize.setHeight(UnitUtils.unit4CompatibleInchDV((String)xMLableReader.getAttrAsString("height", "0")));
                } else if (!xMLableReader.getXMLVersion().isAfterUNIT_REFECT_XML_VERSION()) {
                    paperSize.setWidth(UnitUtils.unit4CompatibleMMDV((String)xMLableReader.getAttrAsString("width", "0")));
                    paperSize.setHeight(UnitUtils.unit4CompatibleMMDV((String)xMLableReader.getAttrAsString("height", "0")));
                } else {
                    paperSize.setWidth((UNIT)FU.getInstance((long)xMLableReader.getAttrAsLong("width", 0L)));
                    paperSize.setHeight((UNIT)FU.getInstance((long)xMLableReader.getAttrAsLong("height", 0L)));
                }
            } else if ("Margin".equals(string)) {
                Margin margin = new Margin();
                this.setMargin(margin);
                if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_4_XML_VERSION()) {
                    margin.setTop(UnitUtils.unit4CompatibleInchDV((String)xMLableReader.getAttrAsString("top", "0")));
                    margin.setLeft(UnitUtils.unit4CompatibleInchDV((String)xMLableReader.getAttrAsString("left", "0")));
                    margin.setBottom(UnitUtils.unit4CompatibleInchDV((String)xMLableReader.getAttrAsString("bottom", "0")));
                    margin.setRight(UnitUtils.unit4CompatibleInchDV((String)xMLableReader.getAttrAsString("right", "0")));
                } else if (!xMLableReader.getXMLVersion().isAfterUNIT_REFECT_XML_VERSION()) {
                    margin.setTop(UnitUtils.unit4CompatibleMMDV((String)xMLableReader.getAttrAsString("top", "0")));
                    margin.setLeft(UnitUtils.unit4CompatibleMMDV((String)xMLableReader.getAttrAsString("left", "0")));
                    margin.setBottom(UnitUtils.unit4CompatibleMMDV((String)xMLableReader.getAttrAsString("bottom", "0")));
                    margin.setRight(UnitUtils.unit4CompatibleMMDV((String)xMLableReader.getAttrAsString("right", "0")));
                } else {
                    margin.setTop((UNIT)FU.getInstance((long)xMLableReader.getAttrAsLong("top", 0L)));
                    margin.setLeft((UNIT)FU.getInstance((long)xMLableReader.getAttrAsLong("left", 0L)));
                    margin.setBottom((UNIT)FU.getInstance((long)xMLableReader.getAttrAsLong("bottom", 0L)));
                    margin.setRight((UNIT)FU.getInstance((long)xMLableReader.getAttrAsLong("right", 0L)));
                }
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PaperSetting paperSetting = (PaperSetting)super.clone();
        paperSetting.setPaperSize((PaperSize)this.getPaperSize().clone());
        paperSetting.setMargin((Margin)this.getMargin().clone());
        paperSetting.setOrientation(this.getOrientation());
        return paperSetting;
    }

    public PageFormat modifyPageFormat(PageFormat pageFormat, INCH iNCH, INCH iNCH2) {
        pageFormat = pageFormat == null ? new PageFormat() : (PageFormat)pageFormat.clone();
        int n2 = this.getOrientation();
        double d2 = iNCH.toPixD(72);
        double d3 = iNCH2.toPixD(72);
        Paper paper = pageFormat.getPaper();
        paper.setSize(this.getPaperSize().getWidth().toPixD(72), this.getPaperSize().getHeight().toPixD(72));
        paper.setImageableArea(d2, d3, this.getPaperSize().getWidth().toPixD(72) - 2.0 * d2, this.getPaperSize().getHeight().toPixD(72) - 2.0 * d3);
        pageFormat.setPaper(paper);
        if (n2 == 1) {
            pageFormat.setOrientation(0);
        } else {
            pageFormat.setOrientation(1);
        }
        return pageFormat;
    }
}

