/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.BaseUtils;
import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.headerfooter.ImageHFElement;
import com.fr.base.headerfooter.NumberOfPageHFElement;
import com.fr.base.headerfooter.PageNumberHFElement;
import com.fr.data.PresentationType;
import com.fr.general.Background;
import com.fr.general.FRFont;
import com.fr.general.GeneralUtils;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.io.attr.ReportExportAttr;
import com.fr.io.core.ExporterUtils;
import com.fr.io.exporter.AbstractAppExporter;
import com.fr.io.exporter.WordTableExporter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PageSetCreater;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.core.RichTextConverter;
import com.fr.report.cellcase.CellElementCaseGetter;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportUtils;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.ReportFunctionProcessor;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.monitor.MemoryHelper;
import com.fr.third.com.lowagie.text.BadElementException;
import com.fr.third.com.lowagie.text.Cell;
import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.Document;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Font;
import com.fr.third.com.lowagie.text.FontFactory;
import com.fr.third.com.lowagie.text.HeaderFooter;
import com.fr.third.com.lowagie.text.Image;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.Phrase;
import com.fr.third.com.lowagie.text.Row;
import com.fr.third.com.lowagie.text.Table;
import com.fr.third.com.lowagie.text.rtf.RtfWriter2;
import com.fr.third.com.lowagie.text.rtf.field.RtfPageNumber;
import com.fr.third.com.lowagie.text.rtf.headerfooter.RtfHeaderFooter;
import com.fr.third.com.lowagie.text.rtf.headerfooter.RtfHeaderFooterGroup;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import com.fr.third.com.lowagie.text.rtf.table.RtfBorderGroup;
import com.fr.third.com.lowagie.text.rtf.table.RtfCell;
import com.fr.web.core.ReportRepositoryDeal;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.Format;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

public class WordExporter
extends AbstractAppExporter {
    protected static final int EXPORT_RESOLUTION = 72;
    private static final int DEFAULT_CHARSET = 134;
    private static final float TABLE_WIDTH_PERCENT = 100.0f;
    private static final float HEAD_FOOT_WIDTH = 108.0f;
    private static final float IMAGE_PERCENT = 75.0f;
    private static final int CAL_ROW_HEIGHT_ARG = 20;
    private static final float SPACING_ARG = 0.5f;
    private static final float LEADING_ARG = 1.2f;
    private static final int PADDING_ARG = 20;

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, PageSetCreater pageSetCreater, ReportRepositoryDeal reportRepositoryDeal, int[] nArray) throws Exception {
        this.export(outputStream, resultWorkBook);
    }

    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        PageSetProvider pageSetProvider = resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook)).traverse4Export();
        ReportExportAttr reportExportAttr = resultWorkBook.getReportExportAttr();
        if (this.isExportAsPage(reportExportAttr)) {
            this.export(outputStream, pageSetProvider);
        } else {
            new WordTableExporter().export(outputStream, pageSetProvider);
        }
        pageSetProvider.release();
        FunctionProcessor functionProcessor = ExtraClassManager.getInstance().getFunctionProcessor();
        if (functionProcessor != null) {
            functionProcessor.recordFunction(ReportFunctionProcessor.WORD_EXPORT);
        }
    }

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) throws Exception {
        Document document = new Document();
        RtfWriter2 rtfWriter2 = RtfWriter2.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        for (int i2 = 0; i2 < pageSetProvider.size(); ++i2) {
            ReportPageProvider reportPageProvider = pageSetProvider.getPage(i2);
            if (reportPageProvider == null) {
                return;
            }
            if (i2 != 0) {
                document.newPage();
            }
            this.addCertainPage(reportPageProvider, i2, document);
        }
        if (document != null) {
            document.close();
        }
    }

    public void exportPage(OutputStream outputStream, PageSetProvider pageSetProvider, int[] nArray) throws Exception {
        Document document = new Document();
        RtfWriter2.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        int n2 = 0;
        for (int i2 = 0; i2 < pageSetProvider.size(); ++i2) {
            if (!ArrayUtils.contains((int[])nArray, (int)i2)) continue;
            ReportPageProvider reportPageProvider = pageSetProvider.getPage(i2);
            if (reportPageProvider == null) {
                return;
            }
            if (n2 != 0) {
                document.newPage();
            }
            this.addCertainPage(reportPageProvider, i2, document);
            ++n2;
        }
        document.close();
    }

    private void addCertainPage(ReportPageProvider reportPageProvider, int n2, Document document) throws Exception {
        this.initPaperSetting(reportPageProvider, document, n2);
        ClippedPageProvider clippedPageProvider = ExporterUtils.support(reportPageProvider);
        if (clippedPageProvider == null) {
            return;
        }
        int n3 = clippedPageProvider.getColumnCount();
        int n4 = clippedPageProvider.getRowCount();
        Table table = new Table(Math.max(1, n3), Math.max(1, n4));
        this.initTable(table, reportPageProvider, n3, clippedPageProvider, document);
        this.addToTable(clippedPageProvider, table);
        this.adjustRowHeight(clippedPageProvider, table, document);
        document.add((Element)table);
    }

    private void removeHiddenColRow(ClippedPageProvider clippedPageProvider, Table table) {
        int n2;
        for (n2 = clippedPageProvider.getColumnCount() - 1; n2 >= 0; --n2) {
            if (!clippedPageProvider.getColumnWidth(n2).equal_zero()) continue;
            try {
                table.deleteColumn(n2);
                continue;
            }
            catch (BadElementException badElementException) {
                FRContext.getLogger().error(badElementException.getMessage());
            }
        }
        for (n2 = table.size() - 1; n2 >= clippedPageProvider.getRowCount(); --n2) {
            table.deleteRow(n2);
        }
    }

    private void adjustRowHeight(ClippedPageProvider clippedPageProvider, Table table, Document document) {
        this.removeHiddenColRow(clippedPageProvider, table);
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = clippedPageProvider.getRowCount() - 1;
        for (int i2 = clippedPageProvider.getRowCount() - 1; i2 >= 0; --i2) {
            if (clippedPageProvider.getRowHeight(i2).equal_zero()) {
                table.deleteRow(i2);
                --n2;
                continue;
            }
            Row row = table.getRow(i2);
            float f4 = clippedPageProvider.getRowHeight(i2).toPixI(72);
            row.setHeight((int)(f4 * -1.0f * 20.0f));
            f2 += f4;
            if (!(f4 > f3)) continue;
            f3 = f4;
            n2 = i2;
        }
        float f5 = document.getPageSize().getHeight() - document.topMargin() - document.bottomMargin();
        float f6 = f2 - f5 + 2.0f;
        if (f6 > 0.0f) {
            int n3 = (int)f6;
            if (f6 - (float)n3 > 0.0f) {
                ++n3;
            }
            Row row = table.getRow(n2);
            row.setHeight((int)((f3 - (float)n3) * -1.0f * 20.0f));
        }
    }

    protected int addToTable(ClippedPageProvider clippedPageProvider, Table table) {
        return this.addToTable(clippedPageProvider, table, 0, 0);
    }

    protected int addToTable(ClippedPageProvider clippedPageProvider, Table table, int n2, int n3) {
        try {
            Iterator iterator = clippedPageProvider.cellIterator();
            DynamicUnitList dynamicUnitList = ReportHelper.createColumnWidthList((CellElementCaseGetter)clippedPageProvider);
            DynamicUnitList dynamicUnitList2 = ReportHelper.createRowHeightList((CellElementCaseGetter)clippedPageProvider);
            long l2 = 0L;
            while (iterator.hasNext()) {
                int n4;
                CellElement cellElement;
                CellGUIAttr cellGUIAttr;
                if ((l2++ & 0x3FFL) == 0L) {
                    MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
                }
                if ((cellGUIAttr = (cellElement = (CellElement)iterator.next()).getCellGUIAttr()) != null && !cellGUIAttr.isPrintContent() && !cellGUIAttr.isPrintBackground()) continue;
                int n5 = cellElement.getColumn();
                Cell cell = this.createCellFromCellElement(cellElement, dynamicUnitList, dynamicUnitList2);
                if (cell == null || !dynamicUnitList.getRangeValue(n5, n5 + cellElement.getColumnSpan()).not_equal_zero() || !dynamicUnitList2.getRangeValue(n4, n4 + cellElement.getRowSpan()).not_equal_zero()) continue;
                int n6 = n4 + cellElement.getRowSpan();
                for (n4 = cellElement.getRow(); n4 < n6 && !dynamicUnitList2.get(n4).more_than_zero(); ++n4) {
                }
                table.addCell(cell, n4 + n3, n5);
                n2 = Math.max(n2, n4 + n3 + cellElement.getRowSpan());
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return n2;
    }

    private boolean hasHeaderFooter(PageSetProvider pageSetProvider) {
        ReportPageProvider reportPageProvider;
        int n2 = pageSetProvider.size();
        for (int i2 = 0; i2 < n2 && (reportPageProvider = pageSetProvider.getPage(i2)) != null; ++i2) {
            ReportSettingsProvider reportSettingsProvider = reportPageProvider.getReportSettings();
            if (reportSettingsProvider.getHeaderHeight().equal_zero() && reportSettingsProvider.getHeaderHeight().equal_zero()) continue;
            return true;
        }
        return false;
    }

    private boolean isExportAsPage(ReportExportAttr reportExportAttr) {
        return reportExportAttr == null || reportExportAttr.getWordExportAttr() == null || !reportExportAttr.getWordExportAttr().isExportAsTable();
    }

    protected void initPaperSetting(ReportPageProvider reportPageProvider, Document document, int n2) {
        float f2 = reportPageProvider.getPaperWidth().toPixF(72);
        float f3 = reportPageProvider.getPaperHeight().toPixF(72);
        this.checkIsDifferentPageSize(document, f2, f3, n2);
        this.dealWithHeaderFooter(reportPageProvider, document);
        com.fr.third.com.lowagie.text.Rectangle rectangle = new com.fr.third.com.lowagie.text.Rectangle(f2, f3);
        document.setPageSize(rectangle);
        document.setMargins(reportPageProvider.getMarginLeft().toPixF(72), reportPageProvider.getMarginRight().toPixF(72), reportPageProvider.getMarginTop().toPixF(72), reportPageProvider.getMarginBottom().toPixF(72));
    }

    protected void initTable(Table table, ReportPageProvider reportPageProvider, int n2, ClippedPageProvider clippedPageProvider, Document document) {
        if (n2 == 0) {
            return;
        }
        try {
            table.setBorder(0);
            ReportSettingsProvider reportSettingsProvider = reportPageProvider.getReportSettings();
            Background background = reportSettingsProvider.getBackground();
            Color color = Color.white;
            if (background != null && background instanceof ColorBackground) {
                color = ((ColorBackground)background).getColor();
                table.setBackgroundColor(color);
            }
            table.setAlignment(4);
            table.setDefaultCell(this.createDefaultCell(color));
            table.setAutoFillEmptyCells(true);
            table.setPadding(0.0f);
            table.setSpacing(0.0f);
            float[] fArray = new float[n2];
            float f2 = 0.0f;
            for (int i2 = 0; i2 < n2; ++i2) {
                fArray[i2] = clippedPageProvider.getColumnWidth(i2).toPixF(72);
                f2 += fArray[i2];
            }
            float f3 = document.getPageSize().getWidth() - document.leftMargin() - document.rightMargin();
            table.setWidth(f2 / f3 * 100.0f);
            table.setWidths(fArray);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    protected void dealWithHeaderFooter(ReportPageProvider reportPageProvider, Document document) {
        int n2 = reportPageProvider.getTotalPages();
        ReportSettingsProvider reportSettingsProvider = reportPageProvider.getReportSettings();
        float f2 = reportSettingsProvider.getHeaderHeight().toPixF(72);
        float f3 = reportSettingsProvider.getFooterHeight().toPixF(72);
        try {
            if (f2 > 0.0f) {
                document.setHeader(this.wrapHeaderFooter(reportPageProvider, true, n2));
            }
            if (f3 > 0.0f) {
                document.setFooter(this.wrapHeaderFooter(reportPageProvider, false, n2));
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private RtfHeaderFooter createTableHeaderFooter(ReportPageProvider reportPageProvider, ReportHFProvider reportHFProvider, int n2, boolean bl) {
        return this.createTableHeaderFooter(reportPageProvider, reportHFProvider, n2, true, bl);
    }

    private RtfHeaderFooter createTableHeaderFooter(ReportPageProvider reportPageProvider, ReportHFProvider reportHFProvider, int n2, boolean bl, boolean bl2) {
        try {
            Paragraph paragraph = this.getHFContent(reportHFProvider.getLeftList(), n2, bl, 0);
            Paragraph paragraph2 = this.getHFContent(reportHFProvider.getCenterList(), n2, bl, 1);
            Paragraph paragraph3 = this.getHFContent(reportHFProvider.getRightList(), n2, bl, 2);
            if (this.checkHFShowAsImage(paragraph, paragraph2, paragraph3, reportHFProvider)) {
                Image image = this.createImageFromHFElement(reportHFProvider, reportPageProvider, bl2);
                return new RtfHeaderFooter((Element)image);
            }
            Phrase phrase = new Phrase();
            Table table = new Table(3, 1);
            table.setWidth(108.0f);
            Cell cell = new Cell((Element)paragraph);
            cell.setBorderWidth(0.0f);
            table.addCell(cell);
            cell = new Cell((Element)paragraph2);
            cell.setBorderWidth(0.0f);
            table.addCell(cell);
            cell = new Cell((Element)paragraph3);
            cell.setBorderWidth(0.0f);
            table.addCell(cell);
            phrase.add((Object)table);
            return new RtfHeaderFooter((Element)phrase);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
            return new RtfHeaderFooter((Element)new Phrase());
        }
    }

    private boolean checkHFShowAsImage(Paragraph paragraph, Paragraph paragraph2, Paragraph paragraph3, ReportHFProvider reportHFProvider) {
        return paragraph == null || paragraph2 == null || paragraph3 == null || reportHFProvider.getBackground() != null;
    }

    private Paragraph getHFContent(List list, int n2, boolean bl, int n3) {
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(n3);
        int n4 = list.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            Object e2 = list.get(i2);
            if (e2 instanceof PageNumberHFElement) {
                paragraph.add((Object)new RtfPageNumber());
                if (n4 != 1) continue;
                paragraph.add((Object)" ");
                continue;
            }
            if (e2 instanceof ImageHFElement) {
                if (bl) {
                    return null;
                }
                Image image = this.createRTFImage(((ImageHFElement)e2).getImage());
                paragraph.add((Object)image);
                paragraph.add((Object)new Paragraph(""));
                continue;
            }
            if (e2 instanceof NumberOfPageHFElement) {
                paragraph.add((Object)String.valueOf(n2));
                continue;
            }
            paragraph.add((Object)e2.toString());
        }
        Font font = FontFactory.getFont((String)"SimSun", (float)9.0f);
        paragraph.setFont(font);
        return paragraph;
    }

    private Image createRTFImage(java.awt.Image image) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Image image2 = null;
        try {
            ImageIO.write((RenderedImage)GraphHelper.createBufferedImageFromImage((java.awt.Image)image), "png", byteArrayOutputStream);
            image2 = Image.getInstance((byte[])byteArrayOutputStream.toByteArray());
            image2.setOriginalType(2);
            image2.scalePercent(75.0f);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return image2;
    }

    private HeaderFooter wrapHeaderFooter(ReportPageProvider reportPageProvider, boolean bl, int n2) {
        boolean bl2;
        RtfHeaderFooterGroup rtfHeaderFooterGroup = new RtfHeaderFooterGroup();
        ReportHFProvider reportHFProvider = bl ? reportPageProvider.getHeader(1) : reportPageProvider.getFooter(1);
        ReportHFProvider reportHFProvider2 = bl ? reportPageProvider.getHeader(3) : reportPageProvider.getFooter(3);
        ReportHFProvider reportHFProvider3 = bl ? reportPageProvider.getHeader(4) : reportPageProvider.getFooter(4);
        ReportHFProvider reportHFProvider4 = bl ? reportPageProvider.getHeader(0) : reportPageProvider.getFooter(0);
        boolean bl3 = reportHFProvider2 != null;
        boolean bl4 = bl2 = reportHFProvider3 != null;
        if (reportHFProvider != null) {
            rtfHeaderFooterGroup.setHeaderFooter(this.createTableHeaderFooter(reportPageProvider, reportHFProvider, n2, bl), 0);
        }
        if (bl3) {
            rtfHeaderFooterGroup.setHeaderFooter(this.createTableHeaderFooter(reportPageProvider, reportHFProvider2, n2, bl), 4);
        }
        if (bl2) {
            rtfHeaderFooterGroup.setHeaderFooter(this.createTableHeaderFooter(reportPageProvider, reportHFProvider3, n2, bl), 2);
        }
        boolean bl5 = bl3 || bl2;
        rtfHeaderFooterGroup.setHeaderFooter(this.createTableHeaderFooter(reportPageProvider, reportHFProvider4, n2, bl5, bl), 1);
        return rtfHeaderFooterGroup;
    }

    private Image createImageFromHFElement(ReportHFProvider reportHFProvider, ReportPageProvider reportPageProvider, boolean bl) throws Exception {
        int n2 = 96;
        ReportSettingsProvider reportSettingsProvider = reportPageProvider.getReportSettings();
        float f2 = reportPageProvider.getPaperWidth().toPixF(n2);
        float f3 = reportPageProvider.getMarginLeft().toPixF(n2);
        float f4 = reportPageProvider.getMarginRight().toPixF(n2);
        float f5 = f2 - f3 - f4;
        float f6 = bl ? reportSettingsProvider.getHeaderHeight().toPixF(n2) : reportSettingsProvider.getFooterHeight().toPixF(n2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, f5, f6);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)((int)f5), (int)((int)f6), (int)2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        GraphHelper.fill((Graphics)graphics2D, (Shape)double_);
        reportHFProvider.paint(graphics2D, (Rectangle2D)double_, (int)((RectangularShape)double_).getWidth(), reportPageProvider.getCurrentPageNumber(), reportPageProvider.getTotalPages(), reportPageProvider.getFirstPage(), false, n2);
        bufferedImage.flush();
        graphics2D.dispose();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        Image image = Image.getInstance((byte[])byteArrayOutputStream.toByteArray());
        image.setOriginalType(2);
        image.scalePercent(75.0f);
        return image;
    }

    private void checkIsDifferentPageSize(Document document, float f2, float f3, int n2) {
        boolean bl;
        if (n2 == 0) {
            return;
        }
        float f4 = document.getPageSize().getWidth();
        float f5 = document.getPageSize().getHeight();
        boolean bl2 = f4 != 0.0f && f4 != f2;
        boolean bl3 = bl = f5 != 0.0f && f5 != f3;
        if (bl2 || bl) {
            FRContext.getLogger().error(Inter.getLocText((String)"FR-Engine-NS_export_wordPageSize"));
        }
    }

    protected Cell createDefaultCell(Color color) throws Exception {
        RtfCell rtfCell = new RtfCell((Element)new Paragraph("", this.frFont2RTFFont(Style.DEFAULT_STYLE.getFRFont())));
        rtfCell.setBackgroundColor(color);
        RtfBorderGroup rtfBorderGroup = new RtfBorderGroup();
        rtfBorderGroup.addBorder(1, 1, 1.0f, color);
        rtfBorderGroup.addBorder(8, 1, 1.0f, color);
        rtfBorderGroup.addBorder(2, 1, 1.0f, color);
        rtfBorderGroup.addBorder(4, 1, 1.0f, color);
        rtfCell.setBorders(rtfBorderGroup);
        return rtfCell;
    }

    protected Cell createCellFromCellElement(CellElement cellElement, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2) throws Exception {
        Style style = cellElement.getStyle();
        Object object = cellElement.getValue();
        CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
        cellGUIAttr = cellGUIAttr == null ? CellGUIAttr.DEFAULT_CELLGUIATTR : cellGUIAttr;
        Paragraph paragraph = new Paragraph();
        int n2 = dynamicUnitList.getRangeValue(cellElement.getColumn(), cellElement.getColumn() + cellElement.getColumnSpan()).toPixI(96);
        int n3 = dynamicUnitList2.getRangeValue(cellElement.getRow(), cellElement.getRow() + cellElement.getRowSpan()).toPixI(96);
        if (!cellGUIAttr.isPrintContent()) {
            object = "";
        } else if (object instanceof Painter) {
            object = this.createImageFromPainter(n2, n3, style, (Painter)object);
        } else {
            object = Utils.resolveOtherValue((Object)object, (boolean)(cellGUIAttr == null ? true : cellGUIAttr.isShowAsImage()), (PresentationType)PresentationType.EXPORT);
            if (cellGUIAttr.isShowAsHTML()) {
                try {
                    paragraph = this.html2Paragraph(GeneralUtils.objectToString((Object)object), style);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage());
                    object = PaintUtils.createHTMLContentBufferedImage(object.toString(), new Rectangle(n2, n3), 1, 1, style);
                }
            } else if (this.checkShowAsImage(cellGUIAttr, style)) {
                object = this.createCellImage(style, object, n2, n3);
            }
        }
        RtfCell rtfCell = this.createRtfCell(object, style, n2, n3, cellGUIAttr.isShowAsHTML(), paragraph);
        this.dealWithRTFCellSpan(rtfCell, cellElement, dynamicUnitList2, cellGUIAttr, style, object);
        return rtfCell;
    }

    private RtfCell createRtfCell(Object object, Style style, int n2, int n3, boolean bl, Paragraph paragraph) throws Exception {
        if (object instanceof java.awt.Image) {
            return new RtfCell((Element)this.createRTFImageCellValue(object, style, n2, n3));
        }
        if (bl) {
            paragraph.setLeading(0.0f);
            return new RtfCell((Element)paragraph);
        }
        paragraph = new Paragraph(this.getCellText(object, style), this.frFont2RTFFont(style.getFRFont()));
        return this.processStringCell(object, style, paragraph);
    }

    private BufferedImage createImageFromPainter(int n2, int n3, Style style, Painter painter) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)n2, (int)n3, (int)2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        painter.paint((Graphics)graphics2D, n2, n3, 96, style);
        graphics2D.dispose();
        return bufferedImage;
    }

    private String getCellText(Object object, Style style) {
        if (object instanceof Formula) {
            object = ((Formula)object).getResult();
        }
        String string = "";
        Format format = style.getFormat();
        string = Style.valueToText((Object)object, (Format)format);
        if (string.indexOf("\\r") != -1 || string.indexOf("\r") != -1) {
            string = string.replaceAll("\r", (string = string.replaceAll("\\\\r", "")).indexOf("\n") == -1 ? "\n" : "");
        }
        return string.replaceAll("\\\\n", "\n");
    }

    private Paragraph html2Paragraph(String string, Style style) {
        Paragraph paragraph = new Paragraph();
        if (StringUtils.isEmpty((String)string)) {
            return paragraph;
        }
        Chunk[] chunkArray = RichTextConverter.html2ChunkArray(string, style);
        int n2 = chunkArray.length;
        if (n2 == 0) {
            throw new UnsupportedOperationException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            paragraph.add((Object)chunkArray[i2]);
        }
        return paragraph;
    }

    private RtfCell processStringCell(Object object, Style style, Paragraph paragraph) throws Exception {
        int n2 = BaseUtils.getAlignment4Horizontal((Style)style, (Object)object);
        if (n2 == 4) {
            paragraph.setIndentationRight((float)(style.getPaddingRight() * 20 / 27));
        } else {
            paragraph.setIndentationLeft((float)(style.getPaddingLeft() * 20 / 27));
        }
        paragraph.setSpacingBefore((float)style.getSpacingBefore() * 0.5f);
        paragraph.setSpacingAfter((float)style.getSpacingAfter() * 0.5f);
        paragraph.setLeading(-(style.getFRFont().getSize2D() * 1.2f + (float)style.getLineSpacing()));
        return new RtfCell((Element)paragraph);
    }

    private void dealWithRTFCellSpan(RtfCell rtfCell, CellElement cellElement, DynamicUnitList dynamicUnitList, CellGUIAttr cellGUIAttr, Style style, Object object) {
        if (rtfCell != null) {
            int n2 = cellElement.getRowSpan();
            for (int i2 = cellElement.getRow(); i2 < cellElement.getRow() + cellElement.getRowSpan(); ++i2) {
                if (!dynamicUnitList.get(i2).equal_zero()) continue;
                --n2;
            }
            rtfCell.setColspan(cellElement.getColumnSpan());
            rtfCell.setRowspan(n2);
            this.applyStyleToRtfCell(rtfCell, style, object, cellGUIAttr);
        }
    }

    private boolean checkShowAsImage(CellGUIAttr cellGUIAttr, Style style) {
        boolean bl = style.getBackground() != null && !(style.getBackground() instanceof ColorBackground);
        return cellGUIAttr.isShowAsImage() || style.getVerticalText() == 1 || style.getFRFont().isSubscript() || style.getFRFont().isSuperscript() || style.getFRFont().isStrikethrough() || style.getFRFont().getUnderline() > 1 || style.getRotation() != 0 || style.getTextStyle() != 0 || bl;
    }

    private java.awt.Image createCellImage(Style style, Object object, int n2, int n3) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)n2, (int)n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n4 = style.getFRFont().getUnderline();
        com.fr.third.com.lowagie.text.Rectangle rectangle = new com.fr.third.com.lowagie.text.Rectangle(0.0f, 0.0f, (float)n2, (float)(n3 -= n4));
        if (style.getBackground() != null) {
            Style.paintBackground((Graphics2D)graphics2D, (Style)style, (double)n2, (double)n3);
        }
        Style.paintContent((Graphics2D)graphics2D, (Object)object, (Style)style, (int)n2, (int)n3, (int)96);
        return bufferedImage;
    }

    private Image createRTFImageCellValue(Object object, Style style, int n2, int n3) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        java.awt.Image image = (java.awt.Image)object;
        int n4 = CoreGraphHelper.changeImageLayout4Draw((java.awt.Image)image, (int)style.getImageLayout(), (int)n2, (int)n3);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)n2, (int)n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GraphHelper.paintImage((Graphics)graphics2D, (int)n2, (int)n3, (java.awt.Image)image, (int)n4, (int)style.getHorizontalAlignment(), (int)style.getVerticalAlignment(), (int)-1, (int)-1);
        graphics2D.dispose();
        IOUtils.writeImage((java.awt.Image)bufferedImage, (String)"png", (OutputStream)byteArrayOutputStream);
        Image image2 = Image.getInstance((byte[])byteArrayOutputStream.toByteArray());
        image2.scaleAbsolute((float)n2 * 72.0f / 96.0f, (float)n3 * 72.0f / 96.0f);
        return image2;
    }

    private void applyStyleToRtfCell(RtfCell rtfCell, Style style, Object object, CellGUIAttr cellGUIAttr) {
        this.applyAlignmentToRTF(style, object, rtfCell);
        Background background = style.getBackground();
        Color color = Color.WHITE;
        if (background instanceof ColorBackground) {
            if (cellGUIAttr.isPrintBackground()) {
                rtfCell.setBackgroundColor(((ColorBackground)background).getColor());
            }
            color = ((ColorBackground)background).getColor();
        }
        this.applyBorderToRTF(color, style, rtfCell);
    }

    private void applyAlignmentToRTF(Style style, Object object, RtfCell rtfCell) {
        int n2 = BaseUtils.getAlignment4Horizontal((Style)style, (Object)object);
        if (n2 == 2) {
            rtfCell.setHorizontalAlignment(0);
        } else if (n2 == 0) {
            rtfCell.setHorizontalAlignment(1);
        } else if (n2 == 4) {
            rtfCell.setHorizontalAlignment(2);
        }
        int n3 = style.getVerticalAlignment();
        if (n3 == 1) {
            rtfCell.setVerticalAlignment(4);
        } else if (n2 == 0) {
            rtfCell.setVerticalAlignment(5);
        } else if (n2 == 3) {
            rtfCell.setVerticalAlignment(6);
        }
    }

    private void applyBorderToRTF(Color color, Style style, RtfCell rtfCell) {
        RtfBorderGroup rtfBorderGroup = new RtfBorderGroup();
        if (style.getBorderTop() != 0) {
            rtfBorderGroup.addBorder(1, this.frBorder2RTFBorder(style.getBorderTop()), (float)GraphHelper.getLineStyleSize((int)style.getBorderTop()), style.getBorderTopColor());
        } else {
            rtfBorderGroup.addBorder(1, 1, 0.5f, color);
        }
        if (style.getBorderLeft() != 0) {
            rtfBorderGroup.addBorder(4, this.frBorder2RTFBorder(style.getBorderLeft()), (float)GraphHelper.getLineStyleSize((int)style.getBorderLeft()), style.getBorderLeftColor());
        } else {
            rtfBorderGroup.addBorder(4, 1, 0.5f, color);
        }
        if (style.getBorderBottom() != 0) {
            rtfBorderGroup.addBorder(2, this.frBorder2RTFBorder(style.getBorderBottom()), (float)GraphHelper.getLineStyleSize((int)style.getBorderBottom()), style.getBorderBottomColor());
        } else {
            rtfBorderGroup.addBorder(2, 1, 0.5f, color);
        }
        if (style.getBorderRight() != 0) {
            rtfBorderGroup.addBorder(8, this.frBorder2RTFBorder(style.getBorderRight()), (float)GraphHelper.getLineStyleSize((int)style.getBorderRight()), style.getBorderRightColor());
        } else {
            rtfBorderGroup.addBorder(8, 1, 0.5f, color);
        }
        rtfCell.setBorders(rtfBorderGroup);
    }

    private int frBorder2RTFBorder(int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 3: {
                return 5;
            }
            case 14: {
                return 5;
            }
            case 9: {
                return 8;
            }
            case 11: {
                return 9;
            }
            case 7: {
                return 4;
            }
            case 6: {
                return 7;
            }
            case 15: {
                return 7;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 1;
            }
            case 1: {
                return 1;
            }
        }
        return 1;
    }

    private Font frFont2RTFFont(FRFont fRFont) {
        int n2;
        switch (fRFont.getStyle()) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if (fRFont.isShadow()) {
            n2 += 32;
        }
        if (fRFont.isStrikethrough()) {
            n2 += 8;
        }
        if (fRFont.getUnderline() != 0) {
            n2 += 4;
        }
        String string = fRFont.getFamily();
        int n3 = 0;
        try {
            string = new String(string.getBytes("gb18030"), "iso-8859-1");
            n3 = 134;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        RtfFont rtfFont = new RtfFont(string, fRFont.getSize2D(), n2, fRFont.getForeground(), n3);
        return rtfFont;
    }
}

