/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.apache.log4j.Logger;
import org.h2.util.IOUtils;
import org.openwebflow.util.StringStreamSourceEx;
import org.springframework.core.io.ClassPathResource;

public abstract class ModelUtils {
    private static String EMPTY_MODEL_XML = "";
    private static String EMPTY_MODEL_XML_PATH = "empty-model.bpmn";

    public static Model createNewModel(RepositoryService repositoryService, String name, String description) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Model modelData = repositoryService.newModel();
        ObjectNode modelObjectNode = objectMapper.createObjectNode();
        modelObjectNode.put("name", name);
        modelObjectNode.put("revision", 1);
        modelObjectNode.put("description", description);
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setName(name);
        repositoryService.saveModel(modelData);
        repositoryService.addModelEditorSource(modelData.getId(), EMPTY_MODEL_XML.getBytes("utf-8"));
        return modelData;
    }

    public static Deployment deployModel(RepositoryService repositoryService, String modelId) throws IOException {
        Model modelData = repositoryService.getModel(modelId);
        byte[] bpmnBytes = repositoryService.getModelEditorSource(modelId);
        String processName = modelData.getName() + ".bpmn20.xml";
        Deployment deployment = repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, "utf-8")).deploy();
        modelData.setDeploymentId(deployment.getId());
        repositoryService.saveModel(modelData);
        return deployment;
    }

    public static void importModel(RepositoryService repositoryService, File modelFile) throws IOException, XMLStreamException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(modelFile), "utf-8");
        String fileContent = IOUtils.readStringAndClose((Reader)reader, (int)((int)modelFile.length()));
        BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new StringStreamSourceEx(fileContent), false, false);
        String processName = bpmnModel.getMainProcess().getName();
        if (processName == null || processName.isEmpty()) {
            processName = bpmnModel.getMainProcess().getId();
        }
        Model modelData = repositoryService.newModel();
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", processName);
        modelObjectNode.put("revision", 1);
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setName(processName);
        modelData.setKey(modelFile.getName());
        repositoryService.saveModel(modelData);
        repositoryService.addModelEditorSource(modelData.getId(), fileContent.getBytes("utf-8"));
        Logger.getLogger(ModelUtils.class).info((Object)String.format("importing model file: %s", modelFile.getCanonicalPath()));
    }

    static {
        ClassPathResource defaultModelXmlResource = new ClassPathResource(EMPTY_MODEL_XML_PATH);
        try {
            EMPTY_MODEL_XML = IOUtils.readStringAndClose((Reader)new InputStreamReader(defaultModelXmlResource.getInputStream()), (int)((int)defaultModelXmlResource.contentLength()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

