/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.streaming;

import com.fr.third.v2.org.apache.poi.ss.usermodel.Cell;
import com.fr.third.v2.org.apache.poi.ss.usermodel.CellStyle;
import com.fr.third.v2.org.apache.poi.ss.usermodel.FormulaError;
import com.fr.third.v2.org.apache.poi.stable.StableUtil;
import com.fr.third.v2.org.apache.poi.util.TempFile;
import com.fr.third.v2.org.apache.poi.xssf.model.SharedStringsTable;
import com.fr.third.v2.org.apache.poi.xssf.streaming.SXSSFRow;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;

public class SheetDataWriter {
    private final File _fd = this.createTempFile();
    private final Writer _out = this.createWriter(this._fd);
    private int _rownum;
    private int _numberOfFlushedRows;
    private int _lowestIndexOfFlushedRows;
    private int _numberOfCellsOfLastFlushedRow;
    private int _numberLastFlushedRow = -1;
    private SharedStringsTable _sharedStringSource;
    public static long start = 0L;
    public static long cell = 0L;
    public static long end = 0L;
    private String tempHeightString = "14.3";
    private float tempHeightFloat = 14.3f;

    public SheetDataWriter() throws IOException {
    }

    public SheetDataWriter(SharedStringsTable sharedStringsTable) throws IOException {
        this();
        this._sharedStringSource = sharedStringsTable;
    }

    public File createTempFile() throws IOException {
        return TempFile.createTempFile("poi-sxssf-sheet", ".xml");
    }

    public Writer createWriter(File fd) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fd), "UTF-8"));
    }

    public void close() throws IOException {
        this._out.flush();
        this._out.close();
    }

    File getTempFile() {
        return this._fd;
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        File fd = this.getTempFile();
        return new FileInputStream(fd);
    }

    public int getNumberOfFlushedRows() {
        return this._numberOfFlushedRows;
    }

    public int getNumberOfCellsOfLastFlushedRow() {
        return this._numberOfCellsOfLastFlushedRow;
    }

    public int getLowestIndexOfFlushedRows() {
        return this._lowestIndexOfFlushedRows;
    }

    public int getLastFlushedRow() {
        return this._numberLastFlushedRow;
    }

    protected void finalize() throws Throwable {
        this._fd.delete();
        super.finalize();
    }

    public void writeRow(int rownum, SXSSFRow row) throws IOException {
        if (this._numberOfFlushedRows == 0) {
            this._lowestIndexOfFlushedRows = rownum;
        }
        this._numberLastFlushedRow = Math.max(rownum, this._numberLastFlushedRow);
        this._numberOfCellsOfLastFlushedRow = row.getLastCellNum();
        ++this._numberOfFlushedRows;
        int size = this._numberOfCellsOfLastFlushedRow > 0 ? this._numberOfCellsOfLastFlushedRow : 1;
        StringBuilder sb = new StringBuilder(size << 6);
        this.beginRow(sb, rownum, row);
        Iterator<Cell> cells = row.allCellsIterator();
        int columnIndex = 0;
        while (cells.hasNext()) {
            this.writeCell(sb, columnIndex++, cells.next());
        }
        this.endRow(sb);
        this._out.write(sb.toString());
    }

    void beginRow(StringBuilder sb, int rownum, SXSSFRow row) throws IOException {
        sb.append("<row r=\"").append(rownum + 1).append("\"");
        if (row.hasCustomHeight()) {
            String v = null;
            float f = row.getHeightInPoints();
            if (f == this.tempHeightFloat) {
                v = this.tempHeightString;
            } else {
                v = Float.toString(f);
                this.tempHeightFloat = f;
                this.tempHeightString = v;
            }
            sb.append(" customHeight=\"true\"  ht=\"").append(v).append("\"");
        }
        if (row.getZeroHeight()) {
            sb.append(" hidden=\"true\"");
        }
        if (row.isFormatted()) {
            sb.append(" s=\"").append(row.getRowStyleIndex()).append("\" customFormat=\"1\"");
        }
        if (row.getOutlineLevel() != 0) {
            sb.append(" outlineLevel=\"").append(row.getOutlineLevel()).append("\"");
        }
        if (row.getHidden() != null) {
            sb.append(" hidden=\"").append(row.getHidden() != false ? "1" : "0").append("\"");
        }
        if (row.getCollapsed() != null) {
            sb.append(" collapsed=\"").append(row.getCollapsed() != false ? "1" : "0").append("\"");
        }
        sb.append(">\n");
        this._rownum = rownum;
    }

    void endRow(StringBuilder sb) throws IOException {
        sb.append("</row>\n");
    }

    public void writeCell(StringBuilder sb, int columnIndex, Cell cell) throws IOException {
        if (cell == null) {
            return;
        }
        sb.append("<c r=\"");
        sb.append(StableUtil.convertIntToABC(columnIndex + 1));
        sb.append(this._rownum + 1);
        sb.append("\"");
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle.getIndex() != 0) {
            sb.append(" s=\"");
            sb.append(cellStyle.getIndex() & 0xFFFF);
            sb.append("\"");
        }
        int cellType = cell.getCellType();
        switch (cellType) {
            case 3: {
                sb.append(">");
                break;
            }
            case 2: {
                sb.append("><f>");
                this.outputQuotedString(sb, cell.getCellFormula());
                sb.append("</f>");
                switch (cell.getCachedFormulaResultType()) {
                    case 0: {
                        double nval = cell.getNumericCellValue();
                        if (Double.isNaN(nval)) break;
                        sb.append("<v>").append(nval).append("</v>");
                    }
                }
                break;
            }
            case 1: {
                if (this._sharedStringSource != null && cell.isRichText()) {
                    XSSFRichTextString rt = (XSSFRichTextString)cell.getRichStringCellValue();
                    int sRef = this._sharedStringSource.addEntry(rt.getCTRst());
                    sb.append(" t=\"").append(STCellType.S.toString()).append("\">");
                    sb.append("<v>");
                    sb.append(String.valueOf(sRef));
                    sb.append("</v>");
                    break;
                }
                sb.append(" t=\"inlineStr\">");
                sb.append("<is><t");
                if (this.hasLeadingTrailingSpaces(cell.getStringCellValue())) {
                    sb.append(" xml:space=\"preserve\"");
                }
                sb.append(">");
                this.outputQuotedString(sb, cell.getStringCellValue());
                sb.append("</t></is>");
                break;
            }
            case 8: {
                sb.append(" t=\"n\"><v>");
                sb.append(cell.getNumericStringCellValue());
                sb.append("</v>");
                break;
            }
            case 6: {
                sb.append(" t=\"n\">");
                sb.append("<v>").append(cell.getNumericBigDecimalCellValue()).append("</v>");
                break;
            }
            case 7: {
                sb.append(" t=\"n\">");
                sb.append("<v>").append(cell.getNumericBigIntegerCellValue()).append("</v>");
                break;
            }
            case 0: {
                sb.append(" t=\"n\">");
                sb.append("<v>").append(cell.getNumericCellValue()).append("</v>");
                break;
            }
            case 4: {
                sb.append(" t=\"b\">");
                sb.append("<v>").append(cell.getBooleanCellValue() ? "1" : "0").append("</v>");
                break;
            }
            case 5: {
                FormulaError error = FormulaError.forInt(cell.getErrorCellValue());
                sb.append(" t=\"e\">");
                sb.append("<v>").append(error.getString()).append("</v>");
                break;
            }
            default: {
                throw new RuntimeException("Huh?");
            }
        }
        sb.append("</c>");
    }

    boolean hasLeadingTrailingSpaces(String str) {
        if (str != null && str.length() > 0) {
            char firstChar = str.charAt(0);
            char lastChar = str.charAt(str.length() - 1);
            return Character.isWhitespace(firstChar) || Character.isWhitespace(lastChar);
        }
        return false;
    }

    protected void outputQuotedString(StringBuilder sb, String s) throws IOException {
        if (s == null || s.length() == 0) {
            return;
        }
        char[] chars = s.toCharArray();
        int last = 0;
        int length = s.length();
        block9: for (int counter = 0; counter < length; ++counter) {
            char c = chars[counter];
            switch (c) {
                case '<': {
                    if (counter > last) {
                        sb.append(chars, last, counter - last);
                    }
                    last = counter + 1;
                    sb.append("&lt;");
                    continue block9;
                }
                case '>': {
                    if (counter > last) {
                        sb.append(chars, last, counter - last);
                    }
                    last = counter + 1;
                    sb.append("&gt;");
                    continue block9;
                }
                case '&': {
                    if (counter > last) {
                        sb.append(chars, last, counter - last);
                    }
                    last = counter + 1;
                    sb.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    if (counter > last) {
                        sb.append(chars, last, counter - last);
                    }
                    last = counter + 1;
                    sb.append("&quot;");
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    if (counter > last) {
                        sb.append(chars, last, counter - last);
                    }
                    sb.append("&#xa;");
                    last = counter + 1;
                    continue block9;
                }
                case '\t': {
                    if (counter > last) {
                        sb.append(chars, last, counter - last);
                    }
                    sb.append("&#x9;");
                    last = counter + 1;
                    continue block9;
                }
                case '\u00a0': {
                    if (counter > last) {
                        sb.append(chars, last, counter - last);
                    }
                    sb.append("&#xa0;");
                    last = counter + 1;
                    continue block9;
                }
                default: {
                    if (c < ' ' || Character.isLowSurrogate(c) || Character.isHighSurrogate(c) || '\ufffe' <= c && c <= '\uffff') {
                        if (counter > last) {
                            sb.append(chars, last, counter - last);
                        }
                        sb.append('?');
                        last = counter + 1;
                        continue block9;
                    }
                    if (c <= '\u007f') continue block9;
                    if (counter > last) {
                        sb.append(chars, last, counter - last);
                    }
                    last = counter + 1;
                    sb.append("&#");
                    sb.append((int)c);
                    sb.append(";");
                }
            }
        }
        if (last < length) {
            sb.append(chars, last, length - last);
        }
    }

    boolean dispose() throws IOException {
        this._out.close();
        return this._fd.delete();
    }
}

