/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.listeners;

import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.Trigger;
import com.fr.third.org.quartz.TriggerListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FilterAndBroadcastTriggerListener
implements TriggerListener {
    private String name;
    private List listeners;
    private List namePatterns = new LinkedList();
    private List groupPatterns = new LinkedList();

    public FilterAndBroadcastTriggerListener(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Listener name cannot be null!");
        }
        this.name = name;
        this.listeners = new LinkedList();
    }

    public FilterAndBroadcastTriggerListener(String name, List listeners) {
        this(name);
        this.listeners.addAll(listeners);
    }

    public String getName() {
        return this.name;
    }

    public void addListener(TriggerListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(TriggerListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean removeListener(String listenerName) {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            TriggerListener l = (TriggerListener)itr.next();
            if (!l.getName().equals(listenerName)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public List getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void addTriggerNamePattern(String regularExpression) {
        if (regularExpression == null) {
            throw new IllegalArgumentException("Expression cannot be null!");
        }
        this.namePatterns.add(regularExpression);
    }

    public List getTriggerNamePatterns() {
        return this.namePatterns;
    }

    public void addTriggerGroupPattern(String regularExpression) {
        if (regularExpression == null) {
            throw new IllegalArgumentException("Expression cannot be null!");
        }
        this.groupPatterns.add(regularExpression);
    }

    public List getTriggerGroupPatterns() {
        return this.namePatterns;
    }

    protected boolean shouldDispatch(Trigger trigger) {
        String pat;
        if (this.namePatterns.size() == 0 && this.groupPatterns.size() == 0) {
            return true;
        }
        Iterator itr = this.groupPatterns.iterator();
        while (itr.hasNext()) {
            pat = (String)itr.next();
            if (!trigger.getGroup().matches(pat)) continue;
            return true;
        }
        itr = this.namePatterns.iterator();
        while (itr.hasNext()) {
            pat = (String)itr.next();
            if (!trigger.getName().matches(pat)) continue;
            return true;
        }
        return false;
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        if (!this.shouldDispatch(trigger)) {
            return;
        }
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            TriggerListener l = (TriggerListener)itr.next();
            l.triggerFired(trigger, context);
        }
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        if (!this.shouldDispatch(trigger)) {
            return false;
        }
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            TriggerListener l = (TriggerListener)itr.next();
            if (!l.vetoJobExecution(trigger, context)) continue;
            return true;
        }
        return false;
    }

    public void triggerMisfired(Trigger trigger) {
        if (!this.shouldDispatch(trigger)) {
            return;
        }
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            TriggerListener l = (TriggerListener)itr.next();
            l.triggerMisfired(trigger);
        }
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, int triggerInstructionCode) {
        if (!this.shouldDispatch(trigger)) {
            return;
        }
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            TriggerListener l = (TriggerListener)itr.next();
            l.triggerComplete(trigger, context, triggerInstructionCode);
        }
    }
}

