/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class HsqlSocketFactory {
    private static HsqlSocketFactory plainImpl;
    private static HsqlSocketFactory sslImpl;

    protected HsqlSocketFactory() throws Exception {
    }

    public static HsqlSocketFactory getInstance(boolean tls) throws Exception {
        return tls ? HsqlSocketFactory.getSSLImpl() : HsqlSocketFactory.getPlainImpl();
    }

    public void configureSocket(Socket socket) {
    }

    public ServerSocket createServerSocket(int port) throws Exception {
        return new ServerSocket(port);
    }

    public ServerSocket createServerSocket(int port, String address) throws Exception {
        return new ServerSocket(port, 128, InetAddress.getByName(address));
    }

    public Socket createSocket(String host, int port) throws Exception {
        return new Socket(host, port);
    }

    public boolean isSecure() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HsqlSocketFactory getPlainImpl() throws Exception {
        Class clazz = HsqlSocketFactory.class;
        synchronized (clazz) {
            if (plainImpl == null) {
                plainImpl = new HsqlSocketFactory();
            }
        }
        return plainImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HsqlSocketFactory getSSLImpl() throws Exception {
        Class clazz = HsqlSocketFactory.class;
        synchronized (clazz) {
            if (sslImpl == null) {
                sslImpl = HsqlSocketFactory.newFactory("com.fr.third.org.hsqldb.HsqlSocketFactorySecure");
            }
        }
        return sslImpl;
    }

    private static HsqlSocketFactory newFactory(String implClass) throws Exception {
        Object factory;
        Class<?> clazz = Class.forName(implClass);
        Class[] ctorParm = new Class[]{};
        Constructor<?> ctor = clazz.getDeclaredConstructor(ctorParm);
        Object[] ctorArg = new Object[]{};
        try {
            factory = ctor.newInstance(ctorArg);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw t instanceof Exception ? (Exception)t : new RuntimeException(t.toString());
        }
        return (HsqlSocketFactory)factory;
    }
}

