/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.SchemaManager;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.TriggerDef;
import com.fr.third.org.hsqldb.User;
import com.fr.third.org.hsqldb.lib.HashMap;
import com.fr.third.org.hsqldb.lib.HashSet;
import com.fr.third.org.hsqldb.lib.HsqlArrayList;
import com.fr.third.org.hsqldb.lib.Iterator;
import com.fr.third.org.hsqldb.lib.WrapperIterator;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class DINameSpace {
    private Database database;
    private String catalogName;
    private static HashSet builtin = new HashSet();

    public DINameSpace(Database database) throws HsqlException {
        try {
            this.database = database;
            this.catalogName = database.getURI();
        }
        catch (Exception e) {
            Trace.throwerror(40, e.toString());
        }
    }

    Class classForMethodFQN(String fqn) {
        try {
            return this.classForName(fqn.substring(0, fqn.lastIndexOf(46)));
        }
        catch (Exception e) {
            return null;
        }
    }

    Class classForName(String name) throws ClassNotFoundException {
        try {
            if (this.database.classLoader == null) {
                return Class.forName(name);
            }
            if (name != null) {
                return this.database.classLoader.loadClass(name);
            }
            throw new ClassNotFoundException();
        }
        catch (NoClassDefFoundError err) {
            throw new ClassNotFoundException(err.toString());
        }
    }

    Iterator iterateCatalogNames() throws HsqlException {
        return this.isReportCatalogs() ? new WrapperIterator(this.catalogName) : new WrapperIterator();
    }

    String getCatalogName(Object o) {
        return this.isReportCatalogs() ? this.catalogName : null;
    }

    HashMap getInverseAliasMap() {
        HashMap mapIn = this.database.getAliasMap();
        HashMap mapOut = new HashMap();
        Iterator keys = mapIn.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = mapIn.get(key);
            HsqlArrayList keyList = (HsqlArrayList)mapOut.get(value);
            if (keyList == null) {
                keyList = new HsqlArrayList();
                mapOut.put(value, keyList);
            }
            keyList.add(key);
        }
        return mapOut;
    }

    static String getMethodFQN(Method m) {
        return m == null ? null : m.getDeclaringClass().getName() + '.' + m.getName();
    }

    static String getMethodSpecificName(Method m) {
        return m == null ? null : m.getDeclaringClass().getName() + '.' + DINameSpace.getSignature(m);
    }

    static String getSignature(Method method) {
        StringBuffer sb = new StringBuffer();
        Class<?>[] parmTypes = method.getParameterTypes();
        int len = parmTypes.length;
        int last = len - 1;
        sb.append(method.getName()).append('(');
        for (int i = 0; i < len; ++i) {
            sb.append(parmTypes[i].getName());
            if (i >= last) continue;
            sb.append(',');
        }
        sb.append(')');
        String signature = sb.toString();
        return signature;
    }

    String getSchemaName(Object o) {
        SchemaManager cfr_ignored_0 = this.database.schemaManager;
        return "PUBLIC";
    }

    void addBuiltinToSet(HashSet set) {
        set.addAll(builtin.toArray(new String[builtin.size()]));
    }

    boolean isBuiltin(Class clazz) {
        return clazz == null ? false : builtin.contains(clazz.getName());
    }

    boolean isBuiltin(String name) {
        return name == null ? false : builtin.contains(name);
    }

    Iterator iterateRoutineMethods(String className, boolean andAliases) throws HsqlException {
        Method[] methods;
        Class clazz;
        try {
            clazz = this.classForName(className);
        }
        catch (ClassNotFoundException e) {
            return new WrapperIterator();
        }
        HashMap invAliasMap = andAliases ? this.getInverseAliasMap() : null;
        try {
            methods = clazz.getDeclaredMethods();
        }
        catch (Exception e) {
            methods = clazz.getMethods();
        }
        HsqlArrayList methodList = new HsqlArrayList(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int mods = method.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods)) continue;
            Object[] info = new Object[]{method, null, "ROUTINE"};
            if (andAliases) {
                info[1] = invAliasMap.get(DINameSpace.getMethodFQN(method));
            }
            methodList.add(info);
        }
        return methodList.iterator();
    }

    Iterator iterateAccessibleTriggerClassNames(User user) throws HsqlException {
        HashSet classSet = new HashSet();
        Iterator schemas = this.database.schemaManager.userSchemaNameIterator();
        while (schemas.hasNext()) {
            String schema = (String)schemas.next();
            Iterator tables = this.database.schemaManager.tablesIterator(schema);
            while (tables.hasNext()) {
                HsqlArrayList[] triggerLists;
                Table table = (Table)tables.next();
                if (!user.isAccessible(table.getName()) || (triggerLists = table.triggerLists) == null) continue;
                for (int j = 0; j < triggerLists.length; ++j) {
                    HsqlArrayList triggerList = triggerLists[j];
                    if (triggerList == null) continue;
                    int listSize = triggerList.size();
                    for (int k = 0; k < listSize; ++k) {
                        TriggerDef triggerDef = (TriggerDef)triggerList.get(k);
                        if (triggerDef == null || !triggerDef.valid || triggerDef.trigger == null || !user.isAccessible(table.getName(), TriggerDef.indexToRight(k))) continue;
                        classSet.add(triggerDef.trigger.getClass().getName());
                    }
                }
            }
        }
        return classSet.iterator();
    }

    Iterator iterateAllAccessibleMethods(Session session, boolean andAliases) throws HsqlException {
        WrapperIterator out = new WrapperIterator();
        HashSet classNameSet = session.getUser().getGrantedClassNames(true);
        this.addBuiltinToSet(classNameSet);
        Iterator classNames = classNameSet.iterator();
        while (classNames.hasNext()) {
            String className = (String)classNames.next();
            Iterator methods = this.iterateRoutineMethods(className, andAliases);
            out = new WrapperIterator(out, methods);
        }
        return out;
    }

    Session[] listVisibleSessions(Session session) {
        return this.database.sessionManager.getVisibleSessions(session);
    }

    boolean isReportCatalogs() {
        return this.database.getProperties().isPropertyTrue("hsqldb.catalogs");
    }

    static {
        builtin.add("com.fr.third.org.hsqldb.Library");
        builtin.add("java.lang.Math");
    }
}

