/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.aggregates;

import com.fr.third.org.apache.poi.hssf.record.CFHeaderRecord;
import com.fr.third.org.apache.poi.hssf.record.CFRuleRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CFRecordsAggregate
extends Record {
    private static final int MAX_CONDTIONAL_FORMAT_RULES = 3;
    public static final short sid = -2008;
    private static POILogger log = POILogFactory.getLogger(CFRecordsAggregate.class);
    private final CFHeaderRecord header;
    private final List rules;

    private CFRecordsAggregate(CFHeaderRecord pHeader, CFRuleRecord[] pRules) {
        if (pHeader == null) {
            throw new IllegalArgumentException("header must not be null");
        }
        if (pRules == null) {
            throw new IllegalArgumentException("rules must not be null");
        }
        if (pRules.length > 3) {
            throw new IllegalArgumentException("No more than 3 rules may be specified");
        }
        this.header = pHeader;
        this.rules = new ArrayList(3);
        for (int i = 0; i < pRules.length; ++i) {
            this.rules.add(pRules[i]);
        }
    }

    public CFRecordsAggregate(Region[] regions, CFRuleRecord[] rules) {
        this(new CFHeaderRecord(regions), rules);
    }

    public static CFRecordsAggregate createCFAggregate(List recs, int pOffset) {
        int countFound;
        Record rec = (Record)recs.get(pOffset);
        if (rec.getSid() != 432) {
            throw new IllegalStateException("next record sid was " + rec.getSid() + " instead of " + 432 + " as expected");
        }
        CFHeaderRecord header = (CFHeaderRecord)rec;
        int nRules = header.getNumberOfConditionalFormats();
        CFRuleRecord[] rules = new CFRuleRecord[nRules];
        int offset = pOffset;
        for (countFound = 0; countFound < rules.length && ++offset < recs.size() && (rec = (Record)recs.get(offset)) instanceof CFRuleRecord; ++countFound) {
            rules[countFound] = (CFRuleRecord)rec;
        }
        if (countFound < nRules) {
            if (log.check(1)) {
                log.log(1, "Expected  " + nRules + " Conditional Formats, " + "but found " + countFound + " rules");
            }
            header.setNumberOfConditionalFormats(nRules);
            CFRuleRecord[] lessRules = new CFRuleRecord[countFound];
            System.arraycopy(rules, 0, lessRules, 0, countFound);
            rules = lessRules;
        }
        return new CFRecordsAggregate(header, rules);
    }

    public CFRecordsAggregate cloneCFAggregate() {
        CFRuleRecord[] newRecs = new CFRuleRecord[this.rules.size()];
        for (int i = 0; i < newRecs.length; ++i) {
            newRecs[i] = (CFRuleRecord)this.getRule(i).clone();
        }
        return new CFRecordsAggregate((CFHeaderRecord)this.header.clone(), newRecs);
    }

    protected void fillFields(RecordInputStream in) {
    }

    public short getSid() {
        return -2008;
    }

    public int serialize(int offset, byte[] data) {
        int nRules = this.rules.size();
        this.header.setNumberOfConditionalFormats(nRules);
        int pos = offset;
        pos += this.header.serialize(pos, data);
        for (int i = 0; i < nRules; ++i) {
            pos += this.getRule(i).serialize(pos, data);
        }
        return pos - offset;
    }

    protected void validateSid(short id) {
    }

    public CFHeaderRecord getHeader() {
        return this.header;
    }

    private void checkRuleIndex(int idx) {
        if (idx < 0 || idx >= this.rules.size()) {
            throw new IllegalArgumentException("Bad rule record index (" + idx + ") nRules=" + this.rules.size());
        }
    }

    public CFRuleRecord getRule(int idx) {
        this.checkRuleIndex(idx);
        return (CFRuleRecord)this.rules.get(idx);
    }

    public void setRule(int idx, CFRuleRecord r) {
        this.checkRuleIndex(idx);
        this.rules.set(idx, r);
    }

    public void addRule(CFRuleRecord r) {
        if (this.rules.size() >= 3) {
            throw new IllegalStateException("Cannot have more than 3 conditional format rules");
        }
        this.rules.add(r);
        this.header.setNumberOfConditionalFormats(this.rules.size());
    }

    public int getNumberOfRules() {
        return this.rules.size();
    }

    public int getRecordSize() {
        int size = 0;
        if (this.header != null) {
            size += this.header.getRecordSize();
        }
        if (this.rules != null) {
            Iterator irecs = this.rules.iterator();
            while (irecs.hasNext()) {
                size += ((Record)irecs.next()).getRecordSize();
            }
        }
        return size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CF]\n");
        if (this.header != null) {
            buffer.append(this.header.toString());
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            CFRuleRecord cfRule = (CFRuleRecord)this.rules.get(i);
            if (cfRule == null) continue;
            buffer.append(cfRule.toString());
        }
        buffer.append("[/CF]\n");
        return buffer.toString();
    }
}

