/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.writers;

import com.fr.third.javax.xml.namespace.NamespaceContext;
import com.fr.third.javax.xml.namespace.QName;
import com.fr.third.javax.xml.stream.XMLEventReader;
import com.fr.third.javax.xml.stream.XMLEventWriter;
import com.fr.third.javax.xml.stream.XMLStreamException;
import com.fr.third.javax.xml.stream.XMLStreamWriter;
import com.fr.third.javax.xml.stream.events.Attribute;
import com.fr.third.javax.xml.stream.events.Characters;
import com.fr.third.javax.xml.stream.events.Comment;
import com.fr.third.javax.xml.stream.events.DTD;
import com.fr.third.javax.xml.stream.events.EntityReference;
import com.fr.third.javax.xml.stream.events.Namespace;
import com.fr.third.javax.xml.stream.events.ProcessingInstruction;
import com.fr.third.javax.xml.stream.events.StartDocument;
import com.fr.third.javax.xml.stream.events.StartElement;
import com.fr.third.javax.xml.stream.events.XMLEvent;
import java.util.Iterator;

public class XMLEventWriterImpl
implements XMLEventWriter {
    private XMLStreamWriter fStreamWriter;
    private static final boolean DEBUG = false;

    public XMLEventWriterImpl(XMLStreamWriter streamWriter) {
        this.fStreamWriter = streamWriter;
    }

    /*
     * Unable to fully structure code
     */
    public void add(XMLEventReader xMLEventReader) throws XMLStreamException {
        if (xMLEventReader != null) ** GOTO lbl4
        throw new XMLStreamException("Event reader shouldn't be null");
lbl-1000:
        // 1 sources

        {
            this.add(xMLEventReader.nextEvent());
lbl4:
            // 2 sources

            ** while (xMLEventReader.hasNext())
        }
lbl5:
        // 1 sources

    }

    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        int type = xMLEvent.getEventType();
        switch (type) {
            case 11: {
                DTD dtd = (DTD)xMLEvent;
                this.fStreamWriter.writeDTD(dtd.getDocumentTypeDeclaration());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)xMLEvent;
                try {
                    this.fStreamWriter.writeStartDocument(startDocument.getCharacterEncodingScheme(), startDocument.getVersion());
                }
                catch (XMLStreamException e) {
                    this.fStreamWriter.writeStartDocument(startDocument.getVersion());
                }
                break;
            }
            case 1: {
                StartElement startElement = xMLEvent.asStartElement();
                QName qname = startElement.getName();
                this.fStreamWriter.writeStartElement(qname.getPrefix(), qname.getLocalPart(), qname.getNamespaceURI());
                Iterator iterator = startElement.getNamespaces();
                while (iterator.hasNext()) {
                    Namespace namespace = (Namespace)iterator.next();
                    this.fStreamWriter.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                }
                Iterator attributes = startElement.getAttributes();
                while (attributes.hasNext()) {
                    Attribute attribute = (Attribute)attributes.next();
                    QName aqname = attribute.getName();
                    this.fStreamWriter.writeAttribute(aqname.getPrefix(), aqname.getNamespaceURI(), aqname.getLocalPart(), attribute.getValue());
                }
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)xMLEvent;
                this.fStreamWriter.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                break;
            }
            case 5: {
                Comment comment = (Comment)xMLEvent;
                this.fStreamWriter.writeComment(comment.getText());
                break;
            }
            case 3: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)xMLEvent;
                this.fStreamWriter.writeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 4: {
                Characters characters = xMLEvent.asCharacters();
                if (characters.isCData()) {
                    this.fStreamWriter.writeCData(characters.getData());
                    break;
                }
                this.fStreamWriter.writeCharacters(characters.getData());
                break;
            }
            case 9: {
                EntityReference entityReference = (EntityReference)xMLEvent;
                this.fStreamWriter.writeEntityRef(entityReference.getName());
                break;
            }
            case 10: {
                Attribute attribute = (Attribute)xMLEvent;
                QName qname = attribute.getName();
                this.fStreamWriter.writeAttribute(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart(), attribute.getValue());
                break;
            }
            case 12: {
                Characters characters = (Characters)xMLEvent;
                if (!characters.isCData()) break;
                this.fStreamWriter.writeCData(characters.getData());
                break;
            }
            case 2: {
                this.fStreamWriter.writeEndElement();
                break;
            }
            case 8: {
                this.fStreamWriter.writeEndDocument();
            }
        }
    }

    public void close() throws XMLStreamException {
        this.fStreamWriter.close();
    }

    public void flush() throws XMLStreamException {
        this.fStreamWriter.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this.fStreamWriter.getNamespaceContext();
    }

    public String getPrefix(String namespaceURI) throws XMLStreamException {
        return this.fStreamWriter.getPrefix(namespaceURI);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.fStreamWriter.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.fStreamWriter.setNamespaceContext(namespaceContext);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.fStreamWriter.setPrefix(prefix, uri);
    }
}

