/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.element;

import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.IAccessibleElement;
import com.fr.third.fr.pdf.layout.ElementPropertyContainer;
import com.fr.third.fr.pdf.layout.Style;
import com.fr.third.fr.pdf.layout.element.IElement;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElement<T extends IElement>
extends ElementPropertyContainer<T>
implements IElement {
    protected IRenderer nextRenderer;
    protected List<IElement> childElements = new ArrayList<IElement>();
    protected Set<Style> styles;

    @Override
    public IRenderer getRenderer() {
        if (this.nextRenderer != null) {
            IRenderer renderer = this.nextRenderer;
            this.nextRenderer = this.nextRenderer.getNextRenderer();
            return renderer;
        }
        return this.makeNewRenderer();
    }

    @Override
    public void setNextRenderer(IRenderer renderer) {
        this.nextRenderer = renderer;
    }

    @Override
    public IRenderer createRendererSubTree() {
        IRenderer rendererRoot = this.getRenderer();
        for (IElement child : this.childElements) {
            rendererRoot.addChild(child.createRendererSubTree());
        }
        return rendererRoot;
    }

    @Override
    public boolean hasProperty(int property) {
        boolean hasProperty = super.hasProperty(property);
        if (this.styles != null && this.styles.size() > 0 && !hasProperty) {
            for (Style style : this.styles) {
                if (!style.hasProperty(property)) continue;
                hasProperty = true;
                break;
            }
        }
        return hasProperty;
    }

    @Override
    public <T1> T1 getProperty(int property) {
        Object result;
        block1: {
            Style style;
            result = super.getProperty(property);
            if (this.styles == null || this.styles.size() <= 0 || result != null || super.hasProperty(property)) break block1;
            Iterator<Style> iterator = this.styles.iterator();
            while (iterator.hasNext() && (result = (style = iterator.next()).getProperty(property)) == null && !super.hasProperty(property)) {
            }
        }
        return result;
    }

    public T addStyle(Style style) {
        if (this.styles == null) {
            this.styles = new LinkedHashSet<Style>();
        }
        this.styles.add(style);
        return (T)this;
    }

    protected abstract IRenderer makeNewRenderer();

    protected void propagateArtifactRoleToChildElements() {
        for (IElement child : this.childElements) {
            if (!(child instanceof IAccessibleElement)) continue;
            ((IAccessibleElement)((Object)child)).setRole(PdfName.Artifact);
        }
    }

    public boolean isEmpty() {
        return 0 == this.childElements.size();
    }

    public T setPageNumber(int pageNumber) {
        this.setProperty(51, pageNumber);
        return (T)this;
    }
}

