/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.border;

import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.pdf.canvas.PdfCanvas;
import com.fr.third.fr.pdf.layout.border.Border;

public class SolidBorder
extends Border {
    public SolidBorder(float width) {
        super(width);
    }

    public SolidBorder(Color color, float width) {
        super(color, width);
    }

    public int getType() {
        return 0;
    }

    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderWidthBefore, float borderWidthAfter) {
        float x3 = 0.0f;
        float y3 = 0.0f;
        float x4 = 0.0f;
        float y4 = 0.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2);
        switch (borderSide) {
            case TOP: {
                x3 = x2 + borderWidthAfter;
                y3 = y2 + this.width;
                x4 = x1 - borderWidthBefore;
                y4 = y1 + this.width;
                break;
            }
            case RIGHT: {
                x3 = x2 + this.width;
                y3 = y2 - borderWidthAfter;
                x4 = x1 + this.width;
                y4 = y1 + borderWidthBefore;
                break;
            }
            case BOTTOM: {
                x3 = x2 - borderWidthAfter;
                y3 = y2 - this.width;
                x4 = x1 + borderWidthBefore;
                y4 = y1 - this.width;
                break;
            }
            case LEFT: {
                x3 = x2 - this.width;
                y3 = y2 + borderWidthAfter;
                x4 = x1 - this.width;
                y4 = y1 - borderWidthBefore;
            }
        }
        canvas.setFillColor(this.color);
        canvas.moveTo(x1, y1).lineTo(x2, y2).lineTo(x3, y3).lineTo(x4, y4).lineTo(x1, y1).fill();
    }

    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2) {
        canvas.saveState().setStrokeColor(this.color).setLineWidth(this.width).moveTo(x1, y1).lineTo(x2, y2).stroke().restoreState();
    }
}

