/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.annot;

import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.font.PdfFont;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDate;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.annot.PdfAnnotation;
import com.fr.third.fr.pdf.kernel.pdf.xobject.PdfFormXObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfTrapNetworkAnnotation
extends PdfAnnotation {
    private static final long serialVersionUID = 5118904991630303608L;

    public PdfTrapNetworkAnnotation(Rectangle rect, PdfFormXObject appearanceStream) {
        super(rect);
        if (appearanceStream.getProcessColorModel() == null) {
            throw new PdfException("Process color model must be set in appearance stream for Trap Network annotation!");
        }
        this.setNormalAppearance((PdfDictionary)appearanceStream.getPdfObject());
        this.setFlags(68);
    }

    public PdfTrapNetworkAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.TrapNet;
    }

    public PdfTrapNetworkAnnotation setLastModified(PdfDate lastModified) {
        return (PdfTrapNetworkAnnotation)this.put(PdfName.LastModified, (PdfObject)lastModified.getPdfObject());
    }

    public PdfString getLastModified() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.LastModified);
    }

    public PdfTrapNetworkAnnotation setVersion(PdfArray version) {
        return (PdfTrapNetworkAnnotation)this.put(PdfName.Version, version);
    }

    public PdfArray getVersion() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Version);
    }

    public PdfTrapNetworkAnnotation setAnnotStates(PdfArray annotStates) {
        return (PdfTrapNetworkAnnotation)this.put(PdfName.AnnotStates, annotStates);
    }

    public PdfArray getAnnotStates() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.AnnotStates);
    }

    public PdfTrapNetworkAnnotation setFauxedFonts(PdfArray fauxedFonts) {
        return (PdfTrapNetworkAnnotation)this.put(PdfName.FontFauxing, fauxedFonts);
    }

    public PdfTrapNetworkAnnotation setFauxedFonts(List<PdfFont> fauxedFonts) {
        PdfArray arr = new PdfArray();
        for (PdfFont f : fauxedFonts) {
            arr.add((PdfObject)f.getPdfObject());
        }
        return this.setFauxedFonts(arr);
    }

    public PdfArray getFauxedFonts() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.FontFauxing);
    }
}

