/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.io.source.ByteUtils;
import com.fr.third.fr.pdf.kernel.Version;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfOutputStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

class PdfXrefTable
implements Serializable {
    private static final long serialVersionUID = 4171655392492002944L;
    private static final int INITIAL_CAPACITY = 32;
    private static final int MAX_GENERATION = 65535;
    private static final DecimalFormat objectOffsetFormatter = new DecimalFormat("0000000000");
    private static final DecimalFormat objectGenerationFormatter = new DecimalFormat("00000");
    private static final byte[] freeXRefEntry = ByteUtils.getIsoBytes("f \n");
    private static final byte[] inUseXRefEntry = ByteUtils.getIsoBytes("n \n");
    private PdfIndirectReference[] xref;
    private int count = 0;
    private final TreeSet<Integer> freeReferences;

    public PdfXrefTable() {
        this(32);
    }

    public PdfXrefTable(int capacity) {
        if (capacity < 1) {
            capacity = 32;
        }
        this.xref = new PdfIndirectReference[capacity];
        this.freeReferences = new TreeSet();
        this.add(new PdfIndirectReference(null, 0, 65535, 0L).setState((short)2));
    }

    public PdfIndirectReference add(PdfIndirectReference reference) {
        if (reference == null) {
            return null;
        }
        int objNr = reference.getObjNumber();
        this.count = Math.max(this.count, objNr);
        this.ensureCount(objNr);
        this.xref[objNr] = reference;
        return reference;
    }

    public int size() {
        return this.count + 1;
    }

    public PdfIndirectReference get(int index) {
        if (index > this.count) {
            return null;
        }
        return this.xref[index];
    }

    protected PdfIndirectReference createNextIndirectReference(PdfDocument document) {
        PdfIndirectReference reference;
        if (this.freeReferences.size() > 0) {
            int num;
            Integer key = this.freeReferences.first();
            if (key != null) {
                this.freeReferences.remove(key);
            }
            if ((reference = this.xref[num = key.intValue()]) == null) {
                this.xref[num] = reference = new PdfIndirectReference(document, num);
            }
            reference.setOffset(0L);
            reference.clearState((short)2);
        } else {
            reference = new PdfIndirectReference(document, ++this.count);
            this.add(reference);
        }
        return reference.setState((short)8);
    }

    protected void freeReference(PdfIndirectReference reference) {
        reference.setOffset(0L);
        reference.setState((short)2);
        if (!reference.checkState((short)1)) {
            if (reference.refersTo != null) {
                reference.refersTo.setIndirectReference(null).setState((short)64);
                reference.refersTo = null;
            }
            if (reference.getGenNumber() < 65535) {
                this.freeReferences.add(reference.getObjNumber());
                this.xref[reference.getObjNumber()] = null;
            }
        }
    }

    protected void setCapacity(int capacity) {
        if (capacity > this.xref.length) {
            this.extendXref(capacity);
        }
    }

    protected void writeXrefTableAndTrailer(PdfDocument document, PdfObject fileId, PdfObject crypto) throws IOException {
        PdfIndirectReference lastRef;
        PdfWriter writer = document.getWriter();
        if (document.isAppendMode()) {
            for (Integer objNr : this.freeReferences) {
                ++this.xref[objNr.intValue()].genNr;
            }
        } else {
            for (Integer objNr : this.freeReferences) {
                this.xref[objNr.intValue()] = null;
            }
        }
        this.freeReferences.clear();
        for (int i = this.count; i > 0 && ((lastRef = this.xref[i]) == null || lastRef.isFree() && lastRef.getGenNumber() == 0 || !lastRef.checkState((short)1) && (!document.properties.appendMode || lastRef.checkState((short)8))); --i) {
            --this.count;
        }
        ArrayList<Integer> sections = new ArrayList<Integer>();
        int first = 0;
        int len = 1;
        if (document.isAppendMode()) {
            first = 1;
            len = 0;
        }
        for (int i = 1; i < this.size(); ++i) {
            PdfIndirectReference reference = this.xref[i];
            if (reference != null && (document.properties.appendMode && !reference.checkState((short)8) || reference.isFree() && reference.getGenNumber() == 0 || !reference.checkState((short)1))) {
                reference = null;
            }
            if (reference == null) {
                if (len > 0) {
                    sections.add(first);
                    sections.add(len);
                }
                len = 0;
                continue;
            }
            if (len > 0) {
                ++len;
                continue;
            }
            first = i;
            len = 1;
        }
        if (len > 0) {
            sections.add(first);
            sections.add(len);
        }
        if (document.properties.appendMode && sections.size() == 0) {
            this.xref = null;
            return;
        }
        long startxref = writer.getCurrentPos();
        if (writer.isFullCompression()) {
            PdfStream xrefStream = new PdfStream().makeIndirect(document);
            xrefStream.makeIndirect(document);
            xrefStream.put(PdfName.Type, PdfName.XRef);
            xrefStream.put(PdfName.ID, fileId);
            if (crypto != null) {
                xrefStream.put(PdfName.Encrypt, crypto);
            }
            xrefStream.put(PdfName.Size, new PdfNumber(this.size()));
            xrefStream.put(PdfName.W, new PdfArray((List<? extends PdfObject>)new ArrayList<PdfObject>(){
                {
                    this.add(new PdfNumber(1));
                    this.add(new PdfNumber(4));
                    this.add(new PdfNumber(2));
                }
            }));
            xrefStream.put(PdfName.Info, (PdfObject)document.getDocumentInfo().getPdfObject());
            xrefStream.put(PdfName.Root, (PdfObject)document.getCatalog().getPdfObject());
            PdfArray index = new PdfArray();
            for (Integer section : sections) {
                index.add(new PdfNumber(section));
            }
            if (document.properties.appendMode) {
                PdfNumber lastXref = new PdfNumber(document.reader.getLastXref());
                xrefStream.put(PdfName.Prev, lastXref);
            }
            xrefStream.put(PdfName.Index, index);
            PdfXrefTable xref = document.getXref();
            for (int k = 0; k < sections.size(); k += 2) {
                first = (Integer)sections.get(k);
                len = (Integer)sections.get(k + 1);
                for (int i = first; i < first + len; ++i) {
                    PdfIndirectReference reference = xref.get(i);
                    if (reference == null) continue;
                    if (reference.isFree()) {
                        xrefStream.getOutputStream().write(0);
                        xrefStream.getOutputStream().write(PdfXrefTable.intToBytes(0));
                        xrefStream.getOutputStream().write(PdfXrefTable.shortToBytes(reference.getGenNumber()));
                        continue;
                    }
                    if (reference.getObjStreamNumber() == 0) {
                        xrefStream.getOutputStream().write(1);
                        assert (reference.getOffset() < Integer.MAX_VALUE);
                        xrefStream.getOutputStream().write(PdfXrefTable.intToBytes((int)reference.getOffset()));
                        xrefStream.getOutputStream().write(PdfXrefTable.shortToBytes(reference.getGenNumber()));
                        continue;
                    }
                    xrefStream.getOutputStream().write(2);
                    xrefStream.getOutputStream().write(PdfXrefTable.intToBytes(reference.getObjStreamNumber()));
                    xrefStream.getOutputStream().write(PdfXrefTable.shortToBytes(reference.getIndex()));
                }
            }
            xrefStream.flush();
        } else {
            writer.writeString("xref\n");
            PdfXrefTable xref = document.getXref();
            for (int k = 0; k < sections.size(); k += 2) {
                first = (Integer)sections.get(k);
                len = (Integer)sections.get(k + 1);
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)writer.writeInteger(first)).writeSpace()).writeInteger(len)).writeByte((byte)10);
                for (int i = first; i < first + len; ++i) {
                    PdfIndirectReference reference = xref.get(i);
                    ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)writer.writeString(objectOffsetFormatter.format(reference.getOffset()))).writeSpace()).writeString(objectGenerationFormatter.format(reference.getGenNumber()))).writeSpace();
                    if (reference.isFree()) {
                        writer.writeBytes(freeXRefEntry);
                        continue;
                    }
                    writer.writeBytes(inUseXRefEntry);
                }
            }
            PdfDictionary trailer = document.getTrailer();
            trailer.remove(PdfName.W);
            trailer.remove(PdfName.Index);
            trailer.remove(PdfName.Type);
            trailer.remove(PdfName.Length);
            trailer.put(PdfName.Size, new PdfNumber(this.size()));
            trailer.put(PdfName.ID, fileId);
            if (crypto != null) {
                trailer.put(PdfName.Encrypt, crypto);
            }
            writer.writeString("trailer\n");
            if (document.properties.appendMode) {
                PdfNumber lastXref = new PdfNumber(document.reader.getLastXref());
                trailer.put(PdfName.Prev, lastXref);
            }
            writer.write(document.getTrailer());
            writer.write(10);
        }
        PdfXrefTable.writeKeyInfo(writer);
        ((PdfOutputStream)((PdfOutputStream)writer.writeString("startxref\n")).writeLong(startxref)).writeString("\n%%EOF\n");
        this.xref = null;
    }

    void clear() {
        for (int i = 1; i <= this.count; ++i) {
            if (this.xref[i] != null && this.xref[i].isFree()) continue;
            this.xref[i] = null;
        }
        this.count = 1;
    }

    protected static void writeKeyInfo(PdfWriter writer) throws IOException {
        Version version = Version.getInstance();
        String k = version.getKey();
        if (k == null) {
            k = "FR-PDF";
        }
        writer.writeString(String.format("%%%s-%s\n", k, version.getRelease()));
    }

    private void ensureCount(int count) {
        if (count >= this.xref.length) {
            this.extendXref(count << 1);
        }
    }

    private void extendXref(int capacity) {
        PdfIndirectReference[] newXref = new PdfIndirectReference[capacity];
        System.arraycopy(this.xref, 0, newXref, 0, this.xref.length);
        this.xref = newXref;
    }

    private static byte[] shortToBytes(int n) {
        return new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }

    private static byte[] intToBytes(int n) {
        return new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }
}

