/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.geom;

import com.fr.third.fr.pdf.kernel.geom.Matrix;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.geom.Vector;

public class LineSegment {
    private final Vector startPoint;
    private final Vector endPoint;

    public LineSegment(Vector startPoint, Vector endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    public Vector getStartPoint() {
        return this.startPoint;
    }

    public Vector getEndPoint() {
        return this.endPoint;
    }

    public float getLength() {
        return this.endPoint.subtract(this.startPoint).length();
    }

    public Rectangle getBoundingRectange() {
        float x1 = this.getStartPoint().get(0);
        float y1 = this.getStartPoint().get(1);
        float x2 = this.getEndPoint().get(0);
        float y2 = this.getEndPoint().get(1);
        return new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
    }

    public LineSegment transformBy(Matrix m) {
        Vector newStart = this.startPoint.cross(m);
        Vector newEnd = this.endPoint.cross(m);
        return new LineSegment(newStart, newEnd);
    }

    public boolean containsSegment(LineSegment other) {
        return other != null && this.containsPoint(other.startPoint) && this.containsPoint(other.endPoint);
    }

    public boolean containsPoint(Vector point) {
        if (point == null) {
            return false;
        }
        Vector diff1 = point.subtract(this.startPoint);
        if (diff1.get(0) < 0.0f || diff1.get(1) < 0.0f || diff1.get(2) < 0.0f) {
            return false;
        }
        Vector diff2 = this.endPoint.subtract(point);
        return !(diff2.get(0) < 0.0f) && !(diff2.get(1) < 0.0f) && !(diff2.get(2) < 0.0f);
    }
}

