/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.font;

import com.fr.third.fr.pdf.io.font.FontEncoding;
import com.fr.third.fr.pdf.io.font.FontNames;
import com.fr.third.fr.pdf.io.font.TrueTypeFont;
import com.fr.third.fr.pdf.io.font.cmap.CMapToUnicode;
import com.fr.third.fr.pdf.io.font.otf.Glyph;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.font.DocFontEncoding;
import com.fr.third.fr.pdf.kernel.font.DocTrueTypeFont;
import com.fr.third.fr.pdf.kernel.font.FontUtil;
import com.fr.third.fr.pdf.kernel.font.IDocFontProgram;
import com.fr.third.fr.pdf.kernel.font.PdfSimpleFont;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfTrueTypeFont
extends PdfSimpleFont<TrueTypeFont> {
    private static final long serialVersionUID = -8152778382960290571L;

    PdfTrueTypeFont(TrueTypeFont ttf, String encoding, boolean embedded) {
        this.setFontProgram(ttf);
        this.embedded = embedded;
        FontNames fontNames = ttf.getFontNames();
        if (embedded && !fontNames.allowEmbedding()) {
            throw new PdfException("1.cannot.be.embedded.due.to.licensing.restrictions").setMessageParams(fontNames.getFontName());
        }
        if ((encoding == null || encoding.length() == 0) && ttf.isFontSpecific()) {
            encoding = "FontSpecific";
        }
        this.fontEncoding = encoding != null && "FontSpecific".toLowerCase().equals(encoding.toLowerCase()) ? FontEncoding.createFontSpecificEncoding() : FontEncoding.createFontEncoding(encoding);
    }

    PdfTrueTypeFont(PdfDictionary fontDictionary) {
        super(fontDictionary);
        this.newFont = false;
        this.checkFontDictionary(fontDictionary, PdfName.TrueType);
        CMapToUnicode toUni = FontUtil.processToUnicode(fontDictionary.get(PdfName.ToUnicode));
        this.fontEncoding = DocFontEncoding.createDocFontEncoding(fontDictionary.get(PdfName.Encoding), toUni);
        this.fontProgram = DocTrueTypeFont.createFontProgram(fontDictionary, this.fontEncoding);
        this.embedded = ((IDocFontProgram)((Object)this.fontProgram)).getFontFile() != null;
        this.subset = false;
    }

    @Override
    public Glyph getGlyph(int unicode) {
        if (this.fontEncoding.canEncode(unicode)) {
            Glyph notdef;
            Glyph glyph = ((TrueTypeFont)this.getFontProgram()).getGlyph(this.fontEncoding.getUnicodeDifference(unicode));
            if (glyph == null && (glyph = (Glyph)this.notdefGlyphs.get(unicode)) == null && (notdef = ((TrueTypeFont)this.getFontProgram()).getGlyphByCode(0)) != null) {
                glyph = new Glyph(((TrueTypeFont)this.getFontProgram()).getGlyphByCode(0), unicode);
                this.notdefGlyphs.put(unicode, glyph);
            }
            return glyph;
        }
        return null;
    }

    @Override
    public void flush() {
        if (this.newFont) {
            String fontName;
            PdfName subtype;
            if (((TrueTypeFont)this.getFontProgram()).isCff()) {
                subtype = PdfName.Type1;
                fontName = this.fontProgram.getFontNames().getFontName();
            } else {
                subtype = PdfName.TrueType;
                fontName = this.subset ? PdfTrueTypeFont.createSubsetPrefix() + this.fontProgram.getFontNames().getFontName() : this.fontProgram.getFontNames().getFontName();
            }
            this.flushFontData(fontName, subtype);
        }
        super.flush();
    }

    protected void addRangeUni(Set<Integer> longTag) {
        if (!(this.subset || this.subsetRanges == null && ((TrueTypeFont)this.getFontProgram()).getDirectoryOffset() <= 0)) {
            int[] nArray;
            if (this.subsetRanges == null && ((TrueTypeFont)this.getFontProgram()).getDirectoryOffset() > 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 65535;
            } else {
                nArray = PdfTrueTypeFont.compactRanges(this.subsetRanges);
            }
            int[] rg = nArray;
            Map<Integer, int[]> usemap = ((TrueTypeFont)this.getFontProgram()).getActiveCmap();
            assert (usemap != null);
            for (Map.Entry<Integer, int[]> e : usemap.entrySet()) {
                int[] v = e.getValue();
                Integer gi = v[0];
                if (longTag.contains(gi)) continue;
                int c = e.getKey();
                boolean skip = true;
                for (int k = 0; k < rg.length; k += 2) {
                    if (c < rg[k] || c > rg[k + 1]) continue;
                    skip = false;
                    break;
                }
                if (skip) continue;
                longTag.add(gi);
            }
        }
    }

    @Override
    protected void addFontStream(PdfDictionary fontDescriptor) {
        if (this.embedded) {
            PdfStream fontStream;
            PdfName fontFileName;
            if (this.fontProgram instanceof IDocFontProgram) {
                fontFileName = ((IDocFontProgram)((Object)this.fontProgram)).getFontFileName();
                fontStream = ((IDocFontProgram)((Object)this.fontProgram)).getFontFile();
            } else if (((TrueTypeFont)this.getFontProgram()).isCff()) {
                fontFileName = PdfName.FontFile3;
                try {
                    byte[] fontStreamBytes = ((TrueTypeFont)this.getFontProgram()).getFontStreamBytes();
                    fontStream = this.getPdfFontStream(fontStreamBytes, new int[]{fontStreamBytes.length});
                    fontStream.put(PdfName.Subtype, new PdfName("Type1C"));
                }
                catch (PdfException e) {
                    Logger logger = LoggerFactory.getLogger(PdfTrueTypeFont.class);
                    logger.error(e.getMessage());
                    fontStream = null;
                }
            } else {
                fontFileName = PdfName.FontFile2;
                HashSet<Integer> glyphs = new HashSet<Integer>();
                for (int k = 0; k < this.shortTag.length; ++k) {
                    Glyph glyph;
                    if (this.shortTag[k] == 0) continue;
                    int uni = this.fontEncoding.getUnicode(k);
                    Glyph glyph2 = glyph = uni > -1 ? this.fontProgram.getGlyph(uni) : this.fontProgram.getGlyphByCode(k);
                    if (glyph == null) continue;
                    glyphs.add(glyph.getCode());
                }
                this.addRangeUni(glyphs);
                try {
                    byte[] fontStreamBytes = this.subset || ((TrueTypeFont)this.getFontProgram()).getDirectoryOffset() != 0 || this.subsetRanges != null ? ((TrueTypeFont)this.getFontProgram()).getSubset(new HashSet<Integer>(glyphs), this.subset) : ((TrueTypeFont)this.getFontProgram()).getFontStreamBytes();
                    fontStream = this.getPdfFontStream(fontStreamBytes, new int[]{fontStreamBytes.length});
                }
                catch (PdfException e) {
                    Logger logger = LoggerFactory.getLogger(PdfTrueTypeFont.class);
                    logger.error(e.getMessage());
                    fontStream = null;
                }
            }
            if (fontStream != null) {
                fontDescriptor.put(fontFileName, fontStream);
            }
        }
    }
}

