/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.pdf.collection;

import com.fr.third.com.lowagie.text.pdf.PdfArray;
import com.fr.third.com.lowagie.text.pdf.PdfBoolean;
import com.fr.third.com.lowagie.text.pdf.PdfDictionary;
import com.fr.third.com.lowagie.text.pdf.PdfName;
import com.fr.third.com.lowagie.text.pdf.PdfObject;

public class PdfCollectionSort
extends PdfDictionary {
    public PdfCollectionSort(String key) {
        super(PdfName.COLLECTIONSORT);
        this.put(PdfName.S, new PdfName(key));
    }

    public PdfCollectionSort(String[] keys) {
        super(PdfName.COLLECTIONSORT);
        PdfArray array = new PdfArray();
        int i = 0;
        while (i < keys.length) {
            array.add(new PdfName(keys[i]));
            ++i;
        }
        this.put(PdfName.S, array);
    }

    public void setSortOrder(boolean ascending) {
        PdfObject o = this.get(PdfName.S);
        if (!(o instanceof PdfName)) {
            throw new IllegalArgumentException("You have to define a boolean array for this collection sort dictionary.");
        }
        this.put(PdfName.A, new PdfBoolean(ascending));
    }

    public void setSortOrder(boolean[] ascending) {
        PdfArray array;
        PdfObject o = this.get(PdfName.S);
        if (o instanceof PdfArray) {
            if (((PdfArray)o).size() != ascending.length) {
                throw new IllegalArgumentException("The number of booleans in this array doesn't correspond with the number of fields.");
            }
            array = new PdfArray();
            int i = 0;
            while (i < ascending.length) {
                array.add(new PdfBoolean(ascending[i]));
                ++i;
            }
        } else {
            throw new IllegalArgumentException("You need a single boolean for this collection sort dictionary.");
        }
        this.put(PdfName.A, array);
    }
}

