/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.pdf;

import com.fr.third.com.lowagie.text.BadElementException;
import com.fr.third.com.lowagie.text.Image;
import com.fr.third.com.lowagie.text.pdf.codec.CCITTG4Encoder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.image.MemoryImageSource;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Hashtable;

public class BarcodeDatamatrix {
    public static final int DM_NO_ERROR = 0;
    public static final int DM_ERROR_TEXT_TOO_BIG = 1;
    public static final int DM_ERROR_INVALID_SQUARE = 3;
    public static final int DM_ERROR_EXTENSION = 5;
    public static final int DM_AUTO = 0;
    public static final int DM_ASCII = 1;
    public static final int DM_C40 = 2;
    public static final int DM_TEXT = 3;
    public static final int DM_B256 = 4;
    public static final int DM_X21 = 5;
    public static final int DM_EDIFACT = 6;
    public static final int DM_RAW = 7;
    public static final int DM_EXTENSION = 32;
    public static final int DM_TEST = 64;
    private static final DmParams[] dmSizes = new DmParams[]{new DmParams(10, 10, 10, 10, 3, 3, 5), new DmParams(12, 12, 12, 12, 5, 5, 7), new DmParams(8, 18, 8, 18, 5, 5, 7), new DmParams(14, 14, 14, 14, 8, 8, 10), new DmParams(8, 32, 8, 16, 10, 10, 11), new DmParams(16, 16, 16, 16, 12, 12, 12), new DmParams(12, 26, 12, 26, 16, 16, 14), new DmParams(18, 18, 18, 18, 18, 18, 14), new DmParams(20, 20, 20, 20, 22, 22, 18), new DmParams(12, 36, 12, 18, 22, 22, 18), new DmParams(22, 22, 22, 22, 30, 30, 20), new DmParams(16, 36, 16, 18, 32, 32, 24), new DmParams(24, 24, 24, 24, 36, 36, 24), new DmParams(26, 26, 26, 26, 44, 44, 28), new DmParams(16, 48, 16, 24, 49, 49, 28), new DmParams(32, 32, 16, 16, 62, 62, 36), new DmParams(36, 36, 18, 18, 86, 86, 42), new DmParams(40, 40, 20, 20, 114, 114, 48), new DmParams(44, 44, 22, 22, 144, 144, 56), new DmParams(48, 48, 24, 24, 174, 174, 68), new DmParams(52, 52, 26, 26, 204, 102, 42), new DmParams(64, 64, 16, 16, 280, 140, 56), new DmParams(72, 72, 18, 18, 368, 92, 36), new DmParams(80, 80, 20, 20, 456, 114, 48), new DmParams(88, 88, 22, 22, 576, 144, 56), new DmParams(96, 96, 24, 24, 696, 174, 68), new DmParams(104, 104, 26, 26, 816, 136, 56), new DmParams(120, 120, 20, 20, 1050, 175, 68), new DmParams(132, 132, 22, 22, 1304, 163, 62), new DmParams(144, 144, 24, 24, 1558, 156, 62)};
    private static final String x12 = "\r*> 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int extOut;
    private short[] place;
    private byte[] image;
    private int height;
    private int width;
    private int ws;
    private int options;

    private void setBit(int x, int y, int xByte) {
        int n = y * xByte + x / 8;
        this.image[n] = (byte)(this.image[n] | (byte)(128 >> (x & 7)));
    }

    private void draw(byte[] data, int dataSize, DmParams dm) {
        int j;
        int xByte = (dm.width + this.ws * 2 + 7) / 8;
        Arrays.fill(this.image, (byte)0);
        int i = this.ws;
        while (i < dm.height + this.ws) {
            j = this.ws;
            while (j < dm.width + this.ws) {
                this.setBit(j, i, xByte);
                j += 2;
            }
            i += dm.heightSection;
        }
        i = dm.heightSection - 1 + this.ws;
        while (i < dm.height + this.ws) {
            j = this.ws;
            while (j < dm.width + this.ws) {
                this.setBit(j, i, xByte);
                ++j;
            }
            i += dm.heightSection;
        }
        i = this.ws;
        while (i < dm.width + this.ws) {
            j = this.ws;
            while (j < dm.height + this.ws) {
                this.setBit(i, j, xByte);
                ++j;
            }
            i += dm.widthSection;
        }
        i = dm.widthSection - 1 + this.ws;
        while (i < dm.width + this.ws) {
            j = 1 + this.ws;
            while (j < dm.height + this.ws) {
                this.setBit(i, j, xByte);
                j += 2;
            }
            i += dm.widthSection;
        }
        int p = 0;
        int ys = 0;
        while (ys < dm.height) {
            int y = 1;
            while (y < dm.heightSection - 1) {
                int xs = 0;
                while (xs < dm.width) {
                    int x = 1;
                    while (x < dm.widthSection - 1) {
                        short z;
                        if ((z = this.place[p++]) == 1 || z > 1 && (data[z / 8 - 1] & 0xFF & 128 >> z % 8) != 0) {
                            this.setBit(x + xs + this.ws, y + ys + this.ws, xByte);
                        }
                        ++x;
                    }
                    xs += dm.widthSection;
                }
                ++y;
            }
            ys += dm.heightSection;
        }
    }

    private static void makePadding(byte[] data, int position, int count) {
        if (count <= 0) {
            return;
        }
        data[position++] = -127;
        while (--count > 0) {
            int t = 129 + (position + 1) * 149 % 253 + 1;
            if (t > 254) {
                t -= 254;
            }
            data[position++] = (byte)t;
        }
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static int asciiEncodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength) {
        int ptrIn = textOffset;
        int ptrOut = dataOffset;
        textLength += textOffset;
        dataLength += dataOffset;
        while (ptrIn < textLength) {
            int c;
            if (ptrOut >= dataLength) {
                return -1;
            }
            if (BarcodeDatamatrix.isDigit(c = text[ptrIn++] & 0xFF) && ptrIn < textLength && BarcodeDatamatrix.isDigit(text[ptrIn] & 0xFF)) {
                data[ptrOut++] = (byte)((c - 48) * 10 + (text[ptrIn++] & 0xFF) - 48 + 130);
                continue;
            }
            if (c > 127) {
                if (ptrOut + 1 >= dataLength) {
                    return -1;
                }
                data[ptrOut++] = -21;
                data[ptrOut++] = (byte)(c - 128 + 1);
                continue;
            }
            data[ptrOut++] = (byte)(c + 1);
        }
        return ptrOut - dataOffset;
    }

    private static int b256Encodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength) {
        int k;
        if (textLength == 0) {
            return 0;
        }
        if (textLength < 250 && textLength + 2 > dataLength) {
            return -1;
        }
        if (textLength >= 250 && textLength + 3 > dataLength) {
            return -1;
        }
        data[dataOffset] = -25;
        if (textLength < 250) {
            data[dataOffset + 1] = (byte)textLength;
            k = 2;
        } else {
            data[dataOffset + 1] = (byte)(textLength / 250 + 249);
            data[dataOffset + 2] = (byte)(textLength % 250);
            k = 3;
        }
        System.arraycopy(text, textOffset, data, k + dataOffset, textLength);
        k += textLength + dataOffset;
        int j = dataOffset + 1;
        while (j < k) {
            int c = data[j] & 0xFF;
            int prn = 149 * (j + 1) % 255 + 1;
            int tv = c + prn;
            if (tv > 255) {
                tv -= 256;
            }
            data[j] = (byte)tv;
            ++j;
        }
        return k - dataOffset;
    }

    private static int X12Encodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength) {
        int k;
        if (textLength == 0) {
            return 0;
        }
        int ptrIn = 0;
        int ptrOut = 0;
        byte[] x = new byte[textLength];
        int count = 0;
        while (ptrIn < textLength) {
            int i = x12.indexOf((char)text[ptrIn + textOffset]);
            if (i >= 0) {
                x[ptrIn] = (byte)i;
                ++count;
            } else {
                x[ptrIn] = 100;
                if (count >= 6) {
                    count -= count / 3 * 3;
                }
                k = 0;
                while (k < count) {
                    x[ptrIn - k - 1] = 100;
                    ++k;
                }
                count = 0;
            }
            ++ptrIn;
        }
        if (count >= 6) {
            count -= count / 3 * 3;
        }
        k = 0;
        while (k < count) {
            x[ptrIn - k - 1] = 100;
            ++k;
        }
        ptrIn = 0;
        int c = 0;
        while (ptrIn < textLength) {
            c = x[ptrIn];
            if (ptrOut >= dataLength) break;
            if (c < 40) {
                if (ptrIn == 0 || ptrIn > 0 && x[ptrIn - 1] > 40) {
                    data[dataOffset + ptrOut++] = -18;
                }
                if (ptrOut + 2 > dataLength) break;
                int n = 1600 * x[ptrIn] + 40 * x[ptrIn + 1] + x[ptrIn + 2] + 1;
                data[dataOffset + ptrOut++] = (byte)(n / 256);
                data[dataOffset + ptrOut++] = (byte)n;
                ptrIn += 2;
            } else {
                int ci;
                if (ptrIn > 0 && x[ptrIn - 1] < 40) {
                    data[dataOffset + ptrOut++] = -2;
                }
                if ((ci = text[ptrIn + textOffset] & 0xFF) > 127) {
                    data[dataOffset + ptrOut++] = -21;
                    ci -= 128;
                }
                if (ptrOut >= dataLength) break;
                data[dataOffset + ptrOut++] = (byte)(ci + 1);
            }
            ++ptrIn;
        }
        c = 100;
        if (textLength > 0) {
            c = x[textLength - 1];
        }
        if (ptrIn != textLength || c < 40 && ptrOut >= dataLength) {
            return -1;
        }
        if (c < 40) {
            data[dataOffset + ptrOut++] = -2;
        }
        return ptrOut;
    }

    private static int EdifactEncodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength) {
        if (textLength == 0) {
            return 0;
        }
        int ptrIn = 0;
        int ptrOut = 0;
        int edi = 0;
        int pedi = 18;
        boolean ascii = true;
        while (ptrIn < textLength) {
            int c = text[ptrIn + textOffset] & 0xFF;
            if (((c & 0xE0) == 64 || (c & 0xE0) == 32) && c != 95) {
                if (ascii) {
                    if (ptrOut + 1 > dataLength) break;
                    data[dataOffset + ptrOut++] = -16;
                    ascii = false;
                }
                edi |= (c &= 0x3F) << pedi;
                if (pedi == 0) {
                    if (ptrOut + 3 > dataLength) break;
                    data[dataOffset + ptrOut++] = (byte)(edi >> 16);
                    data[dataOffset + ptrOut++] = (byte)(edi >> 8);
                    data[dataOffset + ptrOut++] = (byte)edi;
                    edi = 0;
                    pedi = 18;
                } else {
                    pedi -= 6;
                }
            } else {
                if (!ascii) {
                    edi |= 31 << pedi;
                    if (ptrOut + (3 - pedi / 8) > dataLength) break;
                    data[dataOffset + ptrOut++] = (byte)(edi >> 16);
                    if (pedi <= 12) {
                        data[dataOffset + ptrOut++] = (byte)(edi >> 8);
                    }
                    if (pedi <= 6) {
                        data[dataOffset + ptrOut++] = (byte)edi;
                    }
                    ascii = true;
                    pedi = 18;
                    edi = 0;
                }
                if (c > 127) {
                    if (ptrOut >= dataLength) break;
                    data[dataOffset + ptrOut++] = -21;
                    c -= 128;
                }
                if (ptrOut >= dataLength) break;
                data[dataOffset + ptrOut++] = (byte)(c + 1);
            }
            ++ptrIn;
        }
        if (ptrIn != textLength) {
            return -1;
        }
        if (!ascii) {
            edi |= 31 << pedi;
            if (ptrOut + (3 - pedi / 8) > dataLength) {
                return -1;
            }
            data[dataOffset + ptrOut++] = (byte)(edi >> 16);
            if (pedi <= 12) {
                data[dataOffset + ptrOut++] = (byte)(edi >> 8);
            }
            if (pedi <= 6) {
                data[dataOffset + ptrOut++] = (byte)edi;
            }
        }
        return ptrOut;
    }

    private static int C40OrTextEncodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength, boolean c40) {
        String shift3;
        String basic;
        if (textLength == 0) {
            return 0;
        }
        int ptrIn = 0;
        int ptrOut = 0;
        data[dataOffset + ptrOut++] = c40 ? -26 : -17;
        String shift2 = "!\"#$%&'()*+,-./:;<=>?@[\\]^_";
        if (c40) {
            basic = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            shift3 = "`abcdefghijklmnopqrstuvwxyz{|}~\u007f";
        } else {
            basic = " 0123456789abcdefghijklmnopqrstuvwxyz";
            shift3 = "`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~\u007f";
        }
        int[] enc = new int[textLength * 4 + 10];
        int encPtr = 0;
        int last0 = 0;
        int last1 = 0;
        while (ptrIn < textLength) {
            int idx;
            int c;
            if (encPtr % 3 == 0) {
                last0 = ptrIn;
                last1 = encPtr;
            }
            if ((c = text[textOffset + ptrIn++] & 0xFF) > 127) {
                c -= 128;
                enc[encPtr++] = 1;
                enc[encPtr++] = 30;
            }
            if ((idx = basic.indexOf((char)c)) >= 0) {
                enc[encPtr++] = idx + 3;
                continue;
            }
            if (c < 32) {
                enc[encPtr++] = 0;
                enc[encPtr++] = c;
                continue;
            }
            idx = shift2.indexOf((char)c);
            if (idx >= 0) {
                enc[encPtr++] = 1;
                enc[encPtr++] = idx;
                continue;
            }
            idx = shift3.indexOf((char)c);
            if (idx < 0) continue;
            enc[encPtr++] = 2;
            enc[encPtr++] = idx;
        }
        if (encPtr % 3 != 0) {
            ptrIn = last0;
            encPtr = last1;
        }
        if (encPtr / 3 * 2 > dataLength - 2) {
            return -1;
        }
        int i = 0;
        while (i < encPtr) {
            int a = 1600 * enc[i] + 40 * enc[i + 1] + enc[i + 2] + 1;
            data[dataOffset + ptrOut++] = (byte)(a / 256);
            data[dataOffset + ptrOut++] = (byte)a;
            i += 3;
        }
        data[ptrOut++] = -2;
        i = BarcodeDatamatrix.asciiEncodation(text, ptrIn, textLength - ptrIn, data, ptrOut, dataLength - ptrOut);
        if (i < 0) {
            return i;
        }
        return ptrOut + i;
    }

    private static int getEncodation(byte[] text, int textOffset, int textSize, byte[] data, int dataOffset, int dataSize, int options, boolean firstMatch) {
        int[] e1 = new int[6];
        if (dataSize < 0) {
            return -1;
        }
        int e = -1;
        if ((options &= 7) == 0) {
            e1[0] = BarcodeDatamatrix.asciiEncodation(text, textOffset, textSize, data, dataOffset, dataSize);
            if (firstMatch && e1[0] >= 0) {
                return e1[0];
            }
            e1[1] = BarcodeDatamatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, false);
            if (firstMatch && e1[1] >= 0) {
                return e1[1];
            }
            e1[2] = BarcodeDatamatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, true);
            if (firstMatch && e1[2] >= 0) {
                return e1[2];
            }
            e1[3] = BarcodeDatamatrix.b256Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            if (firstMatch && e1[3] >= 0) {
                return e1[3];
            }
            e1[4] = BarcodeDatamatrix.X12Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            if (firstMatch && e1[4] >= 0) {
                return e1[4];
            }
            e1[5] = BarcodeDatamatrix.EdifactEncodation(text, textOffset, textSize, data, dataOffset, dataSize);
            if (firstMatch && e1[5] >= 0) {
                return e1[5];
            }
            if (e1[0] < 0 && e1[1] < 0 && e1[2] < 0 && e1[3] < 0 && e1[4] < 0 && e1[5] < 0) {
                return -1;
            }
            int j = 0;
            e = 99999;
            int k = 0;
            while (k < 6) {
                if (e1[k] >= 0 && e1[k] < e) {
                    e = e1[k];
                    j = k;
                }
                ++k;
            }
            if (j == 0) {
                e = BarcodeDatamatrix.asciiEncodation(text, textOffset, textSize, data, dataOffset, dataSize);
            } else if (j == 1) {
                e = BarcodeDatamatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, false);
            } else if (j == 2) {
                e = BarcodeDatamatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, true);
            } else if (j == 3) {
                e = BarcodeDatamatrix.b256Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            } else if (j == 4) {
                e = BarcodeDatamatrix.X12Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            }
            return e;
        }
        switch (options) {
            case 1: {
                return BarcodeDatamatrix.asciiEncodation(text, textOffset, textSize, data, dataOffset, dataSize);
            }
            case 2: {
                return BarcodeDatamatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, true);
            }
            case 3: {
                return BarcodeDatamatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, false);
            }
            case 4: {
                return BarcodeDatamatrix.b256Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            }
            case 5: {
                return BarcodeDatamatrix.X12Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            }
            case 6: {
                return BarcodeDatamatrix.EdifactEncodation(text, textOffset, textSize, data, dataOffset, dataSize);
            }
            case 7: {
                if (textSize > dataSize) {
                    return -1;
                }
                System.arraycopy(text, textOffset, data, dataOffset, textSize);
                return textSize;
            }
        }
        return -1;
    }

    private static int getNumber(byte[] text, int ptrIn, int n) {
        int v = 0;
        int j = 0;
        while (j < n) {
            int c;
            if ((c = text[ptrIn++] & 0xFF) < 48 || c > 57) {
                return -1;
            }
            v = v * 10 + c - 48;
            ++j;
        }
        return v;
    }

    private int processExtensions(byte[] text, int textOffset, int textSize, byte[] data) {
        if ((this.options & 0x20) == 0) {
            return 0;
        }
        int order = 0;
        int ptrIn = 0;
        int ptrOut = 0;
        while (ptrIn < textSize) {
            if (order > 20) {
                return -1;
            }
            int c = text[textOffset + ptrIn++] & 0xFF;
            ++order;
            switch (c) {
                case 46: {
                    this.extOut = ptrIn;
                    return ptrOut;
                }
                case 101: {
                    if (ptrIn + 6 > textSize) {
                        return -1;
                    }
                    int eci = BarcodeDatamatrix.getNumber(text, textOffset + ptrIn, 6);
                    if (eci < 0) {
                        return -1;
                    }
                    ptrIn += 6;
                    data[ptrOut++] = -15;
                    if (eci < 127) {
                        data[ptrOut++] = (byte)(eci + 1);
                        break;
                    }
                    if (eci < 16383) {
                        data[ptrOut++] = (byte)((eci - 127) / 254 + 128);
                        data[ptrOut++] = (byte)((eci - 127) % 254 + 1);
                        break;
                    }
                    data[ptrOut++] = (byte)((eci - 16383) / 64516 + 192);
                    data[ptrOut++] = (byte)((eci - 16383) / 254 % 254 + 1);
                    data[ptrOut++] = (byte)((eci - 16383) % 254 + 1);
                    break;
                }
                case 115: {
                    if (order != 1) {
                        return -1;
                    }
                    if (ptrIn + 9 > textSize) {
                        return -1;
                    }
                    int fn = BarcodeDatamatrix.getNumber(text, textOffset + ptrIn, 2);
                    if (fn <= 0 || fn > 16) {
                        return -1;
                    }
                    int ft = BarcodeDatamatrix.getNumber(text, textOffset + (ptrIn += 2), 2);
                    if (ft <= 1 || ft > 16) {
                        return -1;
                    }
                    int fi = BarcodeDatamatrix.getNumber(text, textOffset + (ptrIn += 2), 5);
                    if (fi < 0 || fn >= 64516) {
                        return -1;
                    }
                    ptrIn += 5;
                    data[ptrOut++] = -23;
                    data[ptrOut++] = (byte)(fn - 1 << 4 | 17 - ft);
                    data[ptrOut++] = (byte)(fi / 254 + 1);
                    data[ptrOut++] = (byte)(fi % 254 + 1);
                    break;
                }
                case 112: {
                    if (order != 1) {
                        return -1;
                    }
                    data[ptrOut++] = -22;
                    break;
                }
                case 109: {
                    if (order != 1) {
                        return -1;
                    }
                    if (ptrIn + 1 > textSize) {
                        return -1;
                    }
                    if ((c = text[textOffset + ptrIn++] & 0xFF) != 53 && c != 53) {
                        return -1;
                    }
                    data[ptrOut++] = -22;
                    data[ptrOut++] = (byte)(c == 53 ? 236 : 237);
                    break;
                }
                case 102: {
                    if (order != 1 && (order != 2 || text[textOffset] != 115 && text[textOffset] != 109)) {
                        return -1;
                    }
                    data[ptrOut++] = -24;
                }
            }
        }
        return -1;
    }

    public int generate(String text) throws UnsupportedEncodingException {
        byte[] t = text.getBytes("iso-8859-1");
        return this.generate(t, 0, t.length);
    }

    public int generate(byte[] text, int textOffset, int textSize) {
        DmParams dm;
        byte[] data = new byte[2500];
        this.extOut = 0;
        int extCount = this.processExtensions(text, textOffset, textSize, data);
        if (extCount < 0) {
            return 5;
        }
        int e = -1;
        if (this.height == 0 || this.width == 0) {
            DmParams last = dmSizes[dmSizes.length - 1];
            e = BarcodeDatamatrix.getEncodation(text, textOffset + this.extOut, textSize - this.extOut, data, extCount, last.dataSize - extCount, this.options, false);
            if (e < 0) {
                return 1;
            }
            e += extCount;
            int k = 0;
            while (k < dmSizes.length) {
                if (BarcodeDatamatrix.dmSizes[k].dataSize >= e) break;
                ++k;
            }
            dm = dmSizes[k];
            this.height = dm.height;
            this.width = dm.width;
        } else {
            int k = 0;
            while (k < dmSizes.length) {
                if (this.height == BarcodeDatamatrix.dmSizes[k].height && this.width == BarcodeDatamatrix.dmSizes[k].width) break;
                ++k;
            }
            if (k == dmSizes.length) {
                return 3;
            }
            dm = dmSizes[k];
            e = BarcodeDatamatrix.getEncodation(text, textOffset + this.extOut, textSize - this.extOut, data, extCount, dm.dataSize - extCount, this.options, true);
            if (e < 0) {
                return 1;
            }
            e += extCount;
        }
        if ((this.options & 0x40) != 0) {
            return 0;
        }
        this.image = new byte[(dm.width + 2 * this.ws + 7) / 8 * (dm.height + 2 * this.ws)];
        BarcodeDatamatrix.makePadding(data, e, dm.dataSize - e);
        this.place = Placement.doPlacement(dm.height - dm.height / dm.heightSection * 2, dm.width - dm.width / dm.widthSection * 2);
        int full = dm.dataSize + (dm.dataSize + 2) / dm.dataBlock * dm.errorBlock;
        ReedSolomon.generateECC(data, dm.dataSize, dm.dataBlock, dm.errorBlock);
        this.draw(data, full, dm);
        return 0;
    }

    public Image createImage() throws BadElementException {
        if (this.image == null) {
            return null;
        }
        byte[] g4 = CCITTG4Encoder.compress(this.image, this.width + 2 * this.ws, this.height + 2 * this.ws);
        return Image.getInstance(this.width + 2 * this.ws, this.height + 2 * this.ws, false, 256, 0, g4, null);
    }

    public java.awt.Image createAwtImage(Color foreground, Color background) {
        if (this.image == null) {
            return null;
        }
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        int w = this.width + 2 * this.ws;
        int h = this.height + 2 * this.ws;
        int[] pix = new int[w * h];
        int stride = (w + 7) / 8;
        int ptr = 0;
        int k = 0;
        while (k < h) {
            int p = k * stride;
            int j = 0;
            while (j < w) {
                int b = this.image[p + j / 8] & 0xFF;
                pix[ptr++] = ((b <<= j % 8) & 0x80) == 0 ? g : f;
                ++j;
            }
            ++k;
        }
        java.awt.Image img = canvas.createImage(new MemoryImageSource(w, h, pix, 0, w));
        return img;
    }

    public byte[] getImage() {
        return this.image;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWs() {
        return this.ws;
    }

    public void setWs(int ws) {
        this.ws = ws;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    private static class DmParams {
        int height;
        int width;
        int heightSection;
        int widthSection;
        int dataSize;
        int dataBlock;
        int errorBlock;

        DmParams(int height, int width, int heightSection, int widthSection, int dataSize, int dataBlock, int errorBlock) {
            this.height = height;
            this.width = width;
            this.heightSection = heightSection;
            this.widthSection = widthSection;
            this.dataSize = dataSize;
            this.dataBlock = dataBlock;
            this.errorBlock = errorBlock;
        }
    }

    static class Placement {
        private int nrow;
        private int ncol;
        private short[] array;
        private static final Hashtable cache = new Hashtable();

        private Placement() {
        }

        static short[] doPlacement(int nrow, int ncol) {
            Integer key = new Integer(nrow * 1000 + ncol);
            short[] pc = (short[])cache.get(key);
            if (pc != null) {
                return pc;
            }
            Placement p = new Placement();
            p.nrow = nrow;
            p.ncol = ncol;
            p.array = new short[nrow * ncol];
            p.ecc200();
            cache.put(key, p.array);
            return p.array;
        }

        private void module(int row, int col, int chr, int bit) {
            if (row < 0) {
                row += this.nrow;
                col += 4 - (this.nrow + 4) % 8;
            }
            if (col < 0) {
                col += this.ncol;
                row += 4 - (this.ncol + 4) % 8;
            }
            this.array[row * this.ncol + col] = (short)(8 * chr + bit);
        }

        private void utah(int row, int col, int chr) {
            this.module(row - 2, col - 2, chr, 0);
            this.module(row - 2, col - 1, chr, 1);
            this.module(row - 1, col - 2, chr, 2);
            this.module(row - 1, col - 1, chr, 3);
            this.module(row - 1, col, chr, 4);
            this.module(row, col - 2, chr, 5);
            this.module(row, col - 1, chr, 6);
            this.module(row, col, chr, 7);
        }

        private void corner1(int chr) {
            this.module(this.nrow - 1, 0, chr, 0);
            this.module(this.nrow - 1, 1, chr, 1);
            this.module(this.nrow - 1, 2, chr, 2);
            this.module(0, this.ncol - 2, chr, 3);
            this.module(0, this.ncol - 1, chr, 4);
            this.module(1, this.ncol - 1, chr, 5);
            this.module(2, this.ncol - 1, chr, 6);
            this.module(3, this.ncol - 1, chr, 7);
        }

        private void corner2(int chr) {
            this.module(this.nrow - 3, 0, chr, 0);
            this.module(this.nrow - 2, 0, chr, 1);
            this.module(this.nrow - 1, 0, chr, 2);
            this.module(0, this.ncol - 4, chr, 3);
            this.module(0, this.ncol - 3, chr, 4);
            this.module(0, this.ncol - 2, chr, 5);
            this.module(0, this.ncol - 1, chr, 6);
            this.module(1, this.ncol - 1, chr, 7);
        }

        private void corner3(int chr) {
            this.module(this.nrow - 3, 0, chr, 0);
            this.module(this.nrow - 2, 0, chr, 1);
            this.module(this.nrow - 1, 0, chr, 2);
            this.module(0, this.ncol - 2, chr, 3);
            this.module(0, this.ncol - 1, chr, 4);
            this.module(1, this.ncol - 1, chr, 5);
            this.module(2, this.ncol - 1, chr, 6);
            this.module(3, this.ncol - 1, chr, 7);
        }

        private void corner4(int chr) {
            this.module(this.nrow - 1, 0, chr, 0);
            this.module(this.nrow - 1, this.ncol - 1, chr, 1);
            this.module(0, this.ncol - 3, chr, 2);
            this.module(0, this.ncol - 2, chr, 3);
            this.module(0, this.ncol - 1, chr, 4);
            this.module(1, this.ncol - 3, chr, 5);
            this.module(1, this.ncol - 2, chr, 6);
            this.module(1, this.ncol - 1, chr, 7);
        }

        private void ecc200() {
            Arrays.fill(this.array, (short)0);
            int chr = 1;
            int row = 4;
            int col = 0;
            do {
                if (row == this.nrow && col == 0) {
                    this.corner1(chr++);
                }
                if (row == this.nrow - 2 && col == 0 && this.ncol % 4 != 0) {
                    this.corner2(chr++);
                }
                if (row == this.nrow - 2 && col == 0 && this.ncol % 8 == 4) {
                    this.corner3(chr++);
                }
                if (row == this.nrow + 4 && col == 2 && this.ncol % 8 == 0) {
                    this.corner4(chr++);
                }
                do {
                    if (row >= this.nrow || col < 0 || this.array[row * this.ncol + col] != 0) continue;
                    this.utah(row, col, chr++);
                } while ((row -= 2) >= 0 && (col += 2) < this.ncol);
                ++row;
                col += 3;
                do {
                    if (row < 0 || col >= this.ncol || this.array[row * this.ncol + col] != 0) continue;
                    this.utah(row, col, chr++);
                } while ((row += 2) < this.nrow && (col -= 2) >= 0);
            } while ((row += 3) < this.nrow || ++col < this.ncol);
            if (this.array[this.nrow * this.ncol - 1] == 0) {
                this.array[this.nrow * this.ncol - this.ncol - 2] = 1;
                this.array[this.nrow * this.ncol - 1] = 1;
            }
        }
    }

    static class ReedSolomon {
        private static final int[] log;
        private static final int[] alog;
        private static final int[] poly5;
        private static final int[] poly7;
        private static final int[] poly10;
        private static final int[] poly11;
        private static final int[] poly12;
        private static final int[] poly14;
        private static final int[] poly18;
        private static final int[] poly20;
        private static final int[] poly24;
        private static final int[] poly28;
        private static final int[] poly36;
        private static final int[] poly42;
        private static final int[] poly48;
        private static final int[] poly56;
        private static final int[] poly62;
        private static final int[] poly68;

        static {
            int[] nArray = new int[256];
            nArray[1] = 255;
            nArray[2] = 1;
            nArray[3] = 240;
            nArray[4] = 2;
            nArray[5] = 225;
            nArray[6] = 241;
            nArray[7] = 53;
            nArray[8] = 3;
            nArray[9] = 38;
            nArray[10] = 226;
            nArray[11] = 133;
            nArray[12] = 242;
            nArray[13] = 43;
            nArray[14] = 54;
            nArray[15] = 210;
            nArray[16] = 4;
            nArray[17] = 195;
            nArray[18] = 39;
            nArray[19] = 114;
            nArray[20] = 227;
            nArray[21] = 106;
            nArray[22] = 134;
            nArray[23] = 28;
            nArray[24] = 243;
            nArray[25] = 140;
            nArray[26] = 44;
            nArray[27] = 23;
            nArray[28] = 55;
            nArray[29] = 118;
            nArray[30] = 211;
            nArray[31] = 234;
            nArray[32] = 5;
            nArray[33] = 219;
            nArray[34] = 196;
            nArray[35] = 96;
            nArray[36] = 40;
            nArray[37] = 222;
            nArray[38] = 115;
            nArray[39] = 103;
            nArray[40] = 228;
            nArray[41] = 78;
            nArray[42] = 107;
            nArray[43] = 125;
            nArray[44] = 135;
            nArray[45] = 8;
            nArray[46] = 29;
            nArray[47] = 162;
            nArray[48] = 244;
            nArray[49] = 186;
            nArray[50] = 141;
            nArray[51] = 180;
            nArray[52] = 45;
            nArray[53] = 99;
            nArray[54] = 24;
            nArray[55] = 49;
            nArray[56] = 56;
            nArray[57] = 13;
            nArray[58] = 119;
            nArray[59] = 153;
            nArray[60] = 212;
            nArray[61] = 199;
            nArray[62] = 235;
            nArray[63] = 91;
            nArray[64] = 6;
            nArray[65] = 76;
            nArray[66] = 220;
            nArray[67] = 217;
            nArray[68] = 197;
            nArray[69] = 11;
            nArray[70] = 97;
            nArray[71] = 184;
            nArray[72] = 41;
            nArray[73] = 36;
            nArray[74] = 223;
            nArray[75] = 253;
            nArray[76] = 116;
            nArray[77] = 138;
            nArray[78] = 104;
            nArray[79] = 193;
            nArray[80] = 229;
            nArray[81] = 86;
            nArray[82] = 79;
            nArray[83] = 171;
            nArray[84] = 108;
            nArray[85] = 165;
            nArray[86] = 126;
            nArray[87] = 145;
            nArray[88] = 136;
            nArray[89] = 34;
            nArray[90] = 9;
            nArray[91] = 74;
            nArray[92] = 30;
            nArray[93] = 32;
            nArray[94] = 163;
            nArray[95] = 84;
            nArray[96] = 245;
            nArray[97] = 173;
            nArray[98] = 187;
            nArray[99] = 204;
            nArray[100] = 142;
            nArray[101] = 81;
            nArray[102] = 181;
            nArray[103] = 190;
            nArray[104] = 46;
            nArray[105] = 88;
            nArray[106] = 100;
            nArray[107] = 159;
            nArray[108] = 25;
            nArray[109] = 231;
            nArray[110] = 50;
            nArray[111] = 207;
            nArray[112] = 57;
            nArray[113] = 147;
            nArray[114] = 14;
            nArray[115] = 67;
            nArray[116] = 120;
            nArray[117] = 128;
            nArray[118] = 154;
            nArray[119] = 248;
            nArray[120] = 213;
            nArray[121] = 167;
            nArray[122] = 200;
            nArray[123] = 63;
            nArray[124] = 236;
            nArray[125] = 110;
            nArray[126] = 92;
            nArray[127] = 176;
            nArray[128] = 7;
            nArray[129] = 161;
            nArray[130] = 77;
            nArray[131] = 124;
            nArray[132] = 221;
            nArray[133] = 102;
            nArray[134] = 218;
            nArray[135] = 95;
            nArray[136] = 198;
            nArray[137] = 90;
            nArray[138] = 12;
            nArray[139] = 152;
            nArray[140] = 98;
            nArray[141] = 48;
            nArray[142] = 185;
            nArray[143] = 179;
            nArray[144] = 42;
            nArray[145] = 209;
            nArray[146] = 37;
            nArray[147] = 132;
            nArray[148] = 224;
            nArray[149] = 52;
            nArray[150] = 254;
            nArray[151] = 239;
            nArray[152] = 117;
            nArray[153] = 233;
            nArray[154] = 139;
            nArray[155] = 22;
            nArray[156] = 105;
            nArray[157] = 27;
            nArray[158] = 194;
            nArray[159] = 113;
            nArray[160] = 230;
            nArray[161] = 206;
            nArray[162] = 87;
            nArray[163] = 158;
            nArray[164] = 80;
            nArray[165] = 189;
            nArray[166] = 172;
            nArray[167] = 203;
            nArray[168] = 109;
            nArray[169] = 175;
            nArray[170] = 166;
            nArray[171] = 62;
            nArray[172] = 127;
            nArray[173] = 247;
            nArray[174] = 146;
            nArray[175] = 66;
            nArray[176] = 137;
            nArray[177] = 192;
            nArray[178] = 35;
            nArray[179] = 252;
            nArray[180] = 10;
            nArray[181] = 183;
            nArray[182] = 75;
            nArray[183] = 216;
            nArray[184] = 31;
            nArray[185] = 83;
            nArray[186] = 33;
            nArray[187] = 73;
            nArray[188] = 164;
            nArray[189] = 144;
            nArray[190] = 85;
            nArray[191] = 170;
            nArray[192] = 246;
            nArray[193] = 65;
            nArray[194] = 174;
            nArray[195] = 61;
            nArray[196] = 188;
            nArray[197] = 202;
            nArray[198] = 205;
            nArray[199] = 157;
            nArray[200] = 143;
            nArray[201] = 169;
            nArray[202] = 82;
            nArray[203] = 72;
            nArray[204] = 182;
            nArray[205] = 215;
            nArray[206] = 191;
            nArray[207] = 251;
            nArray[208] = 47;
            nArray[209] = 178;
            nArray[210] = 89;
            nArray[211] = 151;
            nArray[212] = 101;
            nArray[213] = 94;
            nArray[214] = 160;
            nArray[215] = 123;
            nArray[216] = 26;
            nArray[217] = 112;
            nArray[218] = 232;
            nArray[219] = 21;
            nArray[220] = 51;
            nArray[221] = 238;
            nArray[222] = 208;
            nArray[223] = 131;
            nArray[224] = 58;
            nArray[225] = 69;
            nArray[226] = 148;
            nArray[227] = 18;
            nArray[228] = 15;
            nArray[229] = 16;
            nArray[230] = 68;
            nArray[231] = 17;
            nArray[232] = 121;
            nArray[233] = 149;
            nArray[234] = 129;
            nArray[235] = 19;
            nArray[236] = 155;
            nArray[237] = 59;
            nArray[238] = 249;
            nArray[239] = 70;
            nArray[240] = 214;
            nArray[241] = 250;
            nArray[242] = 168;
            nArray[243] = 71;
            nArray[244] = 201;
            nArray[245] = 156;
            nArray[246] = 64;
            nArray[247] = 60;
            nArray[248] = 237;
            nArray[249] = 130;
            nArray[250] = 111;
            nArray[251] = 20;
            nArray[252] = 93;
            nArray[253] = 122;
            nArray[254] = 177;
            nArray[255] = 150;
            log = nArray;
            alog = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 45, 90, 180, 69, 138, 57, 114, 228, 229, 231, 227, 235, 251, 219, 155, 27, 54, 108, 216, 157, 23, 46, 92, 184, 93, 186, 89, 178, 73, 146, 9, 18, 36, 72, 144, 13, 26, 52, 104, 208, 141, 55, 110, 220, 149, 7, 14, 28, 56, 112, 224, 237, 247, 195, 171, 123, 246, 193, 175, 115, 230, 225, 239, 243, 203, 187, 91, 182, 65, 130, 41, 82, 164, 101, 202, 185, 95, 190, 81, 162, 105, 210, 137, 63, 126, 252, 213, 135, 35, 70, 140, 53, 106, 212, 133, 39, 78, 156, 21, 42, 84, 168, 125, 250, 217, 159, 19, 38, 76, 152, 29, 58, 116, 232, 253, 215, 131, 43, 86, 172, 117, 234, 249, 223, 147, 11, 22, 44, 88, 176, 77, 154, 25, 50, 100, 200, 189, 87, 174, 113, 226, 233, 255, 211, 139, 59, 118, 236, 245, 199, 163, 107, 214, 129, 47, 94, 188, 85, 170, 121, 242, 201, 191, 83, 166, 97, 194, 169, 127, 254, 209, 143, 51, 102, 204, 181, 71, 142, 49, 98, 196, 165, 103, 206, 177, 79, 158, 17, 34, 68, 136, 61, 122, 244, 197, 167, 99, 198, 161, 111, 222, 145, 15, 30, 60, 120, 240, 205, 183, 67, 134, 33, 66, 132, 37, 74, 148, 5, 10, 20, 40, 80, 160, 109, 218, 153, 31, 62, 124, 248, 221, 151, 3, 6, 12, 24, 48, 96, 192, 173, 119, 238, 241, 207, 179, 75, 150, 1};
            poly5 = new int[]{228, 48, 15, 111, 62};
            poly7 = new int[]{23, 68, 144, 134, 240, 92, 254};
            poly10 = new int[]{28, 24, 185, 166, 223, 248, 116, 255, 110, 61};
            poly11 = new int[]{175, 138, 205, 12, 194, 168, 39, 245, 60, 97, 120};
            poly12 = new int[]{41, 153, 158, 91, 61, 42, 142, 213, 97, 178, 100, 242};
            poly14 = new int[]{156, 97, 192, 252, 95, 9, 157, 119, 138, 45, 18, 186, 83, 185};
            poly18 = new int[]{83, 195, 100, 39, 188, 75, 66, 61, 241, 213, 109, 129, 94, 254, 225, 48, 90, 188};
            poly20 = new int[]{15, 195, 244, 9, 233, 71, 168, 2, 188, 160, 153, 145, 253, 79, 108, 82, 27, 174, 186, 172};
            poly24 = new int[]{52, 190, 88, 205, 109, 39, 176, 21, 155, 197, 251, 223, 155, 21, 5, 172, 254, 124, 12, 181, 184, 96, 50, 193};
            poly28 = new int[]{211, 231, 43, 97, 71, 96, 103, 174, 37, 151, 170, 53, 75, 34, 249, 121, 17, 138, 110, 213, 141, 136, 120, 151, 233, 168, 93, 255};
            poly36 = new int[]{245, 127, 242, 218, 130, 250, 162, 181, 102, 120, 84, 179, 220, 251, 80, 182, 229, 18, 2, 4, 68, 33, 101, 137, 95, 119, 115, 44, 175, 184, 59, 25, 225, 98, 81, 112};
            poly42 = new int[]{77, 193, 137, 31, 19, 38, 22, 153, 247, 105, 122, 2, 245, 133, 242, 8, 175, 95, 100, 9, 167, 105, 214, 111, 57, 121, 21, 1, 253, 57, 54, 101, 248, 202, 69, 50, 150, 177, 226, 5, 9, 5};
            poly48 = new int[]{245, 132, 172, 223, 96, 32, 117, 22, 238, 133, 238, 231, 205, 188, 237, 87, 191, 106, 16, 147, 118, 23, 37, 90, 170, 205, 131, 88, 120, 100, 66, 138, 186, 240, 82, 44, 176, 87, 187, 147, 160, 175, 69, 213, 92, 253, 225, 19};
            poly56 = new int[]{175, 9, 223, 238, 12, 17, 220, 208, 100, 29, 175, 170, 230, 192, 215, 235, 150, 159, 36, 223, 38, 200, 132, 54, 228, 146, 218, 234, 117, 203, 29, 232, 144, 238, 22, 150, 201, 117, 62, 207, 164, 13, 137, 245, 127, 67, 247, 28, 155, 43, 203, 107, 233, 53, 143, 46};
            poly62 = new int[]{242, 93, 169, 50, 144, 210, 39, 118, 202, 188, 201, 189, 143, 108, 196, 37, 185, 112, 134, 230, 245, 63, 197, 190, 250, 106, 185, 221, 175, 64, 114, 71, 161, 44, 147, 6, 27, 218, 51, 63, 87, 10, 40, 130, 188, 17, 163, 31, 176, 170, 4, 107, 232, 7, 94, 166, 224, 124, 86, 47, 11, 204};
            poly68 = new int[]{220, 228, 173, 89, 251, 149, 159, 56, 89, 33, 147, 244, 154, 36, 73, 127, 213, 136, 248, 180, 234, 197, 158, 177, 68, 122, 93, 213, 15, 160, 227, 236, 66, 139, 153, 185, 202, 167, 179, 25, 220, 232, 96, 210, 231, 136, 223, 239, 181, 241, 59, 52, 172, 25, 49, 232, 211, 189, 64, 54, 108, 153, 132, 63, 96, 103, 82, 186};
        }

        ReedSolomon() {
        }

        private static int[] getPoly(int nc) {
            switch (nc) {
                case 5: {
                    return poly5;
                }
                case 7: {
                    return poly7;
                }
                case 10: {
                    return poly10;
                }
                case 11: {
                    return poly11;
                }
                case 12: {
                    return poly12;
                }
                case 14: {
                    return poly14;
                }
                case 18: {
                    return poly18;
                }
                case 20: {
                    return poly20;
                }
                case 24: {
                    return poly24;
                }
                case 28: {
                    return poly28;
                }
                case 36: {
                    return poly36;
                }
                case 42: {
                    return poly42;
                }
                case 48: {
                    return poly48;
                }
                case 56: {
                    return poly56;
                }
                case 62: {
                    return poly62;
                }
                case 68: {
                    return poly68;
                }
            }
            return null;
        }

        private static void reedSolomonBlock(byte[] wd, int nd, byte[] ncout, int nc, int[] c) {
            int i = 0;
            while (i <= nc) {
                ncout[i] = 0;
                ++i;
            }
            i = 0;
            while (i < nd) {
                int k = (ncout[0] ^ wd[i]) & 0xFF;
                int j = 0;
                while (j < nc) {
                    ncout[j] = (byte)(ncout[j + 1] ^ (k == 0 ? (byte)0 : (byte)alog[(log[k] + log[c[nc - j - 1]]) % 255]));
                    ++j;
                }
                ++i;
            }
        }

        static void generateECC(byte[] wd, int nd, int datablock, int nc) {
            int blocks = (nd + 2) / datablock;
            byte[] buf = new byte[256];
            byte[] ecc = new byte[256];
            int[] c = ReedSolomon.getPoly(nc);
            int b = 0;
            while (b < blocks) {
                int p = 0;
                int n = b;
                while (n < nd) {
                    buf[p++] = wd[n];
                    n += blocks;
                }
                ReedSolomon.reedSolomonBlock(buf, p, ecc, nc, c);
                p = 0;
                n = b;
                while (n < nc * blocks) {
                    wd[nd + n] = ecc[p++];
                    n += blocks;
                }
                ++b;
            }
        }
    }
}

