/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxASFException;
import com.informix.asf.IfxASFRemoteException;
import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDatabaseMetaData;
import com.informix.jdbc.IfxLocales;
import com.informix.jdbc.IfxNativeSQL;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMap;
import com.informix.util.IfxMessage;
import com.informix.util.IfxWarnMsg;
import com.informix.util.IxMap;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxSqliConnect
implements IfxConnection {
    private static final String JDBCExtVer = "9.201";
    private static final int JDBCIntVer = 305;
    private static final String JDBCSerialNo = "RDS#R000000";
    protected static final short HASLOG = 1;
    protected static final short ANSIMODE = 2;
    private static final short FLT2DEC = 8;
    private static final short CHGLOC = 64;
    private static final int ASFVER = 1;
    private static final int DSA722VER = 2;
    private static final int USVER = 4;
    private static final int USVER9_02 = 8;
    private static final int USVER9_03 = 16;
    private static final int USVER9_0301 = 32;
    private static final int DSA723VER = 64;
    private static final int USVER9_0303 = 128;
    private static final int USVER9_0304 = 512;
    private static final int ODS730VER = 256;
    private static final int DSA700VER = 1024;
    private static final int DSA731VER = 2048;
    private static final int DSA720VER = 4096;
    private static final int USVER9_0305 = 8192;
    private static final short NOXACT = 0;
    private static final short SXACT = 1;
    private static final short XACT = 2;
    private static final String PREFIX = "_ifxc";
    private static final String ZEROSTRING = new String("0000000000000");
    private long nextID;
    private SQLWarning connwarn;
    protected boolean isOpen = false;
    private int dbVersion;
    private int internalVersion;
    protected String externalVersion;
    protected String productName;
    private boolean floatToDec = false;
    private boolean onlineSer = false;
    private com.informix.asf.Connection asfconn;
    protected IfxProtocol proto;
    private String URL;
    protected Properties connInfo;
    protected String userName;
    private String passwd;
    private String org_url;
    protected String dbName;
    private String dbLocale;
    private String dbEncoding;
    private String clLocale;
    private String clEncoding;
    private String dbDate;
    private String glDate;
    private String dbCentury;
    private long dbTodayDate = -1L;
    private long dbTodayStart = -1L;
    Hashtable IfxToJdkEncodingTable;
    Hashtable IfxNoToJdkEncodingTable;
    Hashtable IfxToJdkLocaleTable;
    boolean Noansiwarn = true;
    protected boolean delimIdent = false;
    private boolean useV5server = false;
    private int retryCount = 1;
    String servername;
    int fetchBufSize = -1;
    private int lobCacheSize = 4096;
    private Properties PrimEnvVars;
    private Properties SecEnvVars;
    Hashtable fpCache;
    private IfxDataInputStream InputStream;
    private IfxDataOutputStream OutputStream;
    private boolean insqlexec = false;
    Trace traceObj;
    Trace protoTraceObj;
    private boolean autoCommit = true;
    private int transactionLevel = 0;
    private boolean ResetTxLevel = false;
    private short TxState = 0;
    boolean SendCommit = false;
    private boolean isDatabaseOpen = false;
    private boolean db_use_log = false;
    private boolean AnsiDb = false;
    private boolean chgLocale = false;
    private short SerWarn;
    private StringBuffer serverWarningsString = new StringBuffer("        ");
    int CapList;
    int TypeList;
    private boolean autoFree = false;
    private boolean usePut = false;
    private boolean sessionMutexLocked = false;
    private Thread lockThread;
    protected String protoClassName;
    private IfxMap udtMap;
    private IfxMap userMap;
    private boolean useTypeCache = false;
    private int internalQuery;
    private static final int IQstart = 1;
    private static final int IQsendCommit = 2;
    private String tempdir;

    public boolean isDirect() {
        return false;
    }

    public IfxSqliConnect() throws SQLException {
    }

    public IfxSqliConnect(String string, Properties properties) throws SQLException {
        String string2;
        Class[] classArray;
        Object object;
        Object object2;
        String string3;
        int n;
        int n2;
        StringTokenizer stringTokenizer;
        String string4 = null;
        String string5 = null;
        Object var6_5 = null;
        Object var7_6 = null;
        Object var8_7 = null;
        Object var9_8 = null;
        String string6 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 305;
        this.IfxToJdkEncodingTable = new Hashtable();
        this.IfxNoToJdkEncodingTable = new Hashtable();
        this.IfxToJdkLocaleTable = new Hashtable();
        this.URL = string;
        this.connInfo = properties;
        this.userName = this.connInfo.getProperty("USER");
        this.passwd = this.connInfo.getProperty("PASSWORD");
        this.dbName = this.connInfo.getProperty("DATABASE");
        this.org_url = this.connInfo.getProperty("USERURL");
        if (this.userName != null) {
            this.userName = this.userName.trim();
        }
        if (this.passwd != null) {
            this.passwd = this.passwd.trim();
        }
        if (this.dbName != null) {
            this.dbName = this.dbName.trim();
        }
        if (this.org_url != null) {
            this.org_url = this.org_url.trim();
        }
        if (this.URL != null) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(this.URL, ":");
            string4 = stringTokenizer2.nextToken();
            string5 = stringTokenizer2.nextToken();
        } else {
            string4 = null;
            string5 = null;
        }
        string6 = this.connInfo.getProperty("DBANSIWARN");
        if (string6 != null) {
            this.Noansiwarn = false;
        }
        if ((string6 = this.connInfo.getProperty("FET_BUF_SIZE")) != null) {
            try {
                this.fetchBufSize = Integer.parseInt(string6);
            }
            catch (NumberFormatException numberFormatException) {
                this.fetchBufSize = -1;
            }
        }
        if ((string6 = this.connInfo.getProperty("NEWLOCALE")) != null) {
            stringTokenizer = new StringTokenizer(string6, ":");
            n2 = stringTokenizer.countTokens();
            n = 0;
            while (n < n2) {
                string3 = stringTokenizer.nextToken();
                object2 = new StringTokenizer(string3, ",");
                object = ((StringTokenizer)object2).nextToken(",");
                if (!((StringTokenizer)object2).hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79784, this);
                }
                classArray = ((StringTokenizer)object2).nextToken();
                this.IfxToJdkLocaleTable.put(object, classArray);
                ++n;
            }
        }
        if ((string6 = this.connInfo.getProperty("NEWCODESET")) != null) {
            stringTokenizer = new StringTokenizer(string6, ":");
            n2 = stringTokenizer.countTokens();
            n = 0;
            while (n < n2) {
                string3 = stringTokenizer.nextToken();
                object2 = new StringTokenizer(string3, ",");
                object = ((StringTokenizer)object2).nextToken();
                if (!((StringTokenizer)object2).hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
                classArray = ((StringTokenizer)object2).nextToken();
                this.IfxToJdkEncodingTable.put(classArray, object);
                if (!((StringTokenizer)object2).hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
                classArray = ((StringTokenizer)object2).nextToken();
                this.IfxNoToJdkEncodingTable.put(classArray, object);
                ++n;
            }
        }
        if ((string6 = this.connInfo.getProperty("LOBCACHE")) != null) {
            try {
                this.lobCacheSize = Integer.parseInt(string6);
            }
            catch (NumberFormatException numberFormatException) {
                this.lobCacheSize = 4096;
            }
        }
        if ((string6 = this.connInfo.getProperty("INFORMIXCONRETRY")) != null) {
            try {
                int n4 = Integer.parseInt(string6);
                if (n4 >= 1) {
                    this.retryCount = n4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.retryCount = 1;
            }
        }
        if ((string6 = this.connInfo.getProperty("DELIMIDENT")) != null) {
            this.delimIdent = true;
        }
        if ((string6 = this.connInfo.getProperty("USEV5SERVER")) != null) {
            n3 = 0;
            this.useV5server = true;
        }
        if ((this.servername = this.connInfo.getProperty("INFORMIXSERVER")) == null) {
            throw IfxErrMsg.getSQLException(-79734, this);
        }
        this.tempdir = this.connInfo.getProperty("JDBCTEMP");
        if (this.tempdir != null) {
            this.tempdir = this.tempdir.trim();
            String string7 = System.getProperty("file.separator");
            if (this.tempdir.lastIndexOf(string7) != this.tempdir.length() - 1) {
                this.tempdir = String.valueOf(this.tempdir) + string7;
            }
        }
        Properties properties2 = new Properties();
        string6 = this.connInfo.getProperty("SQLH_TYPE");
        if (string6 != null) {
            ((Hashtable)properties2).put("SQLH_TYPE", string6);
            if (string6.equalsIgnoreCase("FILE")) {
                string6 = this.connInfo.getProperty("SQLH_FILE");
                if (string6 != null) {
                    ((Hashtable)properties2).put("SQLH_FILE", string6);
                }
            } else if (string6.equalsIgnoreCase("LDAP")) {
                string6 = this.connInfo.getProperty("LDAP_URL");
                if (string6 != null) {
                    ((Hashtable)properties2).put("LDAP_URL", string6);
                }
                if ((string6 = this.connInfo.getProperty("LDAP_IFXBASE")) != null) {
                    ((Hashtable)properties2).put("LDAP_IFXBASE", string6);
                }
                if ((string6 = this.connInfo.getProperty("LDAP_USER")) != null) {
                    ((Hashtable)properties2).put("LDAP_USER", string6);
                }
                if ((string6 = this.connInfo.getProperty("LDAP_PASSWD")) != null) {
                    ((Hashtable)properties2).put("LDAP_PASSWD", string6);
                }
            }
        }
        if ((string6 = this.connInfo.getProperty("SECURITY")) != null) {
            ((Hashtable)properties2).put("SECURITY", string6);
        }
        if ((string6 = this.connInfo.getProperty("PROXY")) != null) {
            ((Hashtable)properties2).put("PROXY", string6);
        }
        boolean bl3 = (string2 = this.connInfo.getProperty("ENABLE_TYPE_CACHE")) != null && string2.equalsIgnoreCase("true");
        this.useTypeCache = true;
        String string8 = string4 == null || string5 == null ? null : this.formatURL(string4, string5);
        this.PrimEnvVars = this.SetPrimEVars();
        if (this.dbEncoding != null) {
            ((Hashtable)properties2).put("DBENC", this.dbEncoding);
        }
        try {
            this.asfconn = new com.informix.asf.Connection(this.userName, this.passwd, string8, this.servername, this.dbName, this.PrimEnvVars, JDBCExtVer, n3, JDBCSerialNo, this.retryCount, properties2);
        }
        catch (IfxASFRemoteException ifxASFRemoteException) {
            object2 = ifxASFRemoteException.toString();
            int n5 = ifxASFRemoteException.getError();
            if (object2 != null && ((String)object2).length() > 0) {
                throw new SQLException(IfxMessage.getMessage(n5, (String)object2, this.getclLocale()), IfxMessage.getSQLSTATE(n5), n5);
            }
            throw IfxErrMsg.getSQLException(n5, this);
        }
        catch (IfxASFException ifxASFException) {
            object2 = ifxASFException.toString();
            int n6 = ifxASFException.getErrorId();
            if (object2 != null && ((String)object2).length() > 0) {
                throw new SQLException(IfxMessage.getMessage(n6, (String)object2, this.getclLocale()), IfxMessage.getSQLSTATE(n6), n6);
            }
            throw IfxErrMsg.getSQLException(n6, this);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79999, exception.toString(), (IfxConnection)this);
        }
        this.internalVersion = this.asfconn.Cap_1;
        string3 = this.asfconn.VersionNumber;
        try {
            int n7 = string3.indexOf("Version");
            this.productName = string3.substring(0, n7 - 1).trim();
            this.externalVersion = string3.substring(n7 + 7).trim();
        }
        catch (Exception exception) {
            this.productName = "Informix Dynamic Server";
        }
        this.SerWarn = this.asfconn.Warnings;
        this.OpenDbInit();
        if (this.dbName == null || this.dbName.length() == 0) {
            this.isDatabaseOpen = false;
        }
        if ((this.SerWarn & 8) != 0) {
            this.floatToDec = true;
        }
        this.isOpen = true;
        try {
            this.InputStream = this.asfconn.getIfxDataInputStream();
        }
        catch (IfxASFException ifxASFException) {
            try {
                this.close();
            }
            catch (Exception exception) {}
            throw IfxErrMsg.getSQLException(-79716, this);
        }
        try {
            this.OutputStream = this.asfconn.getIfxDataOutputStream();
        }
        catch (IfxASFException ifxASFException) {
            try {
                this.close();
            }
            catch (Exception exception) {}
            throw IfxErrMsg.getSQLException(-79716, this);
        }
        try {
            this.protoClassName = this.connInfo.getProperty("PROTOCOLCLASS");
            String string9 = this.connInfo.getProperty("CONNECTIONCLASS");
            object = Class.forName(string9);
            classArray = new Class[]{object};
            Class<?> clazz = Class.forName(this.protoClassName);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            this.proto = (IfxProtocol)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), (IfxConnection)this);
        }
        try {
            this.getServerVer();
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (Exception exception) {}
            throw new SQLException(sQLException.toString());
        }
        if (this.connInfo.getProperty("IFX_AUTOFREE", "0").equals("1") && this.isAutoFree()) {
            this.autoFree = true;
        }
        if (this.connInfo.getProperty("IFX_USEPUT", "0").equals("1")) {
            this.usePut = true;
        }
        this.SecEnvVars = this.SetSecEVars();
        try {
            this.proto.executeEnv(this.SecEnvVars);
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (Exception exception) {}
            throw IfxErrMsg.getSQLException(-79716, this);
        }
        this.fpCache = new Hashtable();
        if (this.isGLS()) {
            if (this.dbName != null && (this.chgLocale || this.dbEncoding == null)) {
                this.setDatabaseLocale();
            }
        } else {
            if (this.dbEncoding != null || this.clLocale != null || this.glDate != null) {
                throw IfxErrMsg.getSQLException(-79789, this);
            }
            this.dbEncoding = null;
            this.dbLocale = null;
            this.clLocale = null;
            this.clEncoding = null;
            this.glDate = null;
        }
        if (this.useV5server && this.dbName != null) {
            this.set5ServerType();
        }
    }

    public void close() throws SQLException {
        if (!this.isOpen) {
            return;
        }
        if (this.isDatabaseOpen) {
            this.CloseDbReset();
        }
        this.clearWarnings();
        this.isOpen = false;
        this.dbName = null;
        this.floatToDec = false;
        this.insqlexec = false;
        this.onlineSer = false;
        this.InputStream = null;
        this.OutputStream = null;
        this.dbVersion = 0;
        this.internalVersion = 0;
        this.externalVersion = null;
        try {
            if (this.asfconn != null) {
                this.asfconn.disconnectOrderly();
                return;
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this);
        }
    }

    public boolean isClosed() throws SQLException {
        return !this.isOpen;
    }

    public void commit() throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        if (!this.db_use_log) {
            throw IfxErrMsg.getSQLException(-79744, this);
        }
        try {
            this.proto.executeCommit();
        }
        catch (SQLException sQLException) {
            this.setTxEndState();
            throw sQLException;
        }
        catch (Exception exception) {
            this.setTxEndState();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this);
        }
        this.setTxEndState();
    }

    public void rollback() throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        if (!this.db_use_log) {
            throw IfxErrMsg.getSQLException(-79744, this);
        }
        try {
            this.proto.executeRollback();
        }
        catch (SQLException sQLException) {
            this.setTxEndState();
            throw sQLException;
        }
        catch (Exception exception) {
            this.setTxEndState();
            throw IfxErrMsg.getSQLException(-79747, exception.toString(), (IfxConnection)this);
        }
        this.setTxEndState();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        this.autoCommit = bl;
        if (this.autoCommit) {
            if (this.TxState == 2) {
                try {
                    this.proto.executeRollback();
                }
                catch (SQLException sQLException) {}
                this.setTxEndState();
                return;
            }
        } else {
            if (!this.db_use_log) {
                this.autoCommit = true;
                throw IfxErrMsg.getSQLException(-79744, this);
            }
            if (this.TxState == 1) {
                if (this.AnsiDb) {
                    this.TxState = (short)2;
                    this.SendCommit = false;
                    return;
                }
                try {
                    this.proto.executeBegin();
                }
                catch (SQLException sQLException) {
                    return;
                }
                this.setTxBeginState();
            }
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void clearWarnings() throws SQLException {
        this.connwarn = null;
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        if (this.proto != null && (sQLWarning = this.proto.getWarnings()) != null) {
            this.addWarning(sQLWarning, null);
            this.proto.clearWarnings();
        }
        return this.connwarn;
    }

    void addWarning(SQLWarning sQLWarning, String string) {
        if (sQLWarning == null) {
            sQLWarning = IfxWarnMsg.getSQLWarning(string, null, this);
        }
        if (this.connwarn == null) {
            this.connwarn = sQLWarning;
            return;
        }
        this.connwarn.setNextWarning(sQLWarning);
    }

    public Statement createStatement() throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxStatement ifxStatement = new IfxStatement(this);
        return ifxStatement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxStatement ifxStatement = new IfxStatement(this);
        ifxStatement.setResultSetType(n);
        ifxStatement.setResultSetConcurrency(n2);
        return ifxStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxPreparedStatement ifxPreparedStatement = new IfxPreparedStatement(this, string);
        return ifxPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxPreparedStatement ifxPreparedStatement = new IfxPreparedStatement(this, string);
        ifxPreparedStatement.setResultSetType(n);
        ifxPreparedStatement.setResultSetConcurrency(n2);
        return ifxPreparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxCallableStatement ifxCallableStatement = new IfxCallableStatement((Connection)this, string);
        return ifxCallableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxCallableStatement ifxCallableStatement = new IfxCallableStatement((Connection)this, string);
        ifxCallableStatement.setResultSetType(n);
        ifxCallableStatement.setResultSetConcurrency(n2);
        return ifxCallableStatement;
    }

    public IfxMap getTypeMap() throws SQLException {
        if (this.userMap == null) {
            this.userMap = new IxMap(this.isDelimIdentSet());
        }
        return this.userMap;
    }

    public synchronized void setTypeMap(IfxMap ifxMap) throws SQLException {
        this.userMap = ifxMap;
    }

    public String nativeSQL(String string) throws SQLException {
        IfxNativeSQL ifxNativeSQL = new IfxNativeSQL(string, this);
        return ifxNativeSQL.getNewString();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new IfxDatabaseMetaData(this);
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return this.getDbName();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        throw IfxErrMsg.getSQLException(-79745, this);
    }

    public boolean isReadOnly() throws SQLException {
        throw IfxErrMsg.getSQLException(-79745, this);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        String string = null;
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        if (!this.isDatabaseOpen) {
            throw IfxErrMsg.getSQLException(-349, this);
        }
        if (!this.db_use_log) {
            throw IfxErrMsg.getSQLException(-79746, this);
        }
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            throw IfxErrMsg.getSQLException(-79747, this);
        }
        if (this.TxState == 1) {
            if (!this.ResetTxLevel && n == this.transactionLevel) {
                return;
            }
            switch (n) {
                case 1: {
                    string = new String("dirty read");
                    break;
                }
                case 2: {
                    string = new String("committed read");
                    break;
                }
                case 4: 
                case 8: {
                    string = new String("repeatable read");
                }
            }
            Statement statement = this.createStatement();
            statement.executeUpdate("set isolation to " + string);
            statement.close();
        } else if (this.TxState == 2) {
            switch (n) {
                case 1: {
                    string = new String("read uncommitted");
                    break;
                }
                case 2: {
                    string = new String("read committed");
                    break;
                }
                case 4: {
                    string = new String("repeatable read");
                    break;
                }
                case 8: {
                    string = new String("serializable");
                }
            }
            Statement statement = this.createStatement();
            statement.executeUpdate("set transaction isolation level " + string);
            statement.close();
            this.ResetTxLevel = true;
        }
        this.transactionLevel = n;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.transactionLevel;
    }

    public int getDatabaseType() throws SQLException {
        if (!this.isDatabaseOpen) {
            return 0;
        }
        if (this.AnsiDb) {
            return 1;
        }
        if (this.db_use_log) {
            return 2;
        }
        return 3;
    }

    void setCapList(int n) {
        this.CapList = n;
    }

    void setTypeList(int n) {
        this.TypeList = n;
    }

    public boolean isDbOpen() throws SQLException {
        return this.isDatabaseOpen;
    }

    public String getConnectionDbName() throws SQLException {
        return this.dbName;
    }

    public String getDbName() throws SQLException {
        if (this.dbName != null) {
            return this.dbName;
        }
        if (!this.isSysmaster() || !this.isCurSessInfo()) {
            throw IfxErrMsg.getSQLException(-79700, ": IfxConnection.getDbName().", (IfxConnection)this);
        }
        try {
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery("select scs_currdb from sysmaster:informix.syssqlcurses");
            String string = null;
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
            if (string != null) {
                string = stringUtil.trimTrailings(string);
            }
            return string;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    void setDatabaseOpen(boolean bl, short s) throws SQLException {
        if (bl) {
            this.SerWarn = s;
            this.OpenDbInit();
            if (this.isGLS()) {
                this.setDatabaseLocale();
                return;
            }
        } else {
            this.CloseDbReset();
        }
    }

    public String getURL() throws SQLException {
        return this.org_url;
    }

    public String getUserName() throws SQLException {
        if (this.asfconn != null) {
            return this.asfconn.getUserName();
        }
        return this.userName;
    }

    public String getJDBCVersion() throws SQLException {
        return "1.50.JC1";
    }

    public String getDbProductName() throws SQLException {
        return this.productName;
    }

    public String getDbVersion() throws SQLException {
        if (this.externalVersion == null) {
            return "unknown";
        }
        return this.externalVersion;
    }

    private void OpenDbInit() throws SQLException {
        this.CloseDbReset();
        this.isDatabaseOpen = true;
        if ((this.SerWarn & 1) != 0) {
            this.db_use_log = true;
            this.transactionLevel = 2;
        }
        if ((this.SerWarn & 2) != 0) {
            this.AnsiDb = true;
            this.transactionLevel = 8;
        }
        if ((this.SerWarn & 0x40) != 0) {
            this.chgLocale = true;
        }
        this.TxState = !this.db_use_log ? (short)0 : 1;
        if (this.AnsiDb) {
            this.SendCommit = true;
        }
        this.clearWarnings();
        this.setWarnings();
    }

    private void CloseDbReset() {
        this.AnsiDb = false;
        this.chgLocale = false;
        this.transactionLevel = 0;
        this.autoCommit = true;
        this.db_use_log = false;
        this.isDatabaseOpen = false;
        this.TxState = 0;
        this.SendCommit = false;
        this.ResetTxLevel = false;
    }

    private void setDatabaseLocale() throws SQLException {
        try {
            String string = this.onlineSer ? "select site from informix.systables where tabname = ' GL_COLLATE'" : "select dirpath from informix.systables where tabname = ' GL_COLLATE'";
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            String string2 = null;
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
                resultSet.close();
                statement.close();
            }
            this.parseIfxLocale("db", string2.trim());
            String string3 = this.getEncNo(this.dbEncoding);
            if (string3 == null) {
                throw IfxErrMsg.getSQLException(-79783, this);
            }
            this.dbEncoding = string3;
            if (this.clLocale == null) {
                this.clEncoding = this.dbEncoding;
                String string4 = this.getLocale(this.dbLocale);
                if (string4 != null) {
                    this.clLocale = this.dbLocale;
                    return;
                }
                throw IfxErrMsg.getSQLException(-79784, this);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException.toString());
        }
    }

    protected Properties SetPrimEVars() throws SQLException {
        String string;
        String string2;
        String[] stringArray = new String[]{"INFORMIXSTACKSIZE", "DBSPACETEMP", "DBTODAY", "SLABEL", "SINGLELEVEL", "LKNOTIFY", "LOCKDOWN", "NODEFDAC", "DELIMIDENT", "SKINHIBIT", "SKALL", "SKSHOW", "DB_LOCALE", "CLIENT_LOCALE", "DBDATE", "GL_DATE", "DBCENTURY", "RASHELP", "STMT_CACHE", "STMT_CACHE_DEBUG", "IFX_LONGID"};
        Properties properties = new Properties();
        ((Hashtable)properties).put("SINGLELEVEL", "no");
        ((Hashtable)properties).put("LKNOTIFY", "yes");
        ((Hashtable)properties).put("LOCKDOWN", "no");
        ((Hashtable)properties).put("NODEFDAC", "no");
        ((Hashtable)properties).put("SKINHIBIT", "0");
        ((Hashtable)properties).put("SKALL", "0");
        ((Hashtable)properties).put("SKSHOW", "0");
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            string3 = this.connInfo.getProperty(stringArray[n]);
            if (string3 != null) {
                ((Hashtable)properties).put(stringArray[n], string3);
            }
            ++n;
        }
        String string4 = properties.getProperty("DB_LOCALE");
        if (string4 != null) {
            this.parseIfxLocale("db", string4);
            string2 = this.getEncName(this.dbEncoding);
            if (string2 == null) {
                this.dbEncoding = this.getEncNo(this.dbEncoding);
                if (this.dbEncoding == null) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
            } else {
                this.dbEncoding = string2;
            }
            this.dbLocale = this.getLocale(this.dbLocale);
            if (this.dbLocale == null) {
                throw IfxErrMsg.getSQLException(-79784, this);
            }
        } else {
            this.dbLocale = null;
            this.dbEncoding = null;
        }
        if ((string2 = properties.getProperty("CLIENT_LOCALE")) != null) {
            this.parseIfxLocale("cl", string2);
            this.clLocale = this.getLocale(this.clLocale);
            if (this.clLocale == null) {
                throw IfxErrMsg.getSQLException(-79784, this);
            }
        } else if (this.dbLocale != null && this.dbEncoding != null) {
            this.clEncoding = this.dbEncoding;
            this.clLocale = this.dbLocale;
        } else {
            this.clEncoding = null;
            this.clLocale = null;
        }
        this.dbDate = properties.getProperty("DBDATE");
        this.glDate = properties.getProperty("GL_DATE");
        if (this.dbDate == null && this.glDate == null && properties.getProperty("CLIENT_LOCALE") == null && properties.getProperty("DB_LOCALE") == null) {
            this.dbDate = "Y4MD-";
            ((Hashtable)properties).put("DBDATE", "Y4MD-");
        }
        this.dbCentury = properties.getProperty("DBCENTURY");
        if (!(this.dbCentury == null || this.dbCentury.equalsIgnoreCase("R") || this.dbCentury.equalsIgnoreCase("F") || this.dbCentury.equalsIgnoreCase("C") || this.dbCentury.equalsIgnoreCase("P"))) {
            this.dbCentury = null;
        }
        if ((string = properties.getProperty("DBTODAY")) != null) {
            try {
                this.dbTodayDate = ((Date)Timestamp.valueOf(string)).getTime();
                this.dbTodayStart = System.currentTimeMillis();
            }
            catch (Exception exception) {
                this.dbTodayDate = -1L;
                this.dbTodayStart = -1L;
            }
        }
        ((Hashtable)properties).put("DBPATH", ".");
        ((Hashtable)properties).put("IFX_UPDDESC", "1");
        return properties;
    }

    private void parseIfxLocale(String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "@");
        string2 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string2, ".");
        string3 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw IfxErrMsg.getSQLException(-79784, this);
        }
        string4 = stringTokenizer.nextToken();
        if (string == "cl") {
            this.clLocale = string3;
            this.clEncoding = string4;
            return;
        }
        this.dbLocale = string3;
        this.dbEncoding = string4;
    }

    private Properties SetSecEVars() {
        String[] stringArray = new String[]{"DBMAXPROC", "DBTEMP", "DEBUG", "DUMPCORE", "DUMPDIR", "DUMPMEM", "DUMPSHMEM", "GCORE", "NOSHMSG", "PSORT_DBTEMP", "PSORT_NPROCS", "SHELL", "TZ", "W1", "W2", "NOSORTINDEX", "SORTINDEX", "DBUPSPACE", "SUBQCACHESZ", "NO_KEYFIRST", "NO_PREDPROMOTE", "NO_SUBQF", "PDQPRIORITY", "IFX_DIRECTIVES", "IFX_NO_OROPT", "IFX_UPDDESC", "OPTCOMPIND", "INFORMIXCONRETRY", "INFORMIXOPCACHE", "SQLSTATS", "DBCENTURY", "PLCONFIG", "DBANSIWARN", "PATH", "CR_LOCKBLOB", "LOCKSSFU", "LIGHT_SCANS", "SQL_FROM_DBIMPORT", "PLOAD_LO_PATH", "OPT_GOAL", "OPTOFC"};
        Properties properties = new Properties();
        ((Hashtable)properties).put("DBTEMP", "/tmp");
        ((Hashtable)properties).put("SUBQCACHESZ", "10");
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            string = this.connInfo.getProperty(stringArray[n]);
            if (string != null) {
                ((Hashtable)properties).put(stringArray[n], string);
            }
            ++n;
        }
        return properties;
    }

    private void getServerVer() throws SQLException {
        String string = null;
        if (this.internalVersion == 0) {
            try {
                this.proto.executeVersion();
                string = this.proto.getServerVersion();
                if (this.externalVersion == null) {
                    this.externalVersion = string;
                }
            }
            catch (SQLException sQLException) {
                throw IfxErrMsg.getSQLException(-79716, sQLException.toString(), (IfxConnection)this);
            }
            this.dbVersion = string.compareTo("9.03") == 0 ? 5149 : (string.compareTo("9.02") >= 0 ? 5133 : (string.compareTo("9.00") >= 0 ? 5125 : (string.compareTo("7.31") >= 0 && string.compareTo("7.z") <= 0 ? 7491 : (string.compareTo("7.30") >= 0 && string.compareTo("7.z") <= 0 ? 5443 : (string.compareTo("7.23") >= 0 && string.compareTo("7.z") <= 0 ? 5187 : (string.compareTo("7.22") >= 0 && string.compareTo("7.z") <= 0 ? 5123 : (string.compareTo("7.20") >= 0 && string.compareTo("7.z") <= 0 ? 5121 : (string.compareTo("7.00") >= 0 ? 1025 : (string.compareTo("6.00") >= 0 ? 1 : 0)))))))));
        } else {
            this.dbVersion = 5149;
            if (this.internalVersion >= 305) {
                this.dbVersion |= 0x22A0;
            } else if (this.internalVersion >= 304) {
                this.dbVersion |= 0x2A0;
            } else if (this.internalVersion >= 303) {
                this.dbVersion |= 0xA0;
            } else if (this.internalVersion >= 301) {
                this.dbVersion |= 0x20;
            } else if (this.internalVersion < 300) {
                this.dbVersion = 0;
            }
        }
        if (this.useV5server && this.dbVersion != 0) {
            throw IfxErrMsg.getSQLException(-79762, this);
        }
    }

    IfxDataOutputStream Ifxproto_send() {
        return this.OutputStream;
    }

    IfxDataInputStream Ifxproto_receive() {
        return this.InputStream;
    }

    void setInSQLExec(boolean bl) {
        this.insqlexec = bl;
    }

    boolean getInsqlexec() {
        return this.insqlexec;
    }

    void setTxEndState() {
        if (!this.db_use_log) {
            return;
        }
        if (this.TxState == 2) {
            this.TxState = 1;
            if (this.ResetTxLevel) {
                try {
                    this.setTransactionIsolation(this.transactionLevel);
                }
                catch (SQLException sQLException) {}
                this.ResetTxLevel = false;
            }
            if (this.autoCommit) {
                if (this.AnsiDb) {
                    this.SendCommit = true;
                    return;
                }
            } else {
                if (this.AnsiDb) {
                    this.TxState = (short)2;
                    return;
                }
                try {
                    this.proto.executeBegin();
                }
                catch (SQLException sQLException) {
                    return;
                }
                this.setTxBeginState();
            }
        }
    }

    void setTxBeginState() {
        if (!this.db_use_log) {
            return;
        }
        if (this.TxState == 1) {
            this.TxState = (short)2;
            this.SendCommit = false;
        }
    }

    public boolean isDelimIdentSet() {
        return this.delimIdent;
    }

    public boolean isGLS() {
        return (this.dbVersion & 0x1000) != 0;
    }

    public boolean isOnLine() {
        return this.onlineSer;
    }

    public boolean isLongID() {
        return (this.dbVersion & 0x200) != 0;
    }

    public boolean is90303() {
        return (this.dbVersion & 0x80) != 0;
    }

    public boolean is9301() {
        return (this.dbVersion & 0x20) != 0;
    }

    public boolean isANSIJoin() {
        return (this.dbVersion & 0xA00) != 0;
    }

    boolean is903() {
        return (this.dbVersion & 0x10) != 0;
    }

    boolean is902() {
        return (this.dbVersion & 8) != 0;
    }

    public boolean isUSVER() {
        return (this.dbVersion & 4) != 0;
    }

    public boolean isIEEEM() {
        return !this.floatToDec;
    }

    public boolean isSysmaster() {
        return this.onlineSer && this.isASF();
    }

    boolean isASF() {
        return (this.dbVersion & 1) != 0;
    }

    public boolean isAutoFree() {
        return (this.dbVersion & 0xA) != 0;
    }

    boolean isDefPrep() {
        return (this.dbVersion & 0x60) != 0;
    }

    boolean isFetchArr() {
        return (this.dbVersion & 0x180) != 0;
    }

    boolean isCurSessInfo() {
        return (this.dbVersion & 0x400) != 0;
    }

    public Trace getTrace() {
        return this.traceObj;
    }

    public Trace getProtoTrace() {
        return this.protoTraceObj;
    }

    synchronized boolean lockSession() {
        return this.lockSession(-1L);
    }

    synchronized boolean lockSession(long l) {
        try {
            while (this.sessionMutexLocked) {
                if (l == -1L) {
                    Thread.yield();
                    this.wait();
                    continue;
                }
                Thread.yield();
                this.wait(l);
            }
            this.sessionMutexLocked = true;
            return true;
        }
        catch (Exception exception) {
            this.sessionMutexLocked = false;
            return false;
        }
    }

    synchronized boolean unlockSession() {
        if (this.sessionMutexLocked) {
            this.sessionMutexLocked = false;
        }
        this.notify();
        return true;
    }

    void abortSession() {
        try {
            this.close();
        }
        catch (Exception exception) {}
        this.notify();
    }

    public synchronized String getGeneratedCursor() {
        String string = Long.toString(this.nextID, 36);
        string = PREFIX + ZEROSTRING.substring(0, ZEROSTRING.length() - string.length()) + string;
        if (this.nextID++ >= Long.MAX_VALUE) {
            this.nextID = 0L;
        }
        return string;
    }

    public String getProtoClassName() {
        return this.protoClassName;
    }

    public String getConnClassName() {
        return "com.informix.jdbc.IfxSqliConnect";
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void setWarnings() {
        var1_1 = 0;
        if (this.SerWarn == 0) {
            return;
        }
        var3_2 = this.SerWarn;
        var2_3 = 1;
        while (var2_3 <= 6) {
            var1_1 = var3_2 & 1;
            if (var1_1 != 1) ** GOTO lbl30
            this.serverWarningsString.setCharAt(var2_3, 'W');
            switch (var2_3) {
                case 1: {
                    this.addWarning(null, "01I01");
                    break;
                }
                case 2: {
                    this.addWarning(null, "01I03");
                    break;
                }
                case 3: {
                    this.addWarning(null, "01I04");
                    this.onlineSer = true;
                    break;
                }
                case 4: {
                    this.addWarning(null, "01I05");
                    break;
                }
                case 5: {
                    this.addWarning(null, "01I06");
                    break;
                }
                case 6: {
                    this.addWarning(null, "01I10");
                    break;
                }
lbl30:
                // 1 sources

                this.serverWarningsString.setCharAt(var2_3, ' ');
                break;
            }
            var3_2 = (short)(var3_2 >> 1);
            var2_3 = (short)(var2_3 + 1);
        }
    }

    private String formatURL(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        return String.valueOf(string) + "," + string2;
    }

    private void setInternalQuery(boolean bl) throws SQLException {
        if (!this.AnsiDb || !this.autoCommit) {
            return;
        }
        if (this.TxState == 0) {
            return;
        }
        if (bl) {
            this.autoCommit = false;
            if (this.SendCommit) {
                this.internalQuery |= 2;
                this.SendCommit = false;
            }
            this.internalQuery |= 1;
            return;
        }
        if ((this.internalQuery & 1) > 0) {
            this.autoCommit = true;
            if ((this.internalQuery & 2) > 0) {
                this.SendCommit = true;
            }
            this.internalQuery = 0;
        }
    }

    protected IfxUDTInfo addUDTInfo(String string, String string2) throws SQLException {
        if (string2 == null) {
            return null;
        }
        ResultSet resultSet = null;
        IfxUDTInfo ifxUDTInfo = null;
        boolean bl = false;
        int n = 0;
        IfxUDTInfo[] ifxUDTInfoArray = new IfxUDTInfo[]{null, null};
        if (!this.isDbOpen()) {
            return null;
        }
        if (this.udtMap == null) {
            this.udtMap = new IxMap(this.isDelimIdentSet());
        }
        this.setInternalQuery(true);
        if (string == null) {
            string = new String("%");
        }
        try {
            PreparedStatement preparedStatement = this.prepareStatement("select extended_id, mode, owner, name, type, source, length from informix.sysxtdtypes where mode in ('R','B','D', 'C') and name like ? order by extended_id");
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            while (resultSet.next()) {
                int n2;
                int n3 = resultSet.getInt(1);
                string3 = resultSet.getString(2);
                string4 = resultSet.getString(3);
                string5 = resultSet.getString(4);
                short s = resultSet.getShort(5);
                int n4 = resultSet.getInt(6);
                int n5 = resultSet.getInt(7);
                ifxUDTInfo = this.loadUDT(n3, string3, string5, string4, s, n4, n5);
                if (string3.equals("R") || string3.equals("C")) {
                    ifxUDTInfo.structInfo = this.loadStructInfo(n3);
                }
                if (this.useTypeCache) {
                    if (this.getDatabaseType() == 1) {
                        this.udtMap.put(String.valueOf(string4) + "." + string5, ifxUDTInfo);
                    } else {
                        this.udtMap.put(string5, ifxUDTInfo);
                    }
                }
                String string6 = this.getUserName();
                String string7 = string4.trim();
                if (string7.equals(string6)) {
                    bl = true;
                    ifxUDTInfoArray[0] = ifxUDTInfo;
                    if (this.useTypeCache) continue;
                    break;
                }
                PreparedStatement preparedStatement2 = this.prepareStatement("select count(*) from informix.sysxtdtypeauth t where t.type = ? and (t.grantee in ('public', ?) or exists (select rolename from informix.sysroleauth r where t.grantee = r.rolename and r.grantee = ?) ) and t.auth in ('-u', '-U')");
                preparedStatement2.setInt(1, n3);
                preparedStatement2.setString(2, string6);
                preparedStatement2.setString(3, string6);
                ResultSet resultSet2 = preparedStatement2.executeQuery();
                if (resultSet2.next() && (n2 = resultSet2.getInt(1)) > 0) {
                    if (n == 0) {
                        ifxUDTInfoArray[1] = ifxUDTInfo;
                    }
                    ++n;
                }
                resultSet2.close();
                preparedStatement2.close();
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this.setInternalQuery(false);
            throw sQLException;
        }
        this.setInternalQuery(false);
        if (string2.equals("%")) {
            return null;
        }
        if (!bl && n == 0) {
            return null;
        }
        if (bl) {
            return ifxUDTInfoArray[0];
        }
        if (n == 1) {
            return ifxUDTInfoArray[1];
        }
        throw IfxErrMsg.getSQLException(-79770, this);
    }

    public Object loadUDTba(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, short s, int n2, int n3) {
        String string = new String(byArray, 0, 129);
        String string2 = new String(byArray2, 0, 129);
        String string3 = new String(byArray3, 0, 129);
        Vector vector = new Vector();
        IfxUDTInfo ifxUDTInfo = this.loadUDT(n, string, string2, string3, s, n2, n3);
        ifxUDTInfo.structInfo = vector;
        return ifxUDTInfo;
    }

    private IfxUDTInfo loadUDT(int n, String string, String string2, String string3, short s, int n2, int n3) {
        IfxUDTInfo ifxUDTInfo = new IfxUDTInfo();
        ifxUDTInfo.SQLtype = s & 0xFF;
        ifxUDTInfo.xid = n;
        ifxUDTInfo.JDBCtype = string.equals("B") ? (short)2000 : (string.equals("D") ? (short)2001 : (short)2002);
        ifxUDTInfo.name = string2;
        ifxUDTInfo.owner = string3;
        ifxUDTInfo.source = n2;
        if (string.equals("D") && ifxUDTInfo.source == 0) {
            ifxUDTInfo.source = s & 0xFF;
        }
        ifxUDTInfo.sourceLength = n3;
        return ifxUDTInfo;
    }

    private Vector loadStructInfo(int n) throws SQLException {
        Vector<IfxColumnInfo> vector = new Vector<IfxColumnInfo>();
        Vector<IfxColumnInfo> vector2 = new Vector<IfxColumnInfo>();
        PreparedStatement preparedStatement = this.prepareStatement("select extended_id, seqno, levelno, parent_no,        fieldname, fieldno, type, length, xtd_type_id from informix.sysattrtypes where extended_id = ? order by seqno");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = this.prepareStatement("select owner, name from informix.sysxtdtypes where extended_id = ?");
        while (resultSet.next()) {
            IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
            ifxColumnInfo.Seqno = resultSet.getShort(2);
            ifxColumnInfo.Levelno = resultSet.getShort(3);
            ifxColumnInfo.Parentno = resultSet.getShort(4);
            ifxColumnInfo.ColName = resultSet.getString(5);
            ifxColumnInfo.Fieldno = resultSet.getShort(6);
            ifxColumnInfo.SQLtype = resultSet.getShort(7);
            ifxColumnInfo.ColLength = resultSet.getShort(8);
            ifxColumnInfo.ExtendedId = resultSet.getInt(9);
            IfxResultSetMetaData.setTypeBooleanFields(ifxColumnInfo, ifxColumnInfo.SQLtype);
            ifxColumnInfo.SQLtype &= 0xFF;
            if (ifxColumnInfo.ExtendedId != 0) {
                if (ifxColumnInfo.ExtendedId == 1) {
                    ifxColumnInfo.SQLtype = 43;
                } else if (ifxColumnInfo.ExtendedId == 5) {
                    ifxColumnInfo.SQLtype = 45;
                } else if (ifxColumnInfo.ExtendedId == 10) {
                    ifxColumnInfo.SQLtype = 102;
                } else if (ifxColumnInfo.ExtendedId == 11) {
                    ifxColumnInfo.SQLtype = 101;
                } else {
                    preparedStatement2.setInt(1, ifxColumnInfo.ExtendedId);
                    ResultSet resultSet2 = preparedStatement2.executeQuery();
                    resultSet2.next();
                    ifxColumnInfo.ExtendedOwner = resultSet2.getString(1);
                    ifxColumnInfo.ExtendedName = resultSet2.getString(2);
                    resultSet2.close();
                    if (IfxTypes.isComplexType(ifxColumnInfo.SQLtype)) {
                        Vector vector3 = this.loadStructInfo(ifxColumnInfo.ExtendedId);
                        ifxColumnInfo.child = ((IfxColumnInfo)vector3.elementAt((int)0)).child;
                    }
                }
            } else {
                ifxColumnInfo.ExtendedOwner = null;
                ifxColumnInfo.ExtendedName = null;
            }
            ifxColumnInfo.Alignment = 0;
            ifxColumnInfo.SourceType = 0;
            if (ifxColumnInfo.Seqno == 1) {
                vector.addElement(ifxColumnInfo);
                if (ifxColumnInfo.child != null) continue;
                ifxColumnInfo.child = vector2;
                continue;
            }
            vector2.addElement(ifxColumnInfo);
        }
        resultSet.close();
        preparedStatement.close();
        preparedStatement2.close();
        return vector;
    }

    public void setStructInfo(Object object, short s, short s2, short s3, byte[] byArray, short s4, short s5, short s6, int n, byte[] byArray2, byte[] byArray3) throws SQLException {
        IfxUDTInfo ifxUDTInfo = (IfxUDTInfo)object;
        IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
        Vector vector = ifxUDTInfo.structInfo;
        ifxColumnInfo.Seqno = s;
        ifxColumnInfo.Levelno = s2;
        ifxColumnInfo.Parentno = s3;
        ifxColumnInfo.ColName = byArray == null ? null : new String(byArray, 0, 129);
        ifxColumnInfo.Fieldno = s4;
        ifxColumnInfo.SQLtype = s5;
        ifxColumnInfo.ColLength = s6;
        ifxColumnInfo.ExtendedId = n;
        IfxResultSetMetaData.setTypeBooleanFields(ifxColumnInfo, ifxColumnInfo.SQLtype);
        ifxColumnInfo.SQLtype &= 0xFF;
        if (ifxColumnInfo.ExtendedId != 0) {
            if (ifxColumnInfo.ExtendedId == 1) {
                ifxColumnInfo.SQLtype = 43;
            } else if (ifxColumnInfo.ExtendedId == 5) {
                ifxColumnInfo.SQLtype = 45;
            } else if (ifxColumnInfo.ExtendedId == 10) {
                ifxColumnInfo.SQLtype = 102;
            } else if (ifxColumnInfo.ExtendedId == 11) {
                ifxColumnInfo.SQLtype = 101;
            } else {
                ifxColumnInfo.ExtendedOwner = byArray2 == null ? null : new String(byArray2, 0, 129);
                ifxColumnInfo.ExtendedName = byArray3 == null ? null : new String(byArray3, 0, 129);
                if (IfxTypes.isComplexType(ifxColumnInfo.SQLtype)) {
                    IfxUDTInfo ifxUDTInfo2 = this.getUDTInfo(ifxColumnInfo.ExtendedName, ifxColumnInfo.ExtendedOwner);
                    ifxColumnInfo.child = ((IfxColumnInfo)ifxUDTInfo2.structInfo.elementAt((int)0)).child;
                }
            }
        }
        ifxColumnInfo.Alignment = 0;
        ifxColumnInfo.SourceType = 0;
        vector.addElement(ifxColumnInfo);
    }

    public IfxUDTInfo getUDTInfo(IfxColumnInfo ifxColumnInfo) throws SQLException {
        return null;
    }

    public IfxUDTInfo getUDTInfo(IfxColumnInfo ifxColumnInfo, String string) throws SQLException {
        String string2 = ifxColumnInfo == null || ifxColumnInfo.ExtendedOwner == null ? "%" : ifxColumnInfo.ExtendedOwner.trim();
        return this.getUDTInfo(string.trim(), string2);
    }

    public IfxUDTInfo getUDTInfo(String string, String string2) throws SQLException {
        IfxUDTInfo ifxUDTInfo = null;
        if (this.useTypeCache) {
            if (this.udtMap != null && (ifxUDTInfo = (IfxUDTInfo)this.udtMap.get(string.trim())) == null && this.getDatabaseType() == 1) {
                ifxUDTInfo = (IfxUDTInfo)this.udtMap.get(String.valueOf(string2) + "." + string);
            }
        }
        if (ifxUDTInfo == null) {
            ifxUDTInfo = this.addUDTInfo(string2, string.trim());
        }
        return ifxUDTInfo;
    }

    public boolean getAutoFree() {
        return this.autoFree;
    }

    public boolean getUsePut() {
        return this.usePut;
    }

    public int getBlobCacheSize() {
        return this.lobCacheSize;
    }

    protected void finalize() {
        try {
            this.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getdbDate() {
        return this.dbDate;
    }

    public String getglDate() {
        return this.glDate;
    }

    public String getdbCentury() {
        return this.dbCentury;
    }

    public String getdbLocale() {
        return this.dbLocale;
    }

    public String getdbEncoding() {
        return this.dbEncoding;
    }

    public String getclLocale() {
        return this.clLocale;
    }

    public String getclEncoding() {
        return this.clEncoding;
    }

    public String getJDBCTempDir() {
        if (this.tempdir == null) {
            this.tempdir = "";
        }
        return this.tempdir;
    }

    public boolean isANSI() {
        return this.AnsiDb;
    }

    public String getXnameByXid(int n) throws SQLException {
        this.setInternalQuery(true);
        String string = null;
        try {
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery("select name from informix.sysxtdtypes where extended_id = " + n);
            if (resultSet.next()) {
                string = resultSet.getString(1).trim();
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            this.setInternalQuery(false);
            throw sQLException;
        }
        this.setInternalQuery(false);
        return string;
    }

    private void addLocale(String string, String string2) {
        this.IfxToJdkLocaleTable.put(string, string2);
    }

    private void addEncName(String string, String string2) {
        this.IfxToJdkEncodingTable.put(string, string2);
    }

    private void addEncNumber(String string, String string2) {
        this.IfxNoToJdkEncodingTable.put(string, string2);
    }

    private String getEncName(String string) {
        String string2 = (String)this.IfxToJdkEncodingTable.get(string);
        if (string2 == null) {
            string2 = IfxLocales.FromIfxNameToJdkName(string);
        }
        return string2;
    }

    private String getEncNo(String string) {
        String string2 = (String)this.IfxNoToJdkEncodingTable.get(string);
        if (string2 == null) {
            string2 = IfxLocales.FromIfxNoToJdkName(string);
        }
        return string2;
    }

    private String getLocale(String string) {
        String string2 = (String)this.IfxToJdkLocaleTable.get(string.toLowerCase());
        if (string2 == null) {
            string2 = IfxLocales.FromIfxToJdkLocale(string);
        }
        return string2;
    }

    private void set5ServerType() throws SQLException {
        try {
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery("select colmax from informix.syscolumns c, informix.systables t where c.tabid = t.tabid and t.tabname like 'syscolumns'");
            this.onlineSer = true;
            resultSet.close();
            statement.close();
            return;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -217) {
                this.onlineSer = false;
                return;
            }
            throw sQLException;
        }
    }

    void xaSetSerWarnFlags(short s, String string) throws SQLException {
        block5: {
            block4: {
                int n = 0;
                IfxPreparedStatement ifxPreparedStatement = null;
                this.dbName = string;
                try {
                    try {
                        ifxPreparedStatement = new IfxPreparedStatement(this, "select * from systables where owner = 'informix'");
                    }
                    catch (Exception exception) {
                        n = ((SQLException)exception).getErrorCode();
                    }
                    Object var6_6 = null;
                    if (n != -206) break block4;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    s = n == -206 ? (short)(s | 2) : (short)(s | 1);
                    throw throwable;
                }
                s = (short)(s | 2);
                break block5;
            }
            s = (short)(s | 1);
        }
        this.SerWarn = (short)(this.SerWarn | s);
        this.OpenDbInit();
    }

    public IfxProtocol getProto() {
        return this.proto;
    }

    public IfxProtocol createProto() {
        return new IfxSqli(this);
    }

    public int getFetchBufSize() {
        return this.fetchBufSize;
    }

    public long getdbTodayDate() {
        return this.dbTodayDate;
    }

    public long getdbTodayStart() {
        return this.dbTodayStart;
    }
}

