/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxUDTInput;
import java.sql.SQLException;

public class IfxLoStat {
    private static final short LO_STAT_SIZE = 644;
    private static final short PRE_LONG_ID_LO_STAT_SIZE = 212;
    private long lobSize;
    private int lobUID;
    private int lastAccessTime;
    private int lastModifyTimeS;
    private int lastModifyTimeM;
    private int lastStatusTime;
    private int refCount;
    private IfxLobDescriptor lobDescriptor;
    private IfxConnection conn;

    IfxLoStat() {
    }

    IfxLoStat(IfxConnection ifxConnection, byte[] byArray) throws SQLException {
        int n;
        this.conn = ifxConnection;
        if (ifxConnection.isLongID()) {
            int n2 = 644;
            n = 596;
        } else {
            int n3 = 212;
            n = 164;
        }
        IfxUDTInput ifxUDTInput = new IfxUDTInput(ifxConnection, byArray, 0, byArray.length);
        ifxUDTInput.readInt();
        this.lobSize = ifxUDTInput.readLong();
        ifxUDTInput.readShort();
        this.lobUID = ifxUDTInput.readInt();
        this.lastAccessTime = ifxUDTInput.readInt();
        this.lastModifyTimeS = ifxUDTInput.readInt();
        this.lastModifyTimeM = ifxUDTInput.readInt();
        this.lastStatusTime = ifxUDTInput.readInt();
        this.refCount = ifxUDTInput.readInt();
        this.lobDescriptor = new IfxLobDescriptor(ifxConnection, ifxUDTInput.readBytes(n));
    }

    public long getSize() {
        return this.lobSize;
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public int getLastStatusTime() {
        return this.lastStatusTime;
    }

    public int getLastModifyTimeS() {
        return this.lastModifyTimeS;
    }

    public int getLastModifyTimeM() {
        return this.lastModifyTimeM;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public IfxLobDescriptor getLobDescriptor() {
        return this.lobDescriptor;
    }

    int length() {
        IfxConnection ifxConnection = this.conn;
        if (ifxConnection.isLongID()) {
            return 644;
        }
        return 212;
    }

    static int size(IfxConnection ifxConnection) {
        if (ifxConnection.isLongID()) {
            return 644;
        }
        return 212;
    }
}

