/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.base.entity.UserRelation;
import com.fr.fs.comparator.ComparatorHelper;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.FArray;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSetAuthGetFilterUserInfoAction
extends ActionNoSessionCMD {
    private static Map<String, Comparator> comparatorMap = new HashMap<String, Comparator>();
    private static Map<String, Comparator> stupidComparatorMap = new HashMap<String, Comparator>();

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 3L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"startIdx");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"count");
        int n = 0;
        int n2 = 0;
        if (StringUtils.isNotEmpty((String)string)) {
            n = Integer.valueOf(string);
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            n2 = Integer.valueOf(string2);
        }
        JSONObject jSONObject = this.getFilterUserInfo(l, n, n2, httpServletRequest);
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    public String getCMD() {
        return "auth_getalluserinfo";
    }

    private JSONObject getFilterUserInfo(long l, int n, int n2, HttpServletRequest httpServletRequest) throws Exception {
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"keyword");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"sortBy");
        JSONObject jSONObject = new JSONObject();
        List<User> list = this.getFilterAuthUser(l, string);
        jSONObject.put("users", (Object)(comparatorMap.containsKey(string2) ? this.getSortedUserInfoByInnerAttr(n, n2, list, httpServletRequest) : this.getSortUserInfoByOtherAttr(n, n2, list, httpServletRequest)));
        jSONObject.put("total", list.size());
        return jSONObject;
    }

    private JSONArray getSortedUserInfoByInnerAttr(int n, int n2, List<User> list, HttpServletRequest httpServletRequest) throws Exception {
        boolean bl = WebUtils.getHTTPRequestBoolParameter((HttpServletRequest)httpServletRequest, (String)"asc");
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"sortBy");
        Collections.sort(list, comparatorMap.get(string));
        if (!bl) {
            Collections.reverse(list);
        }
        int n3 = Math.min(n2 + n, list.size());
        HashMap hashMap = new HashMap(32);
        JSONArray jSONArray = new JSONArray();
        if (n >= 0) {
            for (int i = n; i < n3; ++i) {
                User user = list.get(i);
                JSONObject jSONObject = user.createUnEditInfoJSONConfig();
                FArray fArray = UserControl.getInstance().getAllSRoleNames(user.getId());
                jSONObject.put("role", (Object)StableUtils.join((Collection)fArray.toList(), (String)"; "));
                String string2 = this.getJob(user, hashMap);
                if (StringUtils.isNotBlank((String)string2)) {
                    jSONObject.put("depart", (Object)this.getJob(user, hashMap));
                }
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    private JSONArray getSortUserInfoByOtherAttr(int n, int n2, List<User> list, HttpServletRequest httpServletRequest) throws Exception {
        boolean bl = WebUtils.getHTTPRequestBoolParameter((HttpServletRequest)httpServletRequest, (String)"asc");
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"sortBy");
        int n3 = Math.min(n2 + n, list.size());
        HashMap hashMap = new HashMap(32);
        ArrayList<UserRelation> arrayList = new ArrayList<UserRelation>();
        for (User user : list) {
            FArray fArray = UserControl.getInstance().getAllSRoleNames(user.getId());
            String string2 = StableUtils.join((Collection)fArray.toList(), (String)"; ");
            UserRelation userRelation = new UserRelation(user, this.getJob(user, hashMap), string2);
            arrayList.add(userRelation);
        }
        Collections.sort(arrayList, stupidComparatorMap.get(string));
        if (!bl) {
            Collections.reverse(arrayList);
        }
        JSONArray jSONArray = JSONArray.create();
        if (n >= 0) {
            for (int i = n; i < n3; ++i) {
                jSONArray.put((Object)((UserRelation)arrayList.get(i)).toJSONObject());
            }
        }
        return jSONArray;
    }

    private List<User> getFilterAuthUser(long l, String string) throws Exception {
        List list = !FSConfig.getProviderInstance().getAuthorizeAttr().isGradeAuthority() ? UserControl.getInstance().findAllUser() : UserControl.getInstance().findAllAuthUser(l);
        if (StringUtils.isEmpty((String)string)) {
            return list;
        }
        ArrayList<User> arrayList = new ArrayList<User>();
        for (User user : list) {
            if (!this.isKeywordInUserInfo(user.createUnEditInfoJSONConfig(), string)) continue;
            arrayList.add(user);
        }
        return arrayList;
    }

    private String getJob(User user, Map map) throws Exception {
        Set set = UserControl.getInstance().getJobs(user.getId());
        if (set != null) {
            Iterator iterator = set.iterator();
            String string = "";
            while (iterator.hasNext()) {
                RelationObject relationObject = (RelationObject)iterator.next();
                long l = (Long)relationObject.getValue(Department.class);
                String string2 = DepartmentControl.getInstance().getDepartmentShowName(l, ",");
                if (string2 == null) continue;
                String string3 = (String)map.get(relationObject.getValue(Post.class));
                if (string3 == null) {
                    string3 = PostControl.getInstance().getPostName((Long)relationObject.getValue(Post.class));
                    if (string3 == null) continue;
                    map.put(relationObject.getValue(Post.class), string3);
                    string = string + string2 + "-" + string3 + " ";
                    continue;
                }
                string = string + string2 + "-" + string3 + " ";
            }
            return string;
        }
        return " ";
    }

    private boolean isKeywordInUserInfo(JSONObject jSONObject, String string) {
        if (jSONObject.optString("username", "").toLowerCase().contains(string.toLowerCase())) {
            return true;
        }
        if (jSONObject.optString("realname", "").toLowerCase().contains(string.toLowerCase())) {
            return true;
        }
        if (jSONObject.optString("mobile", "").toLowerCase().contains(string.toLowerCase())) {
            return true;
        }
        return jSONObject.optString("email", "").toLowerCase().contains(string.toLowerCase());
    }

    static {
        comparatorMap.put("username", ComparatorHelper.USER_USERNAME_COMPARATOR);
        comparatorMap.put("realname", ComparatorHelper.USER_REALNAME_COMPARATOR);
        stupidComparatorMap.put("depart", ComparatorHelper.USER_DEPART_COMPARATOR);
        stupidComparatorMap.put("role", ComparatorHelper.USER_ROLE_COMPARATOR);
    }
}

