/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DatabaseAction;
import com.fr.fs.base.entity.UserDeviceInfo;
import com.fr.fs.dao.PlatformDataAccessObject;
import com.fr.stable.StringUtils;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDeviceDao
extends PlatformDataAccessObject {
    private static final UserDeviceDao SC = new UserDeviceDao();

    public static UserDeviceDao getInstance() {
        return SC;
    }

    private UserDeviceDao() {
    }

    public void save(UserDeviceInfo userDeviceInfo) throws Exception {
        if (userDeviceInfo == null) {
            return;
        }
        this.createSession().save((Object)userDeviceInfo);
    }

    public void transfer(UserDeviceInfo userDeviceInfo) throws Exception {
        this.createSession(DatabaseAction.TRANSFER).transfer((Object)userDeviceInfo);
    }

    public boolean saveOrUpdate(UserDeviceInfo userDeviceInfo) throws Exception {
        return this.createSession().saveOrUpdate((Object)userDeviceInfo);
    }

    public boolean update(UserDeviceInfo userDeviceInfo) throws Exception {
        if (userDeviceInfo == null) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            boolean bl = dataAccessObjectSession.update((Object)userDeviceInfo);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public boolean delete(UserDeviceInfo userDeviceInfo) throws Exception {
        if (userDeviceInfo == null) {
            return false;
        }
        return this.deleteByID(userDeviceInfo.getId());
    }

    public boolean deleteByID(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            boolean bl = dataAccessObjectSession.deleteByPrimaryKey(UserDeviceInfo.class, l);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public boolean unbind(String string, String string2, boolean bl) throws Exception {
        boolean bl2;
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
            hashMap.put("username", string);
            if (StringUtils.isBlank((String)string2)) {
                hashMap.put("passed", bl);
            } else {
                hashMap.put("macAddress", string2);
            }
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            boolean bl3 = dataAccessObjectSession.deleteByFields(UserDeviceInfo.class, hashMap);
            dataAccessObjectSession.commit();
            bl2 = bl3;
        }
        catch (Exception exception) {
            try {
                this.rollbackSession(dataAccessObjectSession);
                throw exception;
            }
            catch (Throwable throwable) {
                this.closeSession(dataAccessObjectSession);
                throw throwable;
            }
        }
        this.closeSession(dataAccessObjectSession);
        return bl2;
    }

    public void bind(String string, String string2, String string3) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(1);
            hashMap.put("passed", true);
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            if (StringUtils.isNotBlank((String)string2)) {
                UserDeviceInfo userDeviceInfo = this.findDeviceInfoByUM(string, string2);
                if (userDeviceInfo != null) {
                    userDeviceInfo.setPassed(true);
                    userDeviceInfo.setDeviceName(string3);
                    dataAccessObjectSession.update((Object)userDeviceInfo);
                } else {
                    this.save(new UserDeviceInfo(string, string2, string3, true));
                }
            } else {
                List<UserDeviceInfo> list = this.findByUserName(string);
                if (list != null) {
                    for (UserDeviceInfo userDeviceInfo : list) {
                        userDeviceInfo.setPassed(true);
                        dataAccessObjectSession.update((Object)userDeviceInfo);
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            try {
                this.rollbackSession(dataAccessObjectSession);
                throw exception;
            }
            catch (Throwable throwable) {
                this.closeSession(dataAccessObjectSession);
                throw throwable;
            }
        }
        this.closeSession(dataAccessObjectSession);
    }

    public boolean deleteByUsername(String string) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            HashMap<String, String> hashMap = new HashMap<String, String>(1);
            hashMap.put("username", string);
            boolean bl = dataAccessObjectSession.deleteByFields(UserDeviceInfo.class, hashMap);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public List<UserDeviceInfo> findByUserName(String string) throws Exception {
        return this.createSession().listByFieldValue(UserDeviceInfo.class, "username", (Object)string);
    }

    public List<UserDeviceInfo> findAll() throws Exception {
        return this.createSession().list(UserDeviceInfo.class);
    }

    public List<UserDeviceInfo> findDeviceInfoByMacAddress(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.createSession().listByFieldValue(UserDeviceInfo.class, "macAddress", (Object)string);
    }

    public UserDeviceInfo findDeviceInfoByUM(String string, String string2) {
        if (StringUtils.isEmpty((String)string) || StringUtils.isEmpty((String)string2)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("username", string);
        hashMap.put("macAddress", string2);
        List list = this.createSession().listByFieldValues(UserDeviceInfo.class, hashMap);
        if (list != null && list.size() > 0) {
            return (UserDeviceInfo)((Object)list.get(0));
        }
        return null;
    }
}

