/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.base.entity.HomePage;
import com.fr.fs.cache.HomePageCache;
import com.fr.fs.cache.HomePageCacheProvider;
import com.fr.general.GeneralContext;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.EnvChangedListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePageCacheImpl
implements HomePageCacheProvider {
    private static HomePageCacheProvider homePageCacheProvider;

    public static HomePageCacheProvider getInstance() {
        if (homePageCacheProvider == null) {
            HomePageCacheImpl.initCacheImpl();
        }
        return homePageCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                homePageCacheProvider = new HomePageCacheImpl();
                RPC.registerSkeleton((Object)homePageCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                homePageCacheProvider = (HomePageCacheProvider)RPC.getProxy(HomePageCacheImpl.class, (String)string);
                break;
            }
            default: {
                homePageCacheProvider = new HomePageCacheImpl();
            }
        }
    }

    @Override
    public void initHomePageCache() throws Exception {
        HomePageCache.initHomePageCache();
    }

    @Override
    public void reInit() throws Exception {
        HomePageCache.reInit();
    }

    @Override
    public boolean containCache(long l) {
        return HomePageCache.containCache(l);
    }

    @Override
    public int getHomePageCount() {
        return HomePageCache.getHomePageCount();
    }

    @Override
    public List<HomePage> getAllHomePages() {
        return HomePageCache.getAllHomePages();
    }

    @Override
    public HomePage[] getAllHomePagesSorted() {
        return HomePageCache.getAllHomePagesSorted();
    }

    @Override
    public JSONArray getAllHomePageInfo() throws JSONException {
        return HomePageCache.getAllHomePageInfo();
    }

    @Override
    public HomePage getHomePage(long l) {
        return HomePageCache.getHomePage(l);
    }

    @Override
    public JSONObject getHomePageInfo(long l) throws Exception {
        return HomePageCache.getHomePageInfo(l);
    }

    @Override
    public void cache(HomePage homePage) {
        HomePageCache.cache(homePage);
    }

    @Override
    public void removeCache(long l) {
        HomePageCache.removeCache(l);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                HomePageCacheImpl.homePageCacheProvider = null;
            }
        });
    }
}

