/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.base.entity.Department;
import com.fr.fs.cache.DepartmentCache;
import com.fr.fs.cache.DepartmentCacheProvider;
import com.fr.fs.cache.DepartmentTreeNode;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;

public class DepartmentCacheImpl
implements DepartmentCacheProvider {
    private static DepartmentCacheProvider departmentCacheProvider;

    public static DepartmentCacheProvider getInstance() {
        if (departmentCacheProvider == null) {
            DepartmentCacheImpl.initCacheImpl();
        }
        return departmentCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                departmentCacheProvider = new DepartmentCacheImpl();
                RPC.registerSkeleton((Object)departmentCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                departmentCacheProvider = (DepartmentCacheProvider)RPC.getProxy(DepartmentCacheImpl.class, (String)string);
                break;
            }
            default: {
                departmentCacheProvider = new DepartmentCacheImpl();
            }
        }
    }

    public void initCacheTree() {
        DepartmentCache.initCacheTree();
    }

    public void reInit() {
        DepartmentCache.reInit();
    }

    public void clearCache() throws Exception {
        DepartmentCache.clearCache();
    }

    public void cache(Department department) {
        DepartmentCache.cache(department);
    }

    public void cacheNewName(long l, String string) {
        DepartmentCache.cacheNewName(l, string);
    }

    public DepartmentTreeNode getRootNode() {
        return DepartmentCache.getRootNode();
    }

    public Department getDepartment(long l) {
        return DepartmentCache.getDepartment(l);
    }

    public Long[] getDpidsByPid(long l) {
        return DepartmentCache.getDpidsByPid(l);
    }

    public Department getDepartmentByNameAndPid(String string, long l) {
        return DepartmentCache.getDepartmentByNameAndPid(string, l);
    }

    public String getShowDepartmentName(long l, String string) {
        return DepartmentCache.getShowDepartmentName(l, string);
    }

    public Long[] getDepartmentPath(long l) {
        return DepartmentCache.getDepartmentPath(l);
    }

    public boolean removeCache(long l) throws Exception {
        return DepartmentCache.removeCache(l);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                DepartmentCacheImpl.departmentCacheProvider = null;
            }
        });
    }
}

